!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    5plot.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
PROGRAM bear2fix
  USE BearIO
  USE GlobalDeclarations
  USE COOL
  IMPLICIT NONE
  REAL,PARAMETER :: PI=3.14159265
  REAL(KIND=qprec) :: lunit,lconvertplot
  INTEGER :: frame,frameend,step,coarseRatio,operation,application,maxHotBox,n,i,iErr,scaling

  REAL,DIMENSION(6,2) :: scales

  CHARACTER(LEN=21) :: TreeFile
  CHARACTER(LEN=17) :: FileName
  CHARACTER(LEN=100) :: PlotLabel
  !
  CALL  InitGD
  !CALL initneqCool
  !lunit=lscale
  !lunit=AU
  lunit=1.d0
  !lunit=dxFine(1)*2.
  lconvertplot=lscale/lunit
  !

  CALL GETFRAMES(frame,frameend)

  coarseRatio=1
  qnvars=NrVars
  maxHotBox=3

  PRINT*,' ------'
  PRINT*,' This program will plot log10(n) w/ contours, n, vx, vy, v and pressure.'
  PRINT*,' ------'
  PRINT*,'What frame scaling?'
  PRINT*,'0=relative'
  WRITE(*,'(A)',ADVANCE='NO') ' 1=absolute ' 
  READ*,scaling




  ! First go through all frames and collect data, to find overall max/min scalings (this DO statement).
  ! Then go back through and write the frames' data (the next DO statement).
  ! Define "step" to be such that no more than 10 frames evenly spaced in the series are read.
  step=1
  IF(frameend-frame .gt. 10) step = CEILING((REAL(frameend)-REAL(frame))/10.)


  
  DO n=frame,frameend,step
     IF(scaling .eq. 0) EXIT
     PRINT*,' reading frame ',n
     ! read the data
     pnvars=qnvars

     CALL CreateFixedGrid(n,coarseRatio)
     !
     CALL ProcessHydro(.FALSE.)
     
     IF(n .eq. frame) THEN !This is the initial frame
        DO i=1,5
           scales(i,1) = MINVAL(pFix(:,:,1,i))
           scales(i,2) = MAXVAL(pFix(:,:,1,i))
        ENDDO
     ELSE
        DO i=1,5
           scales(i,1) = MIN(scales(i,1), MINVAL(pFix(:,:,1,i)))
           scales(i,2) = MAX(scales(i,2), MAXVAL(pFix(:,:,1,i)))
        ENDDO
     ENDIF
  ENDDO

  ! Make density log10(density)
  scales(1,:) = log10(scales(1,:))

  step=1
  DO n=frame,frameend,step
     PRINT*,' processing frame ',n

     CALL CreateFixedGrid(n,coarseRatio)
     CALL ProcessHydro(.FALSE.)
     !
     pFix(:,:,1,1) = log10(pFix(:,:,1,1))
     
     IF(scaling .eq. 0) THEN
        DO i=1,5
           scales(i,1) = MINVAL(pFix(:,:,1,i))
           scales(i,2) = MAXVAL(pFix(:,:,1,i))
        ENDDO
     ENDIF

     CALL PlotFrame(1,mxFix(1),1,mxFix(2))
  ENDDO


CONTAINS ! Processing Routines added here:


  SUBROUTINE ProcessHydro(lWrite)
    USE BearIO
    LOGICAL lWrite
    INTEGER :: i,j,k,nv
    CALL PrimitiveInit(qnvars)
    ! fill the primitive field
    CALL Primitive(qn,1)
    CALL Primitive(qvx,2)
    CALL Primitive(qvy,3)
    CALL Primitive(qv,4)
    CALL Primitive(qP,5)

    ! possible variables to request (as listed in bear2fixIO):
    !  qn,   qrho, qvx, qvy, qvz, qv, qEth, qP, qTemp, qemission,
    !  qcs, mEtot, mbx, mby, mbz, beta
  END SUBROUTINE ProcessHydro


  SUBROUTINE PlotFrame(i1,i2,j1,j2)
    USE BearIO
    INTEGER i,j,k,l,i1,j1,i2,j2
    LOGICAL :: lHot
    INTEGER C1,C2,NC,mxi,mxj
    INTEGER PGOPEN
    CHARACTER(LEN=14) :: fileName
    !
    REAL,DIMENSION(21) :: C
    REAL,DIMENSION(mxfix(1),mxfix(2),5) :: F
    REAL,DIMENSION(5) :: FMIN,FMAX
    REAL,DIMENSION(6) :: TR
    REAL,DIMENSION(4) :: XL,XU
    REAL,DIMENSION(5) :: xBoxPoints,yBoxPoints
    REAL BRIGHT,CONTRA
    !
    CHARACTER(LEN=12),DIMENSION(5) :: names

    names = (/'log\d10\u(n)','v\dx        ','v\dy        ','v           ','P           '/)


    F = pFix(:,:,1,:)
    DO i=1,5
       FMIN(i) = scales(i,1)
       FMAX(i) = scales(i,2)
       IF(FMIN(i) .eq. FMAX(i)) THEN
          IF(FMIN(i) .ne. 0) THEN
             FMIN(i) = 0.95*FMIN(i)
             FMAX(i) = 1.05*FMAX(i)
          ELSE
             FMIN(i) = -1d-6
             FMAX(i) = 1d-6
          ENDIF
       ENDIF
    ENDDO

    mxi=i2-i1+1;mxj=j2-j1+1
    !
    XL(1)=(XLower(1)+dxfix(1)*(i1-1))*lconvertplot;XU(1)=(XUpper(1)-dxfix(1)*(mxfix(1)-i2))*lconvertplot
    XL(2)=(XLower(2)+dxfix(2)*(j1-1))*lconvertplot;XU(2)=(XUpper(2)-dxfix(2)*(mxfix(2)-j2))*lconvertplot
    TR(1) = XL(1)-0.5*(XU(1)-XL(1))/REAL(mxi)
    TR(2) = (XU(1)-XL(1))/REAL(mxi)
    TR(3) = 0.0
    TR(4) = XL(2)-0.5*(XU(2)-XL(2))/REAL(mxj)
    TR(5) = 0.0
    TR(6) = (XU(2)-XL(2))/REAL(mxj)


    WRITE(fileName,'(A9,I5.5)')'out/p5out',n
    ! open pgplot color postscript device
    IF (PGOPEN(FileName//'.ps/cps') .LT. 1) STOP
    ! make subplots with one row, five columns
    !!$ CALL PGSUBP(5,1)
    ! make subplots with five rows, one column
    CALL PGSUBP(1,5)
    ! setup color table
    CALL PGQCIR(C1, C2)
    NC = MAX(0, C2-C1+1)
    ! clear screen, setup window and viewport
    BRIGHT = 0.5
    CONTRA = 1.0
    DO i=1,5
       IF(i .eq. 1) THEN
          CALL PGSLW(2)
          CALL PGPAGE
          CALL SETVP
          CALL PGWNAD(XL(1), XU(1), XL(2), XU(2))
          ! setup color map
          CALL PALETT(2, CONTRA, BRIGHT)
          !Draw the image
          CALL PGIMAG(F(:,:,i),mxfix(1),mxfix(2),i1,i2,j1,j2,FMIN(i),FMAX(i),TR)
          ! set the color
          CALL PGSCI(0)
          C = (/ (j*0.05*(FMAX(1)-FMIN(1))+FMIN(1), j=0,20) /)
          CALL PGCONT(F,mxfix(1),mxfix(2),i1,i2,j1,j2,C,-21,TR)
          CALL PGSCI(1)
          CALL PGSCH(3.)
          CALL PGMTXT('t',1.0,0.0,0.0,'')
          CALL PGMTXT('b',3.0,1.0,1.0,'')
          CALL PGBOX('bcntsi',0.0,0,'bcntsiv',0.0,0)
          CALL PGWEDG('RI', 1.0, 4.0, FMIN(i), FMAX(i), names(i))
       ELSE
          CALL PGPAGE
          CALL SETVP
          CALL PGWNAD(XL(1), XU(1), XL(2), XU(2))
          ! setup color map
          CALL PALETT(2, CONTRA, BRIGHT)
          !Draw the image
          CALL PGIMAG(F(:,:,i),mxfix(1),mxfix(2),i1,i2,j1,j2,FMIN(i),FMAX(i),TR)
          ! set the color
          CALL PGSCI(1)
          IF(maxHotBox .ne. -1) THEN
             CALL PGSLW (2)
             DO j=1,nGrids
                IF(gridLevels(j)<=maxHotBox) THEN
                   xBoxPoints(1)=gridBounds(j,1)
                   yBoxPoints(1)=gridBounds(j,2)
                   xBoxPoints(2)=gridBounds(j,4)
                   yBoxPoints(2)=gridBounds(j,2)
                   xBoxPoints(3)=gridBounds(j,4)
                   yBoxPoints(3)=gridBounds(j,5)
                   xBoxPoints(4)=gridBounds(j,1)
                   yBoxPoints(4)=gridBounds(j,5)
                   xBoxPoints(5)=gridBounds(j,1)
                   yBoxPoints(5)=gridBounds(j,2)
                   xBoxPoints=xBoxPoints*lconvertplot
                   yBoxPoints=yBoxPoints*lconvertplot
                   CALL PGLINE (5, xBoxPoints, yBoxPoints)
                END IF
             END DO
          ENDIF
          !Annotate the plot.
          CALL PGSCH(3.)
          CALL PGMTXT('t',1.0,0.0,0.0,'')
          CALL PGMTXT('b',3.0,1.0,1.0,'')
          CALL PGBOX('bcntsi',0.0,0,'bcntsiv',0.0,0)
          ! draw color wedge
          CALL PGWEDG('RI', 1.0, 4.0, FMIN(i), FMAX(i), names(i))
       ENDIF
    ENDDO
    CALL PGEND
  END SUBROUTINE PlotFrame


  SUBROUTINE GETFRAMES(framestart,frameend)
    INTEGER,INTENT(INOUT) :: framestart
    INTEGER,INTENT(OUT)   :: frameend
    INTEGER :: iErr, iErr2
    
    WRITE(*,'(A)',ADVANCE='NO')'select data set (Enter -1 for all frames, -2 to specify a range) '
    READ*,frame
    
    frameend=frame;step=1
    IF(frame==-1 .or. frame==-3 .or. frame==-4) THEN
       n=0;frame=0
          DO WHILE (iErr==0 .OR. iErr2==0)
             WRITE(TreeFile,'(A10,I5.5,A4)')'./out/tree',n,'.dat'
             OPEN(UNIT=77,FILE=TreeFile,STATUS='OLD',IOSTAT=iErr)
             CLOSE(UNIT=77)
             WRITE(TreeFile,'(A12,I5.5,A4)')'./out/chombo',n,'.dat'
             OPEN(UNIT=77,FILE=TreeFile,STATUS='OLD',IOSTAT=iErr2)
             CLOSE(UNIT=77)
             n=n+1
          END DO
       END DO
999    frameend=n-2
    ELSE IF(frame==-5) THEN
       n=1;frame=1;frameend=1
    ELSE IF(frame==-2) THEN
       PRINT*,'what frames? (set end frame=-1 to select all frames after begin frame)'
       WRITE(*,'(A)',ADVANCE='NO')' begin frame, end frame? '
       READ*,frame,frameend
       IF(frameend==-1) THEN
          n=frame
          DO WHILE (.TRUE.)
             WRITE(TreeFile,'(A10,I5.5,A4)')'./out/tree',n,'.dat'
             OPEN(UNIT=77,FILE=TreeFile,STATUS='OLD',ERR=998)
             n=n+1
             CLOSE(UNIT=77)
          END DO
998       frameend=n-1
          IF(frameend < frame) THEN
             PRINT*,' !!!Error, begin frame greater than # frames in directory.'
             STOP
          ENDIF
          PRINT '(A24,i4.1,A4,i4.1)','    will process frames ',frame,' to ',frameend
       ENDIF
    END IF
    IF(frameend<0) THEN
       PRINT*,'No output data found.'
       STOP
    END IF
  END SUBROUTINE GETFRAMES


  SUBROUTINE PALETT(TYPE, CONTRA, BRIGHT)
    !-----------------------------------------------------------------------
    ! Set a "palette" of colors in the range of color indices used by
    ! PGIMAG.
    !-----------------------------------------------------------------------
    INTEGER TYPE
    REAL CONTRA, BRIGHT
    !
    REAL GL(2), GR(2), GG(2), GB(2)
    REAL RL(9), RR(9), RG(9), RB(9)
    REAL HL(5), HR(5), HG(5), HB(5)
    REAL WL(10), WR(10), WG(10), WB(10)
    REAL AL(20), AR(20), AG(20), AB(20)
    !
    DATA GL /0.0, 1.0/
    DATA GR /0.0, 1.0/
    DATA GG /0.0, 1.0/
    DATA GB /0.0, 1.0/
    !
    DATA RL /-0.5, 0.0, 0.17, 0.33, 0.50, 0.67, 0.83, 1.0, 1.7/
    DATA RR / 0.0, 0.0,  0.0,  0.0,  0.6,  1.0,  1.0, 1.0, 1.0/
    DATA RG / 0.0, 0.0,  0.0,  1.0,  1.0,  1.0,  0.6, 0.0, 1.0/
    DATA RB / 0.0, 0.3,  0.8,  1.0,  0.3,  0.0,  0.0, 0.0, 1.0/
    !
    DATA HL /0.0, 0.2, 0.4, 0.6, 1.0/
    DATA HR /0.0, 0.5, 1.0, 1.0, 1.0/
    DATA HG /0.0, 0.0, 0.5, 1.0, 1.0/
    DATA HB /0.0, 0.0, 0.0, 0.3, 1.0/
    !
    DATA WL /0.0, 0.5, 0.5, 0.7, 0.7, 0.85, 0.85, 0.95, 0.95, 1.0/
    DATA WR /0.0, 1.0, 0.0, 0.0, 0.3,  0.8,  0.3,  1.0,  1.0, 1.0/
    DATA WG /0.0, 0.5, 0.4, 1.0, 0.0,  0.0,  0.2,  0.7,  1.0, 1.0/
    DATA WB /0.0, 0.0, 0.0, 0.0, 0.4,  1.0,  0.0,  0.0, 0.95, 1.0/
    !
    DATA AL /0.0, 0.1, 0.1, 0.2, 0.2, 0.3, 0.3, 0.4, 0.4, 0.5, &
             0.5, 0.6, 0.6, 0.7, 0.7, 0.8, 0.8, 0.9, 0.9, 1.0/
    DATA AR /0.0, 0.0, 0.3, 0.3, 0.5, 0.5, 0.0, 0.0, 0.0, 0.0, &
             0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0/
    DATA AG /0.0, 0.0, 0.3, 0.3, 0.0, 0.0, 0.0, 0.0, 0.8, 0.8, &
             0.6, 0.6, 1.0, 1.0, 1.0, 1.0, 0.8, 0.8, 0.0, 0.0/
    DATA AB /0.0, 0.0, 0.3, 0.3, 0.7, 0.7, 0.7, 0.7, 0.9, 0.9, &
             0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0/
    !
    IF (TYPE.EQ.1) THEN
       !-- gray scale
       CALL PGCTAB(GL, GR, GG, GB, 2, CONTRA, BRIGHT)
    ELSE IF (TYPE.EQ.2) THEN
       !-- rainbow
       CALL PGCTAB(RL, RR, RG, RB, 9, CONTRA, BRIGHT)
    ELSE IF (TYPE.EQ.3) THEN
       !-- heat
       CALL PGCTAB(HL, HR, HG, HB, 5, CONTRA, BRIGHT)
    ELSE IF (TYPE.EQ.4) THEN
       !-- weird IRAF
       CALL PGCTAB(WL, WR, WG, WB, 10, CONTRA, BRIGHT)
    ELSE IF (TYPE.EQ.5) THEN
       !-- AIPS
       CALL PGCTAB(AL, AR, AG, AB, 20, CONTRA, BRIGHT)
    END IF
  END SUBROUTINE PALETT

  SUBROUTINE SETVP
    !-----------------------------------------------------------------------
    ! Set the viewport, allowing margins around the edge for annotation.
    ! (This is similar in effect to PGVSTD, but has different margins.)
    ! The routine determines the view-surface size and allocates margins
    ! as fractions of the minimum of width and height.
    !-----------------------------------------------------------------------
    REAL D, VPX1, VPX2, VPY1, VPY2
    !
    CALL PGSVP(0.0, 1.0, 0.0, 1.0)
    CALL PGQVP(1, VPX1, VPX2, VPY1, VPY2)
    D = MIN(VPX2-VPX1, VPY2-VPY1)/40.0
!!$    VPX1 = VPX1 + 5.0*D
!!$    VPX2 = VPX2 - 2.0*D
!!$    VPY1 = VPY1 + 8.0*D
!!$    VPY2 = VPY2 - 2.0*D

    VPX1 = VPX1 + 5.0*D
    VPX2 = VPX2 - 8.0*D
    VPY1 = VPY1 + 5.0*D
    VPY2 = VPY2 - 2.0*D

!!$    VPX1 = VPX1 + 12.0*D
!!$    VPX2 = VPX2 - 16.0*D
!!$    VPY1 = VPY1 + 7.0*D
!!$    VPY2 = VPY2 - 4.0*D

    CALL PGVSIZ(VPX1, VPX2, VPY1, VPY2)
  END SUBROUTINE SETVP
END PROGRAM bear2fix
