


      subroutine writfits_r4(FILE,pix,PXDIMX,PXDIMY)
      implicit none

      character*80 FILE
      integer PXDIMX,PXDIMY
      real    pix(PXDIMX,PXDIMY)

      integer nbyte0
      integer nbyteE
      integer nbyte1
      integer nbyte2
      integer nbper
      integer i,ios

      character*2880 buff
      common /sneaky/ buff

      integer ifirst, i1, i2

      integer np1, np2, npt

      logical LINUX
      data LINUX/.true./

      write(*,'(''writfits_r4:  '',i4,''x'',i4,1x,A)') 
     .            PXDIMX,PXDIMY,TRIM(FILE)

      open(10,file=FILE,status='unknown',
     .     err=900,recl=720,form='UNFORMATTED',
     .     access='DIRECT')


      i = 1
      write(buff( 0*80+1: 1*80),'(''SIMPLE  = T      '')')
      write(buff( 1*80+1: 2*80),'(''BITPIX  = -32    '')')
      write(buff( 2*80+1: 3*80),'(''NAXIS   ='',i12)') 2
      write(buff( 3*80+1: 4*80),'(''NAXIS1  ='',i12)') PXDIMX
      write(buff( 4*80+1: 5*80),'(''NAXIS2  ='',i12)') PXDIMY
      write(buff( 5*80+1: 6*80),'(''DATATYPE='',9a)') 
     .                          ' ''REAL*4'''
      write(buff( 6*80+1: 7*80),'(''DATE    ='',11a)') 
     .                          ' ''28/01/00'''
      write(buff( 7*80+1: 8*80),'(''END      '')')
      write(buff(35*80+1:36*80),'(''END      '')')

      write(10,rec=i,iostat=ios) buff


      ifirst = i+1
      i1 = i
      i2 = i

      nbper  = 4*PXDIMX*PXDIMY
      npt    =   PXDIMX*PXDIMY
      nbyte1 = 1 
      nbyte2 = nbper
      i1 = i+1 + nbyte1/2880
      i2 = i+1 + nbyte2/2880

      do i = i1, i2, 1
         nbyte0 = (i-ifirst)*2880+   1
         nbyteE = (i-ifirst)*2880+2880
         np1 = (nbyte0-nbyte1)/4 + 1
         np2 = (nbyteE-nbyte1)/4 + 1
         call pix2buff(pix,np1,npt)
         if (LINUX) call buffflip_r4
         write(10,rec=i,iostat=ios) buff
         enddo 

      close(10)

      return

 900  continue
      print*,'WRITFITS.f ERROR'
      stop

      end


      subroutine pix2buff(pix,n1,nt)
      implicit none 
      real pix(*)
      integer n1,nt
 
      real pbuff(720)
      common /sneaky/pbuff
      integer i
      integer npu

      do i = 1, 720
         npu = n1+i-1
         if (npu.ge.1.and.npu.le.nt) pbuff(i) = pix(npu)
         enddo
 
      return
      end






      subroutine buffflip_r4
      implicit none
      character buff(2880)
      common /sneaky/ buff
      character temp(4)
      integer i

      do i = 0, 2876,4
         temp(1) = buff(i+1)
         temp(2) = buff(i+2)
         temp(3) = buff(i+3)
         temp(4) = buff(i+4)
         buff(i+1) = temp(4)
         buff(i+2) = temp(3)
         buff(i+3) = temp(2)
         buff(i+4) = temp(1)
         enddo

      return
      end



