!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    bear2fix.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
!------------------------------------
!
! Subroutines for bear2fix are broken up into 3 include files:
!
! i_processing.f90: subroutines relating to the prompts & dataprocessing
! i_plotting.f90  : subroutines relating to standard plotting (plotframe,schlieren, etc.)
! i_usercoding.f90: location of all "user coded option here" subroutines
!
!
!------------------------------------

PROGRAM bear2fix
  USE BearIO
  USE GlobalDeclarations
  USE COOL
  USE analyze
  USE Testing
  IMPLICIT NONE
  LOGICAL :: lInteractive=.true.
  LOGICAL :: havegddata=.false.
  REAL,PARAMETER :: PI=3.14159265
  REAL(KIND=qprec) :: lunit,lconvertplot
  INTEGER :: frameinput, frame,frameend,step,operation,application,maxHotBox,n,run,iErr

  INTEGER :: default,scales
  REAL :: MinOverall,MaxOverall
  INTEGER :: cutfield,iStream, duplex, symaxis
  INTEGER,DIMENSION(2) :: cutp1,cutp2
  LOGICAL :: Llog
  INTEGER :: np
  INTEGER :: i_jetset_option
  REAL(KIND=qPrec) :: dbl_jetset_gamma

  REAL,DIMENSION(:),POINTER :: frametimes

  CHARACTER(LEN=23) :: TreeFile
  CHARACTER(LEN=17) :: FileName
  CHARACTER(LEN=100) :: PlotLabel=""
  CHARACTER(LEN=100) :: args
  REAL :: MinT,MaxT,T
  NAMELIST /inputoptions/ frameinput, frame, frameend, application, operation, &
                          userfield, qnvars, MaxHotBox, plotlabel, lLog, scales, &
                          np, cutp1, cutp2, MinOverall, MaxOverall, iTest, MaxLevel, iStream,duplex, symaxis, L2GenericNormPass, LInfGenericNormPass, lDataFromBlueGene



  CALL CreateBoxType 
  CALL CreateBoundType 

  IF (IARGC() > 0) THEN
     CALL GetArg(1,args)
     IF (.NOT. (args .eq. '-batch' .AND. IARGC() == 1)) THEN
       PRINT*, "usage: bear2fix [-batch]"
       STOP
     ELSE
       lInteractive=.false.
     END IF
  ELSE
     WRITE(*,'(A)',ADVANCE='NO') 'Data from BlueGene T/F? '
     READ*,lDataFromBlueGene
  END IF       

  !
  CALL  InitGD(lInteractive,havegddata)
  !CALL initneqCool
  lunit=lscale
  !lunit=AU
  !lunit=1.d-4
  !lunit=dxFine(1)*2.
  lconvertplot=lscale/lunit

  iStream=1

  IF (.NOT. lInteractive) THEN
    open(unit=11, FILE='bear2fix.data', STATUS='OLD', FORM='formatted', IOSTAT=iErr, ERR=60)
60   IF (iErr /= 0) THEN
       PRINT*, '!!! bear2fix error reading bear2fix.data needed for batch mode'
       STOP
    END IF
    READ(11, NML=InputOptions)
    CLOSE(11)
  END IF

  ! prompt for 'default', return 'default', 'frame' & 'frameend'
  CALL GetFrames

  ! Define coarseRatio, operation, application, etc.
  ! Define workarounds to the prompts ("defaults") here
  SELECT CASE(default)
  CASE(-3,-4) ! log10(rho), w/ or w/o hotboxes
     MaxHotBox=-1
     MaxLevel=-1
     application=3
     operation=3
     qnvars=1
     MaxHotBox=-1
     IF(lmhd) THEN
        application = 2
        IF(istream/=0) THEN
           qnvars=nrvars
        END IF
     END IF
     IF(default==-4) MaxHotBox=99
     !CALL GetScales
     scales=0
     Llog = .true.
  CASE(-5) ! output to terminal area-filling of each AMR level
     MaxLevel=-1
     application=1
     operation=7
     Llog=.false.
     MaxHotBox=-1
     scales=0
  CASE(-6)
     MaxLevel=-1
     application=0
     operation=-1
     scales=0
     qnvars=NrVars
  CASE(-2:) ! do the prompts

     CALL GetPrompts
     ! get type of scaling (relative, etc.)
     IF (lInteractive) THEN
        scales=0
        IF(     operation .ne.  0  &
          .AND. operation .ne.  1  &
          .AND. operation .ne. -1  &
          .AND. operation .lt.  9  &
          .AND. operation .ne. 12  &
          .AND. operation .ne. 13  &
          .AND. operation .ne. 14  ) CALL GetScales
     END IF
  CASE DEFAULT
     PRINT*,'Error: bogus.'
     STOP
  END SELECT
  OPEN(UNIT=11, FILE='bear2fix.data', STATUS='unknown', FORM='formatted')
  WRITE(11, NML=InputOptions)
  IF (.not. havegddata) WRITE(11, NML=PhysicsData)
  ! Do post-processing, depending on whether relative or global scales are requested
  SELECT CASE(scales)
  CASE(0,3) ! 
     CALL ProcessFrames
  CASE(1,2) 
     ! first get (min/max)overall from data...
     IF(frameend-frame .gt. 10) step = CEILING((REAL(frameend)-REAL(frame))/10.)
     ! read in frames [frame:step:frameend] and define MaxOverall & MinOverall
     CALL ReadFrames(step)
     PRINT*,'Minimum value: ',MinOverall
     PRINT*,'Maximum value: ',MaxOverall
     
     ! ...then process frames
     CALL ProcessFrames
  CASE DEFAULT
  END SELECT

  
  ! output area-filling fractions of AMR levels
  !  DO n=frame,frameend,step
  !     CALL CreateFixedGrid(n,coarseRatio)
  !     levelArea = levelArea / levelArea(0) * 100.
  !     WRITE(*,FMT='(I3,A1,7f6.1)') &
  !          n,' ',levelArea(0:MaxLevels)
  !  END DO

CONTAINS

  INCLUDE 'i_processing.f90'
  INCLUDE 'i_plotting.f90'
  INCLUDE 'i_usercoding.f90'
  INCLUDE 'i_compare.f90'
  INCLUDE 'i_emission.f90'
END PROGRAM bear2fix
