!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    globaldeclarations.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
MODULE GlobalDeclarations
  IMPLICIT NONE
  LOGICAL :: lInterpolate=.false.
  INTEGER, PARAMETER :: qPrec = SELECTED_REAL_KIND(14,32)
  INTEGER, PARAMETER :: xPrec = SELECTED_REAL_KIND(14,32)
  REAL(KIND=qprec),PARAMETER :: au=1.49598e13,parsec=3.08568025d18,cm=1.d0,msolar=1.98892e33,year=31556926.d0
  REAL(KIND=qprec),DIMENSION(-1:32) :: srcPrecision !real array    (-1:32)
  REAL(KIND=qprec) :: muH,muH2,muHe,mue,Xmu,boltzmann,ev,amu,&  !real constants
       BindH2,IonH,IonHe,gamma,gamma1,gamma7,gammac,gammaH,gammaH2,&!real
       TimeScale,rScale,nScale,TempScale,pScale,lScale,mScale,bScale,VelScale,cOut,&!real
       Lumin,mCentral,alpha,MinTemp,RunTimesc,ViscCD,ScaleGrav,ScaleCool,EOSConstants!real
  INTEGER,DIMENSION(3) :: verbosity    !integer array (3)
  INTEGER :: NrVars,NrHydroVars,NrEllipticVars,nDim,NrCons,iCooling,iEOS,iCylindrical,&!integer
       iH2,iH,iHII,iHaux,iHe,iHeII,iHeIII,iE,iEntropy,nSpecies,nSpeciesLO,nSpeciesHI,iSpeedHI,iDivB!interger indecies
  LOGICAL :: MaintainAuxArrays,lMHD,lH,lH2,lHII,lHe,lHeII,lHeIII, lIsothermal,lTracer !logical
  REAL(KIND=qprec),DIMENSION(0:10) :: levelArea = 0.
  INTEGER :: MaxLevels = 1
  INTEGER :: MaxLevel=-1
  INTEGER, DIMENSION(8) :: var_index
  INTEGER :: ivx, ivy, ivz, iBx, iBy, iBz, iGravity, NrTracers, nTracerLo, nTracerHi
  INTEGER, PARAMETER :: MaxDims=4
  INTEGER :: numspecies
  INTEGER,DIMENSION(:),ALLOCATABLE :: species
  INTEGER,DIMENSION(:,:),ALLOCATABLE :: exlevels
  LOGICAL :: lEmissBOV=.FALSE., lEmissShape=.FALSE.
  CHARACTER(LEN=1),DIMENSION(:),ALLOCATABLE :: lev1_char, lev2_char
  CHARACTER(LEN=3),DIMENSION(:),ALLOCATABLE :: spec_char

  REAL(KIND=qPREC), PARAMETER :: zero = 0d0, half=.5d0
  TYPE CELLINFO
     ! t= time at hydro step
     ! dt=hydro timestep
     REAL(KIND=qprec) :: t,dt,ScaleGravR3
     REAL(KIND=xprec),DIMENSION(3) :: x,dx
     INTEGER :: ErrorFlag
     INTEGER :: iteration
     LOGICAL :: lquit
     REAL(KIND=qprec), POINTER, DIMENSION(:) :: qScale
  END TYPE CELLINFO

  TYPE GridInfo
     CHARACTER(LEN=22) :: nameQ,nameT
     REAL(KIND=qprec) :: Time
     INTEGER :: frame,nGrid,nGrids,nDim,nVars,level
     INTEGER,DIMENSION(4) :: mX
     REAL,DIMENSION(4) :: Xlower,Xupper,dx
     REAL, POINTER, DIMENSION(:,:,:,:) :: q
  END TYPE GridInfo
  TYPE (GridInfo) :: gi_fixed

  LOGICAL :: lDataFromBlueGene=.false.
  
  NAMELIST /SCALESDATA/ TimeScale,lScale,mScale,rScale,VelScale,pScale,nScale,bScale,TempScale,ScaleGrav
  NAMELIST /physicsdata/  lMHD, nDim, lIsothermal, NrEllipticVars, NrTracers
CONTAINS

  ! reads astrobear global declaration data file
  SUBROUTINE InitGD(lInteractive,havegddata)
    LOGICAL :: havegddata,lInteractive
    INTEGER :: iErr
    OPEN(UNIT=555,FILE='out/gd.data',STATUS='OLD',IOSTAT=iERR)
    IF(iErr==0) THEN
      havegddata=.true.
    READ(555,*)&
       srcPrecision,& !real array    (-1:32)
       muH,muH2,muHe,mue,Xmu,boltzmann,ev,amu,&  !real constants
       BindH2,IonH,IonHe,gamma,gammac,gammaH,gammaH2,&!real
       rScale,nScale,TempScale,pScale,lScale,VelScale,cOut,&!real
       Lumin,mCentral,alpha,MinTemp,RunTimesc,ViscCD,ScaleGrav,ScaleCool,EOSConstants,&!real
       verbosity,&    !integer array (3)
       NrVars,nDim,iCooling,iEOS,iCylindrical,&  !integer
       iH2,iH,iHII,iHaux,iHe,iHeII,iHeIII,iE,iEntropy,nSpecies,nSpeciesLO,nSpeciesHI,iSpeedHI,iDivB,&!interger indecies
       MaintainAuxArrays,lMHD,lH,lH2,lHII,lHe,lHeII,lHeIII!logical
    CLOSE(555)
    ELSE
       
       Xmu=1.d0; gamma = 5d0/3d0;
       OPEN(UNIT=333,FILE='scales.data',STATUS='OLD',IOSTAT=iErr)
       IF(iErr /= 0) THEN
          PRINT *, "*** Cannot find scales.data ***"
          STOP
       END IF
       READ(333,NML=SCALESDATA)
       CLOSE(333)
!       EOSConstants=pScale*1.67262158d-27/(rScale*Boltzmann);gamma=1.4d0;
       muH = 1.00794d0; muHe=4.002602d0
       !
       iH2=0;iH=0;iHII=0;iHaux=0;iHe=0;iHeII=0;iHeIII=0;iEntropy=0;&
       nSpecies=0;nSpeciesLO=0;nSpeciesHI=0;iDivB=0;&
       !
       NrVars=0;NrHydroVars=0;NrEllipticVars=0;nDim=2;iCooling=0;iEOS=0;iCylindrical=0
       !
       MaintainAuxArrays=.FALSE.;lMHD=.FALSE.;lH=.FALSE.;lH2=.FALSE.;lHII=.FALSE.;lHe=.FALSE.;lHeII=.FALSE.;lHeIII=.FALSE.
       IF (linteractive) THEN
         WRITE(*,'(A)',ADVANCE='NO') 'Unable to find out/gd.data!  MHD=T/F? '
         READ*,lMHD
         WRITE(*,'(A)',ADVANCE='NO') 'nDim=? '
         READ*,nDim
         iSpeedHI = nDim + 1
         iE = nDim + 2
!         WRITE(*,'(A)',ADVANCE='NO') 'MaintainAuxArrays=T/F? '
!         READ*,MaintainAuxArrays 
         WRITE(*,'(A)',ADVANCE='NO') 'Isothermal=(T/F)? '
         READ*,lIsothermal
         IF (lIsothermal) iEOS = 4
         WRITE(*,'(A)',ADVANCE='NO') 'NrEllipticVars=? '
         READ*,NrEllipticVars
         WRITE(*,'(A)',ADVANCE='NO') 'NrTracers=? '
         READ*,NrTracers
       ELSE
         open(unit=11, FILE='bear2fix.data', STATUS='OLD', FORM='formatted', IOSTAT=iErr, ERR=50)
50       IF (iErr /= 0) THEN
           PRINT*, '!!! bear2fix error reading bear2fix.data needed for batch mode'
           STOP
         END IF
         READ(11, NML=PhysicsData)
         CLOSE(11)
!         lIsothermal = (iEOS == 4)
       END IF
    END IF
    MaintainAuxArrays=lMHD .AND. nDim >= 2
    CALL setup_vars()

  END SUBROUTINE InitGD


  SUBROUTINE setup_vars()
    INTEGER :: i
    gamma1=gamma-1d0
    gamma7=1d0/gamma1

    IF (lMHD) THEN
       IF (lIsothermal) THEN
          NrCons=7
          var_index=(/1,0,2,3,4,5,6,7/)
       ELSE
          NrCons=8
          var_index=(/1,5,2,3,4,6,7,8/)
       END IF
    ELSE
       IF (lIsothermal) THEN
          NrCons=1+nDim
          IF (nDim == 1) THEN
             var_index=(/1,0,2,0,0,0,0,0/)
          ELSE IF (nDim == 2) THEN
             var_index=(/1,0,2,3,0,0,0,0/)
          ELSE
             var_index=(/1,0,2,3,4,0,0,0/)
          END IF
       ELSE
          NrCons=2+nDim
          IF (nDim == 1) THEN
             var_index=(/1,3,2,0,0,0,0,0/)
          ELSE IF (nDim == 2) THEN
             var_index=(/1,4,2,3,0,0,0,0/)
          ELSE
             var_index=(/1,5,2,3,4,0,0,0/)
          END IF
       END IF
    END IF
    iE=var_index(2)    
    ivx=var_index(3)
    ivy=var_index(4)
    ivz=var_index(5)
    iBx=var_index(6)
    iBy=var_index(7)
    iBz=var_index(8)
   
    IF (NrVars==0) THEN
       NrHydroVars=NrCons+NrTracers
       NrVars=NrHydroVars+NrEllipticVars
    ELSE IF(NrHydroVars==0) THEN
       NrHydroVars=NrVars
       NrTracers=NrHydroVars-NrCons
    ELSE
       NrTracers=NrHydroVars-NrCons
    END IF

    IF (NrTracers > 0) THEN
       nTracerLo=NrCons+1
       nTracerHI=NrVars
       lTracer=.true.

    ELSE
       nTracerLo=0
       nTracerHi=nTracerLo-1

    END IF
  END SUBROUTINE setup_vars


SUBROUTINE cons_to_prim(q)
  REAL, DIMENSION(:,:,:,:), INTENT(INOUT) :: q
  INTEGER :: i,j,k
  REAL, DIMENSION(:), ALLOCATABLE :: v
  IF (lMHD) THEN
     ALLOCATE(v(3))
     DO i=lbound(q,1),ubound(q,1)
        DO j=lbound(q,2),ubound(q,2)
           DO k=lbound(q,3),ubound(q,3)
              v(1:3)=q(i,j,k,ivx:ivz)/q(i,j,k,1)
              IF (iE .ne. 0) q(i,j,k,iE)=gamma1*(q(i,j,k,iE)-half*(DOT_PRODUCT(q(i,j,k,ivx:ivz),v(1:3))+DOT_PRODUCT(q(i,j,k,iBx:iBz),q(i,j,k,iBx:iBz))))
              q(i,j,k,ivx:ivz)=v(1:3)
           END DO
        END DO
     END DO
  ELSE
     ALLOCATE(v(1:nDim))
     DO i=lbound(q,1),ubound(q,1)
        DO j=lbound(q,2),ubound(q,2)
           DO k=lbound(q,3),ubound(q,3)
              v=q(i,j,k,ivx:ivx+nDim-1)/q(i,j,k,1)
              IF (iE .ne. 0) q(i,j,k,iE)=gamma1*(q(i,j,k,iE)-half*(DOT_PRODUCT(q(i,j,k,ivx:ivx+nDim-1),v)))
              q(i,j,k,ivx:ivx+nDim-1)=v(1:nDim)
           END DO
        END DO
     END DO
  END IF
  DEALLOCATE(v)
END SUBROUTINE cons_to_prim

SUBROUTINE prim_to_cons(q)
  REAL, DIMENSION(:,:,:,:), INTENT(INOUT) :: q
  INTEGER :: i,j,k
  IF (lMHD) THEN
     DO i=lbound(q,1),ubound(q,1)
        DO j=lbound(q,2),ubound(q,2)
           DO k=lbound(q,3),ubound(q,3)
              IF (iE .ne. 0) q(i,j,k,iE)=gamma7*q(i,j,k,iE)+half*(DOT_PRODUCT(q(i,j,k,ivx:ivz),q(i,j,k,ivx:ivz))*q(i,j,k,1)+DOT_PRODUCT(q(i,j,k,iBx:iBz),q(i,j,k,iBx:iBz)))
              q(i,j,k,ivx:ivz)=q(i,j,k,ivx:ivz)*q(i,j,k,1)
           END DO
        END DO
     END DO
  ELSE
     DO i=lbound(q,1),ubound(q,1)
        DO j=lbound(q,2),ubound(q,2)
           DO k=lbound(q,3),ubound(q,3)
              IF (iE .ne. 0) q(i,j,k,iE)=gamma7*q(i,j,k,iE)+half*(DOT_PRODUCT(q(i,j,k,ivx:ivx+nDim-1),q(i,j,k,ivx:ivx+nDim-1))*q(i,j,k,1))
              q(i,j,k,ivx:ivx+nDim-1)=q(i,j,k,ivx:ivx+nDim-1)*q(i,j,k,1)
           END DO
        END DO
     END DO
  END IF
END SUBROUTINE prim_to_cons

  PURE ELEMENTAL FUNCTION ISINFNAN(x)
     LOGICAL :: ISINFNAN
     REAL, INTENT(IN) :: x
     ISINFNAN=.FALSE.
     IF(ISNAN(x) .OR. ABS(x)>HUGE(x)) ISINFNAN=.TRUE.
  END FUNCTION ISINFNAN

END MODULE GlobalDeclarations
