!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    i_compare.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
SUBROUTINE compare(q1,q2)
  REAL, DIMENSION(:,:,:,:), POINTER :: q1,q2
  REAL, DIMENSION(:), ALLOCATABLE :: max_error,max_allowed_error, mean_error, max_rel_error
  INTEGER :: i

  ALLOCATE(max_error(NrVars),max_allowed_error(NrVars), mean_error(NrVars), max_rel_error(NrVars))

  IF (ANY(shape(q1) /= shape(q2))) THEN
     write(*,*) "fixed grid sizes or number of variables are not the same.  Cannot compare values in i_compare.f90"
     STOP
  END IF

  DO i=1,NrVars
     max_rel_error(i)=MAXVAL((ABS(q1(:,:,:,i)-q2(:,:,:,i)))/max(abs(q2(:,:,:,i)), tiny(1e0)))
     max_error(i)=MAXVAL(ABS(q1(:,:,:,i)-q2(:,:,:,i)))
     mean_error(i)=sqrt(sum((q1(:,:,:,i)-q2(:,:,:,i))**2))/(size(q1,1)*size(q1,2)*size(q1,3))
  END DO

  OPEN(UNIT=12, FILE="max_rel_errors.data", STATUS="unknown", POSITION="append", form="formatted")    
  DO i=1, NrVars
     WRITE(12, 99), max_rel_error(i)
  END DO
  CLOSE(12)
  write(*,'(A,32E24.15)') 'max relative error by fields = ', max_rel_error(:)

  OPEN(UNIT=12, FILE="max_errors.data", STATUS="unknown", POSITION="append", form="formatted")    
  DO i=1, NrVars
     WRITE(12, 99), max_error(i)
  END DO
  CLOSE(12)

  OPEN(UNIT=12, FILE="./ref/max_errors.data", STATUS="old", form="formatted", iostat=ierr)    
  IF(ierr==0) then
    
    DO i=1, NrVars
       read(12, 99), max_allowed_error(i)
    END DO
    CLOSE(12)
    print*,"test comparison results: ", all(max_error <= max_allowed_error*2.0)
  end if

  write(*,'(A,32E24.15)') 'max error by fields = ', max_error(:)

  OPEN(UNIT=12, FILE="mean_errors.data", STATUS="unknown", POSITION="append", form="formatted")    
  DO i=1, NrVars
     WRITE(12, 99), mean_error(i)
  END DO
  CLOSE(12)
  write(*,'(A,32E24.15)') 'mean error by fields = ', mean_error(:)

  99 FORMAT(E25.15)

  DEALLOCATE(max_error, mean_error, max_allowed_error, max_rel_error)
END SUBROUTINE
