!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    i_plotting.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
  SUBROUTINE PlotFrame(ilo,ihi,jlo,jhi,index,maxLevelHotBox,MinOverall,MaxOverall)
    USE BearIO
    INTEGER i,j,k,l,ilo,jlo,ihi,jhi,index,maxLevelHotBox
    INTEGER i1,j1,i2,j2 ! AJC
    INTEGER mF(2)
    LOGICAL :: lHot
    INTEGER C1,C2,NC,mxi,mxj
    INTEGER PGOPEN
    CHARACTER(LEN=14) :: fileName
    !
    INTEGER, PARAMETER :: nCont=20
    REAL,DIMENSION(-2*nCont+1:3*nCont) :: C
    REAL,DIMENSION(mxfix(1),mxfix(2)) :: Bx,By
    REAL,DIMENSION(mxfix(1)+1,mxfix(2)+1) :: A
    REAL,DIMENSION(:,:),POINTER :: F,tracer
    REAL,DIMENSION(:,:,:),POINTER :: V
    REAL,DIMENSION(4) :: XL,XU
    REAL,DIMENSION(6) :: TR,TRA
    REAL,DIMENSION(5) :: xBoxPoints,yBoxPoints
    REAL FMIN,FMAX,BRIGHT,CONTRA,VLENGTH
    !
    REAL MinOverall,MaxOverall
    INTEGER :: iErr
    INTEGER :: vxstep,vystep,nV=40  !number of vectors in x-direction
    i1=ilo;i2=ihi;j1=jlo;j2=jhi
    mF(1:2)=mxfix(1:2)
    XL(1:2)=XLower(1:2);XU(1:2)=XUpper(1:2)
    IF(duplex==0) THEN
       ALLOCATE(F(mxfix(1),mxfix(2)),STAT=iErr)
       IF(iErr .ne. 0) THEN
          PRINT*,'Allocate of F fail.'
          STOP
       ENDIF
       IF(index==-1) THEN  !hack for vectorfield overlaying density plot
          vxstep = nint(REAL(mxfix(1))/nV)
          vystep = nint(REAL(mxfix(2))/nV)
          F(:,:)=pFix(:,:,1,1)
          ALLOCATE(V(mxfix(1),mxfix(2),2),STAT=iErr)
          ALLOCATE(tracer(mxfix(1),mxfix(2)),STAT=iErr)
          tracer(:,:) = pFix(:,:,1,7)  !clump tracer
          !tracer(:,:) = pFix(:,:,1,6)  !jet tracer
          DO i=1,mxfix(1)
          Do j=1,mxfix(2)
             IF(mod(i,vxstep)==0 .AND. mod(j,vystep)==0) THEN
                V(i,j,1) = pFix(i,j,1,2)
                V(i,j,2) = pFix(i,j,1,3)
             ENDIF
          END DO;END DO
          WHERE(ABS(V) .le. 1d-1) V=0        !ignore small velocities
          WHERE(tracer .le. 1d-6) V(:,:,1)=0 !only look at moving clumps
          WHERE(tracer .le. 1d-6) V(:,:,2)=0 !only look at moving clumps
       ELSE
          F(:,:)=SUM(pFix(:,:,:,index),3)/max(REAL(size(pFix,3)), 1d0)
       ENDIF
    ELSE
       ! First allocate the pointer
       SELECT CASE(symaxis)
       CASE(0)
          ALLOCATE( F(  mxfix(1), 2*mxfix(2)),STAT=iErr)
       CASE(1)
          ALLOCATE( F(2*mxfix(1),   mxfix(2)),STAT=iErr)
       CASE(2)
          ALLOCATE( F(2*mxfix(1), 2*mxfix(2)),STAT=iErr)

       CASE DEFAULT
       END SELECT
       IF(iErr .ne. 0) THEN
          PRINT*,'Allocate of F fail.'
          STOP
       ENDIF

       ! Then fill it in
       SELECT CASE(symaxis)
       CASE(0) ! reflect about x-axis (double y extent)
          FORALL(i=1:mxfix(2))
             F(:,i) = pFix(:,mxfix(2)-i+1,1,index)
          END FORALL
          F(:,mxfix(2)+1:2*mxfix(2)) = pFix(:,:,1,index)
          XL(2) = -XU(2)
          j2=2*j2
          mF(2)=2*mxfix(2)
       CASE(1) ! reflect about y-axis (double x extent)
          FORALL(i=1:mxfix(1))
             F(i,:) = pFix(mxfix(1)-i+1,:,1,index)
          END FORALL
          F(mxfix(1)+1:2*mxfix(1),:) = pFix(:,:,1,index)
          XL(1) = -XU(1)
          i2=2*i2
          mF(1)=2*mxfix(1)
       CASE(2) ! reflect about both axes (double x&y extent)
          FORALL(i=1:mxfix(1));FORALL(j=1:mxfix(2))
             F(i,j) = pFix(mxfix(1)-i+1,mxfix(2)-j+1,1,index)
          END FORALL;END FORALL
          FORALL(i=1:mxfix(1))
             F(i,mxfix(2)+1:2*mxfix(2)) = pFix(mxfix(1)-i+1,:,1,index)
          END FORALL
          FORALL(j=1:mxfix(2))
             F(mxfix(1)+1:2*mxfix(1),j) = pFix(:,mxfix(2)-j+1,1,index)
          END FORALL
          XL = -XU
          i2 = 2*i2
          j2 = 2*j2
          mF(1)=2*mxfix(1)
          mF(2)=2*mxfix(2)
       CASE DEFAULT
       END SELECT
    ENDIF

    IF(MinOverall==MaxOverall) THEN
       FMIN=MINVAL(F);FMAX=MAXVAL(F)
       IF(FMIN==FMAX) THEN
          FMIN=0.9999*FMIN
          FMAX=1.0001*FMAX
          IF(FMIN==0.) THEN
             FMIN=FMIN-1.e-6
             FMAX=FMAX+1.e-6
          END IF
       END IF
    ELSE
       FMIN=MinOverall;FMAX=MaxOverall
    ENDIF
    !
    WRITE(fileName,'(A9,I5.5)')'out/pgout',n
    ! open pgplot color postscript device
    IF (PGOPEN(FileName//'.ps/cps') .LT. 1) STOP
    ! setup color table
    CALL PGQCIR(C1, C2)
    NC = MAX(0, C2-C1+1)
    ! clear screan, setup window and viewport
    CALL PGPAGE
    CALL SETVP
    CALL PGWNAD(XL(1), XU(1), XL(2), XU(2))
    ! setup color map
    BRIGHT = 0.5
    CONTRA  = 1.0
    CALL PALETT(2, CONTRA, BRIGHT) ! color
    !CALL PALETT(1, CONTRA, BRIGHT) ! B&W
    !line width
    CALL PGSLW(2)
    ! setup coordimate trasformation 
    TR(1) = XL(1)-0.5*(XU(1)-XL(1))/REAL(mF(1))
    TR(2) = (XU(1)-XL(1))/REAL(mF(1))
    TR(3) = 0.0
    TR(4) = XL(2)-0.5*(XU(2)-XL(2))/REAL(mF(2))
    TR(5) = 0.0
    TR(6) = (XU(2)-XL(2))/REAL(mF(2))
    !Draw the image
    CALL PGIMAG(F,mF(1),mF(2),i1,i2,j1,j2,FMIN,FMAX,TR)
    ! contour lines
    !C = (/ (i*0.033*(FMAX-FMIN), i=0,30) /) + FMIN
    !CALL PGCONT(F,mxfix(1),mxfix(2),i1,i2,j1,j2,C,-31,TR)
    !
    !Draw hot boxes
    !line color
    !CALL PGSCI(1)  ! black
    !CALL PGSCI(0)   ! white
    CALL PGSCI(11) ! blue

    DO i=1,nGrids
       IF(gridLevels(i)<=maxLevelHotBox) THEN

          xBoxPoints(1)=gridBounds(i,1)
          yBoxPoints(1)=gridBounds(i,2)

          xBoxPoints(2)=gridBounds(i,4)
          yBoxPoints(2)=gridBounds(i,2)

          xBoxPoints(3)=gridBounds(i,4)
          yBoxPoints(3)=gridBounds(i,5)

          xBoxPoints(4)=gridBounds(i,1)
          yBoxPoints(4)=gridBounds(i,5)

          xBoxPoints(5)=gridBounds(i,1)
          yBoxPoints(5)=gridBounds(i,2)


          xBoxPoints=xBoxPoints*lconvertplot
          yBoxPoints=yBoxPoints*lconvertplot
          CALL PGLINE (5, xBoxPoints, yBoxPoints)
       END IF
    END DO
    IF(lMHD .AND. iStream>0) THEN
       DO i=1-2*nCont,3*nCOnt
          C(i)=REAL(i-1)*(1.d0-1./REAL(nCont-1))/REAL(nCont-1) + .5/REAL(nCont-1)
       END DO

       Bx(:,:)=pFix(:,:,1,6)
       By(:,:)=pFix(:,:,1,7)
       
       ! A is returned on grid corners
       CALL stream(A,Bx,By,mxfix(1),mxfix(2),dxfix(1),dxfix(2))

       ! setup transformation for grid-corner data
       TRA(1) = XLower(1)-(XUpper(1)-XLower(1))/REAL(mxfix(1))
       TRA(2) = (XUpper(1)-XLower(1))/REAL(mxfix(1))
       TRA(3) = 0.0
       TRA(4) = XLower(2)-(XUpper(2)-XLower(2))/REAL(mxfix(2))
       TRA(5) = 0.0
       TRA(6) = (XUpper(2)-XLower(2))/REAL(mxfix(2))
       
       CALL PGSCI(2) ! red
       CALL PGCONS (A, mxfix(1)+1, mxfix(2)+1, 3, mxfix(1)-1, 3, mxfix(2)-1, C, 60, TRA)
       CALL PGSCI(1) ! black
    END IF
    IF(index==-1) THEN !hack for vectorfield overlay
       PRINT*,'plotting vectors...'
       VLENGTH = MIN(TR(2),TR(6))/REAL(nV**3.2)
       CALL PGSCI(1)          !line color
       CALL PGSCH(0.3)       !arrowhead size
       CALL PGSAH(1,45.0,0.1) !arrowhead style
       CALL PGSLW(3)          !line width
       CALL PGVECT(V(:,:,1),V(:,:,2),mxi,mxj,1,mxi,1,mxj,VLENGTH,1,TR,0)
       CALL PGSLW(2)
    ENDIF
    ! set the color
    CALL PGSCI(1)
    !Annotate the plot.
    CALL PGSCH(1.)

    CALL PGMTXT('t',1.0,0.0,0.0,'Y')
    CALL PGMTXT('b',3.0,1.0,1.0,'X')

!    CALL PGMTXT('t',1.0,0.0,0.0,'R')
!    CALL PGMTXT('b',3.0,1.0,1.0,'Z')

    CALL PGBOX('bcntsi',0.0,0,'bcntsiv',0.0,0)
    ! draw color wedge
    IF(operation .eq. 5) THEN
       IF(Llog) THEN
          WRITE(plotlabel,'(A)')'log\d10\u(' // TRIM(qlist(userfield)) // ')'
       ELSE
          WRITE(plotlabel,'(A)')TRIM(qlist(userfield))
       END IF
    ELSE
       WRITE(plotlabel,'(A9,I2.1)')'operation',operation
    END IF
    CALL PGWEDG('RI', 1.0, 4.0, FMIN, FMAX, TRIM(plotlabel))
    !CALL PGWEDG('RI', 1.0, 4.0, FMIN, FMAX, 'log\d10\u(n)')
    CALL PGEND

    IF(ASSOCIATED(F)) DEALLOCATE(F)
    IF(ASSOCIATED(V)) DEALLOCATE(V)
    IF(ASSOCIATED(TRACER)) DEALLOCATE(TRACER)

  END SUBROUTINE PlotFrame


  SUBROUTINE PlotCut(i1,i2,j1,j2,index,maxLevelHotBox,MinOverall,MaxOverall)
    USE BearIO
    INTEGER i,ii,i1,j1,i2,j2,index,maxLevelHotBox
    LOGICAL :: lHot
    INTEGER C1,C2,NC,mxi,mxj
    INTEGER PGOPEN
    CHARACTER(LEN=14) :: fileName
    !
    REAL :: cutL,dx,dy
    INTEGER :: xi, yi,ncutP
    REAL, DIMENSION(10000) :: x,y,y1,y2,y3
    !
    REAL,DIMENSION(mxfix(1),mxfix(2)) :: F
    REAL,DIMENSION(4) :: XL,XU
    REAL,DIMENSION(6) :: TR
    REAL,DIMENSION(5) :: xBoxPoints,yBoxPoints
    REAL FMIN,FMAX,BRIGHT,CONTRA
    !
    REAL :: MinOverall,MaxOverall


    F(:,:)=pFix(:,:,1,index)
    IF(MinOverall==MaxOverall) THEN
       FMIN=MINVAL(F);FMAX=MAXVAL(F)
       IF(FMIN==FMAX) THEN
          FMIN=0.9999*FMIN
          FMAX=1.0001*FMAX
          IF(FMIN==0) THEN
             FMIN=FMIN-1.e-6
             FMAX=FMAX+1.e-6
          END IF
       END IF
    ELSE
       FMIN=MinOverall;FMAX=MaxOverall
    ENDIF

    mxi=i2-i1+1;mxj=j2-j1+1
    !
    WRITE(fileName,'(A9,I5.5)')'out/pgcut',n
    ! open pgplot color postscript device
    IF (PGOPEN(FileName//'.ps/cps') .LT. 1) STOP
    ! setup color table
    CALL PGQCIR(C1, C2)
    NC = MAX(0, C2-C1+1)
    ! set up a 1x2 matrix to plot the contour & cut
    CALL PGSUBP(2,1)
    ! clear screan, setup window and viewport
    CALL PGPAGE
    CALL SETVP
    XL=XLower*lconvertplot;XU=XUpper*lconvertplot
    CALL PGWNAD(XL(1), XU(1), XL(2), XU(2))
    ! setup color map
    BRIGHT = 0.5
    CONTRA  = 1.0
    CALL PALETT(2, CONTRA, BRIGHT)
    !CALL PALETT(1, CONTRA, BRIGHT)
    ! setup coordimate trasformation 
    TR(1) = XL(1)-0.5*(XU(1)-XL(1))/REAL(mxi)
    TR(2) = (XU(1)-XL(1))/REAL(mxi)
    TR(3) = 0.0
    TR(4) = XL(2)-0.5*(XU(2)-XL(2))/REAL(mxj)
    TR(5) = 0.0
    TR(6) = (XU(2)-XL(2))/REAL(mxj)
    !Draw the image
    CALL PGIMAG(F,mxfix(1),mxfix(2),i1,i2,j1,j2,FMIN,FMAX,TR)
    ! draw cut
    CALL PGSLW (2)
    X(1)=cutP1(1);Y(1)=cutP1(2)
    X(2)=cutP2(1);Y(2)=cutP2(2)
    X=(X*dxfix(1)-0.5*dxfix(1))*lconvertplot
    Y=(Y*dxfix(2)-0.5*dxfix(2))*lconvertplot
    CALL PGLINE (2, X, Y)
    !Draw hot boxes
    CALL PGSLW (2)
    DO i=1,nGrids
       IF(gridLevels(i)<=maxLevelHotBox) THEN
          xBoxPoints(1)=gridBounds(i,1)
          yBoxPoints(1)=gridBounds(i,2)

          xBoxPoints(2)=gridBounds(i,4)
          yBoxPoints(2)=gridBounds(i,2)

          xBoxPoints(3)=gridBounds(i,4)
          yBoxPoints(3)=gridBounds(i,5)

          xBoxPoints(4)=gridBounds(i,1)
          yBoxPoints(4)=gridBounds(i,5)

          xBoxPoints(5)=gridBounds(i,1)
          yBoxPoints(5)=gridBounds(i,2)

          xBoxPoints=xBoxPoints*lconvertplot
          yBoxPoints=yBoxPoints*lconvertplot
          CALL PGLINE (5, xBoxPoints, yBoxPoints)
       END IF
    END DO
    ! set the color
    CALL PGSCI(1)
    !Annotate the plot.
       CALL PGMTXT('t',1.0,0.0,0.0,'Y')
       CALL PGMTXT('b',3.0,1.0,1.0,'X')
    CALL PGBOX('bcntsi',0.0,0,'bcntsiv',0.0,0)
    ! draw color wedge
    !CALL PGWEDG('RI', 4.0, 5.0, FMIN, FMAX, '')
    CALL PGWEDG('RI', 1.0, 4.0, FMIN, FMAX, '')
    !CALL PGWEDG('RI', 1.0, 4.0, FMIN, FMAX, 'log\d10\u(n)')


    ! now, plot the cut
    cutL=SQRT(REAL((cutP2(1)-cutP1(1))**2 + (cutP2(2)-cutP1(2))**2))
    dx=REAL(cutP2(1)-cutP1(1))/cutL
    dy=REAL(cutP2(2)-cutP1(2))/cutL
    
    ncutP=NINT(cutL)+1
    ii=1
    X(:) = 0.
    DO i=1,ncutP
       X(ii)=i
       xi=MIN(MAX(cutP1(1)+NINT((i-1)*dx),1),mxfix(1))
       yi=MIN(MAX(cutP1(2)+NINT((i-1)*dy),1),mxfix(2))
       Y(ii)=pfix(xi,yi,1,index)          
       ii=ii+1
    END DO

    X=X*SQRT((dxFix(1)*dx)**2+(dxFix(2)*dy)**2)*lconvertplot
    X=X-0.5*SQRT((dxFix(1)*dx)**2+(dxFix(2)*dy)**2)*lconvertplot

    CALL PGSCH(2.)
    CALL PGSLW(2)
!    CALL PGENV(minval(X(1:ncutP)),maxval(X(1:ncutP)),minval(Y(1:ncutP)),maxval(Y(1:ncutP)),  0,  0)
    CALL PGENV(minval(X(1:ncutP)),maxval(X(1:ncutP)),FMIN,FMAX, 0, 0)
    !CALL PGENV(minval(X(1:ncutP)),maxval(X(1:ncutP)),-1.2,4.,  0,  0)
    !CALL PGENV(minval(X(1:ncutP)),maxval(X(1:ncutP)),-2.2,4.,  0,  0)
    CALL PGLAB('position along y [cm]', plotlabel, '')
!    CALL PGLAB('cut position [pc]', plotlabel, '')
!    CALL PGLAB('cut position [pc]', 'log(\(0643) [cm\U-3\D])', '')
    CALL PGLINE(ncutP, X, Y)
    CALL PGSLW(10)
    CALL PGPT(ncutP, X, Y, -1)
    CALL PGCLOS
    CALL PGEND

!!$    ! plot the cross cut
!!$    WRITE(fileName,'(A10,I5.5)')'out/pgcutC',n
!!$    ! open pgplot color postscript device
!!$    IF (PGOPEN(FileName//'.ps/ps') .LT. 1) STOP
!!$    CALL PGSCH(2.)
!!$    CALL PGSLW(2)
!!$    CALL PGENV(minval(X(1:ncutP)),maxval(X(1:ncutP)),-MAX(MAXVAL(ABS(Y3(1:ncutP))),MAXVAL(ABS(Y2(1:ncutP)))),&
!!$                                                      MAX(MAXVAL(ABS(Y2(1:ncutP))),MAXVAL(ABS(Y3(1:ncutP)))),0,0)
!!$    !CALL PGENV(minval(X(1:ncutP)),maxval(X(1:ncutP)),-4.,4.,  0,  0)
!!$    CALL PGLAB('cut position [pc]', 'v [km s\U-1\D]', '')
!!$    CALL PGLINE(ncutP, X, Y1)
!!$    CALL PGSLS(2)
!!$    CALL PGLINE(ncutP, X, Y2)
!!$    Y2=-Y2
!!$    CALL PGLINE(ncutP, X, Y2)
!!$    CALL PGSLS(4)
!!$    CALL PGLINE(ncutP, X, Y3)
!!$    Y3=-Y3
!!$    CALL PGLINE(ncutP, X, Y3)
!!$    CALL PGCLOS
!!$    CALL PGEND
  END SUBROUTINE PlotCut


  SUBROUTINE PlotSchlieren(i1,i2,j1,j2, MinOverall, MaxOverall)
    USE BearIO
    INTEGER i,j,i1,i2,j1,j2
    REAL, OPTIONAL :: MinOverall, MaxOverall
    INTEGER mxi,mxj,vxstep,vystep
    INTEGER PGOPEN
    INTEGER C1,C2,NC
    REAL CONTRA,BRIGHT
    CHARACTER(LEN=14) :: fileName
    !
    REAL,DIMENSION(mxfix(1),mxfix(2)) :: F,tracer
    REAL, POINTER, DIMENSION(:,:) :: G
    REAL,DIMENSION(mxfix(1),mxfix(2),2) :: V
    REAL,DIMENSION(4) :: XL,XU
    REAL,DIMENSION(6) :: TR
    REAL :: x_step, y_step
    !
    REAL :: dx,dy,gxl,gxr,gx,gyl,gyr,gy,GMIN,GMAX,vlength,strong_darken,darken
    INTEGER :: nV=40
    INTEGER :: iErr

    ALLOCATE(G(mxFix(1), mxFix(2)), STAT=iErr)

    IF (iErr /= 0) THEN
        PRINT *, "PlotSchlieren() error: unable to allocate G."
    END IF

    F(:,:) = pFix(:,:,1,1)
    mxi=i2-i1+1;mxj=j2-j1+1

    XL(1)=(XLower(1)+dxfix(1)*(i1-1))*lconvertplot;XU(1)=(XUpper(1)-dxfix(1)*(mxfix(1)-i2))*lconvertplot
    XL(2)=(XLower(2)+dxfix(2)*(j1-1))*lconvertplot;XU(2)=(XUpper(2)-dxfix(2)*(mxfix(2)-j2))*lconvertplot

    dx=(XU(1)-XL(1))/mxFix(1)
    dy=(XU(2)-XL(2))/mxFix(2)

    DO i=1,mxFix(1)
    DO j=1,mxFix(2)
       IF(i==1) THEN 
          gxr = ( F(i+1,j) - F(i,j)) / dx
          gxl=gxr
          gx=gxr
       ELSE IF (i==mxFix(1)) THEN
          gxl = ( F(i,j) - F(i-1,j)) / dx
          gxr=gxl
          gx=gxl
       ELSE
          ! this slope can ossilate unphysically
          !gx = ( F(i+1,j) - F(i-1,j)) / (2*dx)
          ! use vanleer limiter instead
          gxr = ( F(i+1,j) - F(i,j)) / dx
          gxl = ( F(i,j) - F(i-1,j)) / dx
          
          ![BDS][20100826]:  Switched to a new limiter.
          gx=half*(gxl+gxr)
!          IF (gxl*gxr > 0) THEN
             !gx = 2.d0*ABS(gxl*gyr)/(ABS(gxl)+ABS(gxr))*SIGN(1.d0,gxl)
!          ELSE
!             gx = 0.0
!          END IF
       END IF

       IF(j==1) THEN
          gyr = ( F(i,j+1) - F(i,j)) / dy
          gyl=gyr
          gy=gyr
       ELSE IF (j==mxFix(2)) THEN
          gyl = ( F(i,j) - F(i,j-1)) / dy
          gyr=gyl
          gy=gyl
       ELSE
          ! this slope can ossilate unphysically
          !gy = ( F(i,j+1) - F(i,j-1)) / (2*dy)
          ! use vanleer limiter instead
          gyr = ( F(i,j+1) - F(i,j)) / dy
          gyl = ( F(i,j) - F(i,j-1)) / dy

          ![BDS][20100826]:  Switched to a new limiter.
          gy = half * (gyl * gyr)
!          IF (gyl * gyr > 0) THEN
!             gy = 2.d0*ABS(gyl*gyr)/(ABS(gyl)+ABS(gyr))*SIGN(1.d0,gyl)
!          ELSE
!             gy = 0.0
!          END IF
       END IF

       G(i,j) = sqrt( gx**2 + gy**2)
    END DO
    END DO

    GMIN=MINVAL(G);GMAX=MAXVAL(G);
    IF(GMIN==GMAX) THEN
       GMIN=0.9999*GMIN
       GMAX=1.0001*GMAX
       IF(GMIN==0) THEN
          GMIN=GMIN-1.e6
          GMAX=GMAX+1.e6
       ENDIF
    ENDIF
    

    ! Even using log10(n), the contrast is a little low.  So, increase the values 
    ! proportionally to bring them all closer to GMAX ("black", below).

    ! AJC - increase the parameter "strong_darken" to get better contrast
    ! Note that darken increases the contrast of strong shocks more than weak shocks
    ! darken = 0 shuts this off
    strong_darken = 1.d0
    G = GMAX * (1.d0-ABS(G/GMAX-1.d0)**(strong_darken+1.d0))

    ! AJC - to increase the brightness of all shocks (at the expense of saturating the
    ! strongest shocks to black on the color bar), increase darken
    ! darken = 0 shuts this off
    darken = 0.0
    GMAX = GMAX/(1+darken)

    ![BDS][20100826]:  Added user-defined scaling.
    IF (PRESENT(MinOverall) .AND. PRESENT(MaxOverall)) THEN
       GMIN = MAX(MinOverall, GMIN)
       GMAX = MIN(MaxOverall, GMAX)
    END IF

    WRITE(fileName,'(A9,I5.5)')'out/scout',n
    ! open pgplot color postscript device
    IF (PGOPEN(FileName//'.ps/cps') .LT. 1) STOP
    ! setup color table
    CALL PGQCIR(C1, C2)
    NC = MAX(0, C2-C1+1)
    ! clear screan, setup window and viewport
    CALL PGPAGE
    CALL SETVP
    CALL PGWNAD(XL(1), XU(1), XL(2), XU(2))

    ! setup coordinate transformation.  This transformation matrix helps PGPLOT
    ! translate from cells to computational units.
    x_step = (XU(1)-XL(1))/REAL(mxi)
    y_step = (XU(2)-XL(2))/REAL(mxj)

    TR(1) = XL(1) - 0.5 * x_step
    TR(2) = x_step
    TR(3) = 0.0
    TR(4) = XL(2) - 0.5 * y_step
    TR(5) = 0.0
    TR(6) = y_step
    ! draw the grayscale image
    ! note that the order of GMIN and GMAX are intentionally
    ! reversed, so that the background is white (not black)
    BRIGHT = 0.5
    CONTRA = 1.0
    CALL PALETT(1, CONTRA, BRIGHT)

    CALL PGIMAG(G,mxFix(1),mxFix(2),i1,i2,j1,j2,GMAX,GMIN,TR)
!!  CALL PGGRAY(G,mxFix(1),mxFix(2),i1,i2,j1,j2,GMAX,GMIN,TR)

!!$    ! vector overlay
!!$    vxstep = nint(REAL(mxfix(1))/nV)
!!$    vystep = nint(REAL(mxfix(2))/nV)
!!$    tracer(:,:) = pFix(:,:,1,7)  ! clump tracer
!!$    !tracer(:,:) = pFix(:,:,1,6)   ! jet tracer
!!$    DO i=1,mxfix(1)
!!$       DO j=1,mxfix(2)
!!$          IF(mod(i,vxstep)==0 .AND. mod(j,vystep)==0) THEN
!!$             V(i,j,1) = pFix(i,j,1,2)
!!$             V(i,j,2) = pFix(i,j,1,3)
!!$          ENDIF
!!$    END DO;END DO
!!$    WHERE(ABS(V) .le. 1d-1) V=0        ! ignore small velocities
!!$    WHERE(tracer .le. 1d-6) V(:,:,1)=0 ! only look at moving clumps
!!$    WHERE(tracer .le. 1d-6) V(:,:,2)=0 ! only look at moving clumps
!!$
!!$    PRINT*,'plotting vectors...'
!!$    VLENGTH = MIN(TR(2),TR(6))/REAL(nV**3.2)*2
!!$    CALL PGSCI(1)          ! line color
!!$    CALL PGSCH(0.3)        ! arrowhead size
!!$    CALL PGSAH(1,45.0,0.1) ! arrowhead style
!!$    CALL PGSLW(3)          ! line width
!!$    CALL PGVECT(V(:,:,1),V(:,:,2),mxi,mxj,1,mxi,1,mxj,VLENGTH,1,TR,0)
!!$    CALL PGSLW(2)

    ! set the color for annotation
    CALL PGSCI(1)
    !Annotate the plot.
    ! set character height
    CALL PGSCH(1.)
    IF(lunit==AU) THEN
       CALL PGMTXT('t',1.0,0.0,0.0,'(AU)')
       CALL PGMTXT('b',3.0,1.0,1.0,'(AU)')
    ELSE IF(lunit==parsec) THEN
       CALL PGMTXT('t',1.0,0.0,0.0,'R (pc)')
       CALL PGMTXT('b',3.0,1.0,1.0,'Z (pc)')
    ElSE
       CALL PGMTXT('t',1.0,0.0,0.0,'Y')
       CALL PGMTXT('b',3.0,1.0,1.0,'X')
    END IF

    CALL PGWEDG('RI', 1.0, 4.0, GMIN, GMAX, 'log_schlieren')

    CALL PGBOX('bcntsi',0.0,0,'bcntsiv',0.0,0)
    CALL PGEND

    DEALLOCATE(G)
    NULLIFY(G)

  END SUBROUTINE PlotSchlieren


  SUBROUTINE PlotSchlieren3D(i1,i2,j1,j2)
    USE BearIO
    INTEGER i,j,k,i1,i2,j1,j2
    INTEGER mxi,mxj
    INTEGER PGOPEN
    INTEGER C1,C2,NC
    REAL CONTRA,BRIGHT
    CHARACTER(LEN=14) :: fileName
    !
    REAL,DIMENSION(:,:),ALLOCATABLE :: G
    REAL,DIMENSION(4) :: XL1,XU1
    REAL,DIMENSION(6) :: TR
    !
    REAL :: dx,dy,dz,GMIN,GMAX
    REAL,SAVE :: Chop
    LOGICAL,SAVE :: lfirst=.TRUE.
    REAL :: XL,XU,YL,YU,x,z,angle=45.*PI/180.
    INTEGER :: mxL,mx,mxH,my,iim,jim

    mxL=sin(angle)*xLower(3)/dxFix(1)
    mxH=cos(angle)*mxFix(1)-sin(angle)*xLower(3)/dxFix(1)
    mx=mxH-mxL+1
    my=mxFix(2)
    !
    XL=mxL*dxFix(1)+XLower(1)
    XU=mxH*dxFix(1)+XLower(1)
    YL=XLower(2)
    YU=XUpper(2)
    !
    ALLOCATE(G(mxL:mxH,my))
    G=0.d0

    DO i=2,mxFix(1)-1
    DO j=2,mxFix(2)-1
    DO k=2,mxFix(3)-1
       x=XLower(1)/dxFix(1)+(REAL(i)-0.5)
       z=XLower(3)/dxFix(3)+(REAL(k)-0.5)
       iim=NINT(COS(angle)*REAL(x))+NINT(SIN(angle)*REAL(z))
       jim=j
       IF(iim>=mxL+1 .AND. iim<=mxH-1) &
         G(iim,jim)=G(iim,jim)+&
            ((pFix(i+1,j,k,1)-pFix(i-1,j,k,1))/(dxFix(1)))**2+&
            ((pFix(i,j+1,k,1)-pFix(i,j-1,k,1))/(dxFix(2)))**2+&
            ((pFix(i,j,k+1,1)-pFix(i,j,k-1,1))/(dxFix(3)))**2
    END DO
    END DO
    END DO

    G=SQRT(G)

    GMIN=MINVAL(G);GMAX=MAXVAL(G)
    IF(lFirst) THEN
       Chop=0.1*GMAX
       lFirst=.FALSE.
    END IF
    WHERE(G<Chop) G=0.d0
    GMIN=MINVAL(G)
    IF(GMIN==GMAX) THEN
       GMIN=0.9999*GMIN
       GMAX=1.0001*GMAX
       IF(GMIN==0) THEN
          GMIN=GMIN-1.e6
          GMAX=GMAX+1.e6
       ENDIF
    ENDIF

    ! Even using log10(n), the contrast is a little low.  So, increase the values 
    ! proportionally to bring them all closer to GMAX ("black", below).
    !G(:,:) = G(:,:)*( 1 + 2*(1 - G(:,:)/GMAX) )
    !G=G**3

    WRITE(fileName,'(A9,I5.5)')'out/scout',n
    ! open pgplot color postscript device
    IF (PGOPEN(FileName//'.ps/cps') .LT. 1) STOP
    ! setup color table
    CALL PGQCIR(C1, C2)
    NC = MAX(0, C2-C1+1)
    ! clear screan, setup window and viewport
    CALL PGPAGE
    CALL SETVP
    XL1(1)=XL*lconvertplot;XU1(1)=XU*lconvertplot
    XL1(2)=YL*lconvertplot;XU1(2)=YU*lconvertplot
    CALL PGWNAD(XL1(1), XU1(1), XL1(2), XU1(2))
    ! setup coordimate trasformation 
    TR(1) = XL1(1)-0.5*(XU1(1)-XL1(1))/REAL(mx)
    TR(2) = (XU1(1)-XL1(1))/REAL(mx)
    TR(3) = 0.0
    TR(4) = XL1(2)-0.5*(XU1(2)-XL1(2))/REAL(my)
    TR(5) = 0.0
    TR(6) = (XU1(2)-XL1(2))/REAL(my)
    ! draw the grayscale image
    ! note that the order of GMIN and GMAX are intentionally
    ! reversed, so that the background is white (not black)
    BRIGHT = 0.5
    CONTRA = 1.0
    CALL PALETT(1, CONTRA, BRIGHT)
    !CALL PGIMAG(G,mxFix(1),mxFix(2),i1,i2,j1,j2,GMAX,GMIN,TR)
    CALL PGIMAG(G,mx,my,1,mx,1,my,GMAX,GMIN,TR)
    ! set the color for annotation
    CALL PGSCI(1)
    !Annotate the plot.
    ! set character height
    CALL PGSCH(1.5)
    IF(lunit==AU) THEN
       CALL PGMTXT('t',1.0,0.0,0.0,'(AU)')
       CALL PGMTXT('b',3.0,1.0,1.0,'(AU)')
    ELSE IF(lunit==parsec) THEN
       CALL PGMTXT('t',1.0,0.0,0.0,'R (pc)')
       CALL PGMTXT('b',3.0,1.0,1.0,'Z (pc)')
    ElSE
       CALL PGMTXT('t',1.0,0.0,0.0,'R')
       CALL PGMTXT('b',3.0,1.0,1.0,'Z')
    END IF
    CALL PGBOX('bcntsi',0.0,0,'bcntsiv',0.0,0)
    CALL PGEND
    DEALLOCATE(G)
  END SUBROUTINE PlotSchlieren3D
