!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    i_usercoding.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
!----------------------------------------
!
! Subroutines for user-coded operation of bear2fix:
! (add to the list below)
!
!  * writeLevelArea(i)
!  * emission3D(angle_deg)
!  * Volume43
!  * Shape
!  * RadLoss
!  * PV(angle)
!  * Ekpowerspectra
!  * dump_binary
!  * percent_amb
!  * cut
!  * total_vorticity
!  * MVBin(vmin,vmax,nbin)
!  * ProcessSlice(zfrac,lWrite)
!  * Process2Slice(zfrac1,zfrac2,lWrite)
!
!----------------------------------------


  ! output AMR level areas to terminal
  SUBROUTINE writeLevelArea(i)
    INTEGER,INTENT(IN) :: i
    levelArea = levelArea / levelArea(0) * 100.
    WRITE(*,FMT='(I3,A1,7f6.1)') &
         i,' ',levelArea(0:MaxLevels)
  END SUBROUTINE writeLevelArea


  SUBROUTINE emission3D(angle_deg)
    REAL :: angle_deg
    INTEGER :: i,j,k,iim,jim,mxL,mx,mxH,my
    REAL :: angle,x,y,z,xim,yim,XL,XU,YL,YU,minV
    REAL,ALLOCATABLE, DIMENSION(:,:) :: image
    REAL,PARAMETER :: INFINITY=1.d30
    !
    CHARACTER(LEN=14) :: fileName
    INTEGER :: PGOPEN
    INTEGER C1,C2,NC
    REAL,DIMENSION(4) :: XL1,XU1
    REAL,DIMENSION(6) :: TR
    REAL,DIMENSION(5) :: xBoxPoints,yBoxPoints
    REAL FMIN,FMAX,BRIGHT,CONTRA

    angle=angle_deg*PI/180.

    mxL=sin(angle)*xLower(3)/dxFix(1)
    mxH=cos(angle)*mxFix(1)-sin(angle)*xLower(3)/dxFix(1)
    mx=mxH-mxL+1
    my=mxFix(2)
    !
    XL=mxL*dxFix(1)+XLower(1)
    XU=mxH*dxFix(1)+XLower(1)
    YL=XLower(2)
    YU=XUpper(2)
    !
    ALLOCATE(image(mxL:mxH,my))
    image=0.d0

    DO i=1,mxFix(1)
    DO j=1,mxFix(2)
    DO k=1,mxFix(3)
       x=XLower(1)/dxFix(1)+(REAL(i)-0.5)
       z=XLower(3)/dxFix(3)+(REAL(k)-0.5)
       iim=NINT(COS(angle)*REAL(x))+NINT(SIN(angle)*REAL(z))
       jim=j
       IF(iim>=mxL .AND. iim<=mxH) &
       image(iim,jim) = image(iim,jim) + pFix(i,j,k,iE)
    END DO;END DO;END DO
    !
    WRITE(fileName,'(A9,I5.5)')'out/pgemi',n
    ! open pgplot color postscript device
    IF (PGOPEN(FileName//'.ps/cps') .LT. 1) STOP
    ! setup color table
    CALL PGQCIR(C1, C2)
    NC = MAX(0, C2-C1+1)
    ! clear screan, setup window and viewport
    CALL PGPAGE
    CALL SETVP
    FMIN=MINVAL(image);FMAX=MAXVAL(image)
    XL1(1)=XL*lconvertplot;XU1(1)=XU*lconvertplot
    XL1(2)=YL*lconvertplot;XU1(2)=YU*lconvertplot
    CALL PGWNAD(XL1(1), XU1(1), XL1(2), XU1(2))
    ! setup color map
    BRIGHT = 0.5
    CONTRA  = 1.0
    CALL PALETT(1, CONTRA, BRIGHT)
    !CALL PALETT(1, CONTRA, BRIGHT)
    ! setup coordimate trasformation 
    TR(1) = XL1(1)-0.5*(XU1(1)-XL1(1))/REAL(mx)
    TR(2) = (XU1(1)-XL1(1))/REAL(mx)
    TR(3) = 0.0
    TR(4) = XL1(2)-0.5*(XU1(2)-XL1(2))/REAL(my)
    TR(5) = 0.0
    TR(6) = (XU1(2)-XL1(2))/REAL(my)
    !Draw the image
    CALL PGIMAG(image,mx,my,1,mx,1,my,FMAX,FMIN,TR)
    ! set the color
    CALL PGSCI(1)
    !Annotate the plot.
    CALL PGSCH(1.5)
    IF(lunit==AU) THEN
       CALL PGMTXT('t',1.0,0.0,0.0,'R (AU)')
       CALL PGMTXT('b',3.0,1.0,1.0,'Z (AU)')
    ELSE IF(lunit==parsec) THEN
       CALL PGMTXT('t',1.0,0.0,0.0,'R (pc)')
       CALL PGMTXT('b',3.0,1.0,1.0,'Z (pc)')
    ElSE
       CALL PGMTXT('t',1.0,0.0,0.0,'R')
       CALL PGMTXT('b',3.0,1.0,1.0,'Z')
    END IF
    CALL PGBOX('bcntsi',0.0,0,'bcntsiv',0.0,0)
    ! draw color wedge
    !CALL PGWEDG('RI', 4.0, 5.0, FMIN, FMAX, '')
    CALL PGWEDG('RI', 1.0, 4.0, FMIN, FMAX, 'L [erg cm\U-2\D s\U-1\D]')
    CALL PGEND

    DEALLOCATE(image)
  END SUBROUTINE emission3D

  SUBROUTINE Volume43
    INTEGER :: i,j,count
    INTEGER, DIMENSION(1) :: jj
    REAL :: vol,length,meanr

    vol=0.;meanr=0.;count=0
    DO i=1,mxfix(1)
       j=mxfix(2)
       DO WHILE(pfix(i,j,1,1)/pfix(i,mxfix(2),1,1)<1.01)
          pfix(i,j,1,1)=-1
          j=j-1
          IF(j<=0) EXIT
       END DO
       IF(j>0) pfix(i,j,1,1)=-1
       IF(j>1) pfix(i,j-1,1,1)=-1
    END DO

    DO i=1,mxfix(1)
    DO j=1,mxfix(2)
       IF(pfix(i,j,1,1)>0) THEN
          vol=vol + &
              2.*PI*(dxfix(2)*(REAL(j)-0.5)) * dxfix(1)*dxfix(2) !2 pi r_cyl dr dz
       END IF
    END DO
    END DO

    IF(n==frame) OPEN(101,FILE='vol.dat')
    WRITE(101,*) time*runtimesc/year,(vol*(lscale/parsec)**3)**(4./3.)
    IF(n==frameend) CLOSE(100)
  END SUBROUTINE Volume43

  SUBROUTINE OutputShape
    INTEGER :: i,j,ilength
    REAL :: length, width

    length=0;width=0
    DO i=mxfix(1),1,-1
       IF(pfix(i,1,1,1)/pfix(mxfix(1),1,1,1)>1.01) THEN
          length = (REAL(i)-0.5)*dxFix(1)*lScale
          ilength=i
          EXIT
       END IF
    END DO
    ilength=MAX(ilength/2,1)

    DO j=mxfix(2),1,-1
       IF(pfix(ilength,j,1,1)/pfix(ilength,mxfix(2),1,1)>1.1) THEN
          width = width+(REAL(j)-0.5)*dxFix(2)*lScale
          width = width+(REAL(j)-0.5)*dxFix(2)*lScale
          width = width+(REAL(j)-0.5)*dxFix(2)*lScale
          width = width+(REAL(j)-0.5)*dxFix(2)*lScale
          width = width+(REAL(j)-0.5)*dxFix(2)*lScale
          EXIT
       END IF
    END DO
    width=width/5.

    IF(n==frame) OPEN(101,FILE='shape.dat')
    WRITE(101,*) time*runtimesc/year,length/parsec,width/parsec
    IF(n==frameend) CLOSE(100)
  END SUBROUTINE OutputShape

  SUBROUTINE RadLoss
    REAL(KIND=qprec) :: Einit,Einj,Enow,Efrac
    REAL(KIND=qprec),DIMENSION(nDim) :: X

    IF(Time<1.d-2) Time=0.d0
    
    X=XUpper(1:nDim)-XLower(1:nDim)
    Einit= 1500./nScale/(gamma-1.d0)*200.d0/EOSConstants*PRODUCT(X(1:nDim))
    Einj= 2.d0*PI*7500./nScale*200.d5/velScale*Time*gamma/(gamma-1.d0)*1.d4/EOSConstants
    Einj= Einj+PI*7500./nScale*200.d5/velScale*Time*(200.d5/velScale)**2
    X=dxFix(1:nDim)
    Enow=SUM(qfix(:,:,:,iE))*PRODUCT(X(1:nDim))
    Efrac=1.d0-Enow/(Einit+Einj)

    PRINT*,Time,Einit,Einj,Enow,Efrac

    IF(n==frame) OPEN(101,FILE='rad_loss.dat')
    PRINT*,Time*runTimesc/31556926.,Efrac
    WRITE(101,*) Time*runTimesc/31556926.,Efrac
    IF(n==frameend) CLOSE(100)
  END SUBROUTINE RadLoss


  SUBROUTINE PV(angle)
    REAL :: angle
    INTEGER :: ii,jj,i,j,k,iLO,iHI,ivLO,ivHI,iprojLO,iprojHI,iproj,iv,ivprojLO,ivprojHI
    INTEGER, PARAMETER :: nvbin=2000,sigmax=5,sigmav=4
    REAL,DIMENSION(:,:),ALLOCATABLE :: plot,plot1
    REAL :: costh,sinth,sinth1,costh1,sinth2,costh2,sinOmega,sinOmega1,sinOmega2,&
         atan_r_z,theta,xpos,vproj,vprojLO,vprojHI,minv,maxv,deltav
    ! plot veraiables
    INTEGER PGOPEN
    INTEGER C1,C2,NC,mxi,mxj
    CHARACTER(LEN=17) :: fileName
    REAL,DIMENSION(4) :: XL,XU
    REAL,DIMENSION(6) :: TR
    REAL,DIMENSION(5) :: xBoxPoints,yBoxPoints
    REAL FMIN,FMAX,BRIGHT,CONTRA
    CHARACTER(LEN=7) :: toplab
    CHARACTER(LEN=1), PARAMETER :: blank=' '
    !
    !pfix(:,:,:,1)=pfix(:,:,:,1)*(1.-pfix(:,:,:,5))
    !
    pfix(:,:,:,1)=pfix(:,:,:,1)*pfix(:,:,:,iH2)
    !
    theta=angle*PI/180.
    costh=COS(theta)
    sinth=SIN(theta)
    
    i=1;j=mxfix(2)
    iLO=NINT((REAL(i)-0.5)*costh-(REAL(j)-0.5)*sinth)
    i=mxfix(1);j=mxfix(2)
    iHI=NINT((REAL(i)-0.5)*costh+(REAL(j)-0.5)*sinth)

    minv=MAXVAL(SQRT(pfix(:,:,1,2)**2+pfix(:,:,1,3)**2))
    maxv=-minv
    DO i=1,mxfix(1)
       DO j=1,mxfix(2)
          atan_r_z=ATAN((REAL(j)-0.5)/(REAL(i)-0.5))

          sinth1=SIN(theta-atan_r_z)
          costh1=COS(theta-atan_r_z)
          sinth2=SIN(theta+atan_r_z)
          costh2=COS(theta+atan_r_z)

          minv=MIN(pfix(i,j,1,2)*sinth1+pfix(i,j,1,3)*costh1,pfix(i,j,1,2)*sinth1-pfix(i,j,1,3)*costh1,minv)
          minv=MIN(pfix(i,j,1,2)*sinth2+pfix(i,j,1,3)*costh2,pfix(i,j,1,2)*sinth2-pfix(i,j,1,3)*costh2,minv)

          maxv=MAX(pfix(i,j,1,2)*sinth1+pfix(i,j,1,3)*costh1,pfix(i,j,1,2)*sinth1-pfix(i,j,1,3)*costh1,maxv)
          maxv=MAX(pfix(i,j,1,2)*sinth2+pfix(i,j,1,3)*costh2,pfix(i,j,1,2)*sinth2-pfix(i,j,1,3)*costh2,maxv)
       END DO
    END DO

    deltav=(maxv-minv)/REAL(nvbin-2)
    ivlo=INT(minv/deltav)-1
    ivhi=INT(maxv/deltav)+1

    ALLOCATE(plot(iLO:iHI,ivlo:ivhi),plot1(iLO:iHI,ivlo:ivhi))
    plot=0;plot1=0

    DO i=1,mxfix(1)
       DO j=1,mxfix(2)
          ! maximum and minimum projected positions on image plane
          iprojLO=NINT((REAL(i)-0.5)*costh-(REAL(j)-0.5)*sinth)
          iprojHI=NINT((REAL(i)-0.5)*costh+(REAL(j)-0.5)*sinth)
          iproj=NINT((REAL(i)-0.5)*costh)

          ! debug checks
          !IF(iv<ivlo) PRINT*,1,iv,ivlo
          !IF(iv>ivhi) PRINT*,2,iv,ivhi
          !IF(iprojLO<ilo) PRINT*,3,iprojLO,ilo
          !IF(iprojHI>ihi) PRINT*,4,iprojHI,ihi

          DO k=iprojLO,iprojHI
             !!! Take only slice along axis
             IF(k/=iprojLO .AND. k/=iprojHI) CYCLE
             !!!
             ! min & max vals of omega possilble in this image cell
             IF(sinth<0.05) THEN
                ! prevent divide by small number problem if angle is small (<3 degrees)
                sinth1=0
                costh1=1.

                sinOmega1=1.
                sinOmega2=-1.
             ELSE
                sinth1=SIN(theta-ATAN(REAL(k-iproj)/((REAL(i)-0.5)*sinth)))! sin(theta-theta')
                costh1=COS(theta-ATAN(REAL(k-iproj)/((REAL(i)-0.5)*sinth)))! cos(theta-theta')

                sinOmega=REAL(k-iproj)/((REAL(j)-0.5)*sinth)
                sinOmega1=REAL(k-iproj-0.5)/((REAL(j)-0.5)*sinth)
                sinOmega2=REAL(k-iproj+0.5)/((REAL(j)-0.5)*sinth) 
                sinOmega=MIN(MAX(sinOmega,-1.),1.)
                sinOmega1=MIN(MAX(sinOmega1,-1.),1.)
                sinOmega2=MIN(MAX(sinOmega1,-1.),1.)
             END IF

             ! projected velocity
             vproj=pfix(i,j,1,2)*sinth1+pfix(i,j,1,3)*costh1*sinOmega
             vprojLO=vproj;vprojHI=vproj
             vproj=pfix(i,j,1,2)*sinth1+pfix(i,j,1,3)*costh1*sinOmega1
             vprojLO=MIN(vprojLO,vproj)
             vprojHI=MAX(vprojHI,vproj)
             vproj=pfix(i,j,1,2)*sinth1+pfix(i,j,1,3)*costh1*sinOmega2
             vprojLO=MIN(vprojLO,vproj)
             vprojHI=MAX(vprojHI,vproj)

             vproj=pfix(i,j,1,2)*sinth1+pfix(i,j,1,3)*costh1*sinOmega
             ivprojLO=NINT(vprojLO/deltav)
             ivprojHI=NINT(vprojHI/deltav)
             iv=NINT(vproj/deltav)

             DO iv=ivprojLO,ivprojHI 
                !!! Take only slice along axis
                IF(iv/=ivprojLO .AND. iv/=ivprojHI) CYCLE
                IF(iv<ivlo.OR. iv>ivhi) THEN
                   !PRINT*,ivlo,ivhi,iv
                   CYCLE
                END IF
                !
                IF(iv/=0) plot1(k,iv)=plot1(k,iv)+pfix(i,j,1,1)
                plot(k,iv)=plot(k,iv)+pfix(i,j,1,1)
             END DO
          END DO
       END DO
    END DO
    plot=plot1
    ! sharpen
    WHERE(plot<0.001*MAXVAL(plot)) plot=0
    !
    ivprojLO=0;ivprojHI=0
    !
    ! perform gaussian smoothing
    plot=0.
    DO i=iLO,iHI
       DO j=ivLO+MAX(ivprojLO-sigmav,0),ivHI-MAX(ivprojHI-sigmav,0)
          DO ii=i-2*sigmax,i+2*sigmax
             IF(ii<iLO .OR. ii>iHI) CYCLE
             DO jj=j-2*sigmav,j+2*sigmav
                IF(jj<ivLO+ivprojLO .OR. jj>ivHI-ivprojHI) CYCLE
                plot(ii,jj)=plot(ii,jj)+plot1(i,j)*&
                     (1./(sigmax*SQRT(2.*PI))*exp(-ABS(i-ii)**2/(2.*sigmax**2)) * &
                      1./(sigmav*SQRT(2.*PI))*exp(-ABS(j-jj)**2/(2.*sigmav**2)))
             END DO
          END DO
       END DO
    END DO
    ! sharpen
    WHERE(plot<0.001*MAXVAL(plot)) plot=0
    ! enhance contrast
    WHERE(plot/=0) plot=plot+0.05*MAXVAL(plot)
    !
    ! determine the plotting crop range in velocity
    ivprojLO=0
    DO i=ivLO,ivHI
       ivprojLO=ivprojLO+1
       IF(MAXVAL(plot(:,i))/=MINVAL(plot)) EXIT
    END DO
    ivprojHI=0
    DO i=ivHI,ivLO,-1
       ivprojHI=ivprojHI+1
       IF(MAXVAL(plot(:,i))/=MINVAL(plot)) EXIT
    END DO
    !
    ! open pgplot color postscript device
    WRITE(fileName,'(A9,I2.2,A1,I5.5)')'out/pvmap',NINT(angle),'.',n
    IF (PGOPEN(FileName//'.ps/cps') .LT. 1) STOP
    CALL PGSCH(2.)
    ! setup color table
    CALL PGQCIR(C1, C2)
    NC = MAX(0, C2-C1+1)
    ! setup color map
    BRIGHT = 0.5
    CONTRA  = 1.0
    !CALL PALETT(1, CONTRA, BRIGHT)
    CALL PALETT(1, -CONTRA, 1-BRIGHT)
    XL(1)=((REAL(iLO)-0.5)*dxfix(1))*lconvertplot; XU(1)=((REAL(iHi)-0.5)*dxfix(1))*lconvertplot
    XL(2)=(minv+ivprojLO*deltav)/1.e5;XU(2)=(maxv-ivprojHI*deltaV)/1.e5

!huarte
!XL(1)=0.; XL(2)=10;XU(1)=;XU(2)=10

    ! clear screan, setup window and viewport
    CALL PGPAGE
    CALL SETVP

!===D E B U G G I N G ==========
!===D E B U G G I N G ==========
!===D E B U G G I N G ==========
print*,'12aug a'
!print*,XL(1), XU(1), XL(2), XU(2)
        !0.0000000E+00  0.0000000E+00 Infinity       -Infinity
!print*,'minv,ivprojLO,deltav=',minv,ivprojLO,deltav
        !-3.4028235E+38           1 Infinity
!print*,pfix(i,j,1,:),sinth2,costh2
        !0.0000000E+00  0.0000000E+00
!print*,'maxv-minv)/REAL(nvbin-2)',maxv,minv,REAL(nvbin-2)
    !CALL PGSWIN(XL(1), XU(1), XL(2), XU(2))
    CALL PGSWIN(0.,-20.,1.4e18,2000.)
print*,'12aug b'; stop
!===D E B U G G I N G ==========
!===D E B U G G I N G ==========
!===D E B U G G I N G ==========

    XL(2)=minv/1.e5;XU(2)=maxv/1.e5
    mxi=iHI-iLO+1;mxj=ivHI-ivLO+1
    ! setup coordimate trasformation 
    TR(1) = XL(1)-0.5*(XU(1)-XL(1))/REAL(mxi)
    TR(2) = (XU(1)-XL(1))/REAL(mxi)
    TR(3) = 0.0
    TR(4) = XL(2)-0.5*(XU(2)-XL(2))/REAL(mxj)
    TR(5) = 0.0
    TR(6) = (XU(2)-XL(2))/REAL(mxj)
    !Draw the image
    CALL PGIMAG(plot,iHI-iLO+1,nvbin,1,iHI-iLO+1,1+ivprojLO,nvbin-ivprojHI,MINVAL(plot),MAXVAL(plot),TR)
    ! set the color
    CALL PGSCI(1)
    !Annotate the plot.
    WRITE(toplab,'(I2.2,A5)') NINT(angle),'\Uo\D'
    IF(NINT(angle)<10) WRITE(toplab,'(I1.1,A5)') NINT(angle),'\Uo\D'
    CALL PGMTXT('t',1.0,0.0,0.0,'V (km/s)           '//toplab)
    CALL PGBOX('bcntsi',0.0,0,'bcntsiv',0.0,0)
    CALL PGMTXT('b',3.0,1.0,1.0,'X (pc)')
    CALL PGEND
    DEALLOCATE(plot,plot1)
  END SUBROUTINE PV

  ! this subroutine assumes isotropic grid cell size in 3D
  SUBROUTINE Ekpowerspectra
!!$    INCLUDE 'fftw3.f'
!!$    !REAL,DIMENSION(mxfix(1),mxfix(2),mxfix(3)) :: invar
!!$    !COMPLEX,DIMENSION(mxfix(1)/2+1,mxfix(2),mxfix(3)) :: outvar
!!$    COMPLEX(KIND=SELECTED_REAL_KIND(4,32)),DIMENSION(mxfix(1),mxfix(2),mxfix(3)) :: invar,outvar
!!$    INTEGER :: maxk
!!$    REAL,ALLOCATABLE,DIMENSION(:) :: Ek,k
!!$    INTEGER :: i,ix,iy,iz,ixx,ik,ierr
!!$    INTEGER*8 :: p
!!$    CHARACTER(LEN=11) :: filename
!!$    REAL :: total
!!$
!!$    maxk=CEILING(SQRT(REAL(DOT_PRODUCT(mxfix(1:ndim),mxfix(1:ndim)))))
!!$    ALLOCATE(Ek(maxk),k(maxk),STAT=ierr)
!!$    IF(ierr/=0) THEN
!!$       PRINT*,'cannot allocate Ek, k'
!!$       STOP
!!$    END IF
!!$    DO ik=1,maxk
!!$       k(ik)=2*Pi*REAL(ik)/(maxk*dxfix(1))
!!$    END DO
!!$    Ek=0.;total=0.
!!$
!!$    ! all velocity components
!!$    DO i=2,4
!!$       invar=0.
!!$       outvar=0.
!!$       invar(1:mxfix(1),1:mxfix(2),1:mxfix(3))=qfix(1:mxfix(1),1:mxfix(2),1:mxfix(3),i)/&
!!$            SQRT(qfix(1:mxfix(1),1:mxfix(2),1:mxfix(3),1))*PRODUCT(dxfix(1:ndim))
!!$       total=total+0.5*SUM(invar**2)
!!$
!!$       !CALL sfftw_plan_dft_r2c_3d(p, mxfix(1), mxfix(2), mxfix(3), invar, outvar, FFTW_ESTIMATE)
!!$       CALL sfftw_plan_dft_3d(p, mxfix(1), mxfix(2), mxfix(3), invar, outvar, FFTW_FORWARD, FFTW_ESTIMATE)   
!!$       CALL sfftw_execute(p)
!!$       CALL sfftw_destroy_plan(p)
!!$       
!!$       ! normalize
!!$       outvar=outvar/SQRT(REAL(PRODUCT(mxfix(1:ndim))))
!!$
!!$       DO iz=1,mxfix(3)
!!$       DO iy=1,mxfix(2)
!!$       DO ixx=1,mxfix(1)
!!$          ik=NINT(SQRT(REAL(ixx**2+iy**2+iz**2)))
!!$          ix=ixx
!!$          !IF(ixx>mxfix(1)/2+1) ix=mxfix(1)-ixx
!!$          Ek(ik)=Ek(ik)+0.5*ABS(outvar(ix,iy,iz))**2
!!$       END DO
!!$       END DO
!!$       END DO
!!$    END DO
!!$
!!$    PRINT*,total/SUM(Ek)
!!$
!!$    WRITE(fileName,'(A6,I5.5)')'ekspec',n
!!$    OPEN(UNIT=100,IOSTAT=iErr,FILE=filename//'.dat')
!!$    DO ik=1,maxk
!!$       ! energy power spectra, wave numeber in AU^-1, energy in ergs
!!$       WRITE(100,*) k(ik)*AU/lscale,Ek(ik)*(rscale*lscale**3*velscale**2)
!!$    END DO
!!$    CLOSE(100)
!!$
!!$    DEALLOCATE(Ek)
  END SUBROUTINE Ekpowerspectra

  ! dumps density to binary file
  SUBROUTINE dump_binary
    CHARACTER(LEN=16) :: filename
    INTEGER :: i,j,k
    WRITE(fileName,'(A7,I5.5,A4)')'out/den',n,'.bin'
    OPEN(UNIT=100,FILE=filename,FORM='UNFORMATTED')
    WRITE(100)(((qFix(i,j,k,1)*nscale,k=1,mxfix(3)),j=1,mxfix(2)),i=1,mxfix(1))
    CLOSE(100)
  END SUBROUTINE dump_binary

  SUBROUTINE percent_amb
    REAL :: percent,jet,tot,jet_grid,tot_grid
    INTEGER :: i,j,k
    !percent = (1.-SUM(SQRT(SUM(qFix(:,:,:,2:iSpeedHI)**2,4))*qFix(:,:,:,6)/qFix(:,:,:,1))&
    !     /SUM(SQRT(SUM(qFix(:,:,:,2:iSpeedHI)**2,4))))*100.
    jet_grid=0
    tot_grid=0
    DO k=1,mxfix(3)
    DO j=1,mxfix(2)
    DO i=1,mxfix(1)
       tot=SQRT(SUM(qFix(i,j,k,2:iSpeedHI)**2))
       jet=tot*qFix(i,j,k,6)/qFix(i,j,k,1)
       tot_grid=tot_grid+tot
       jet_grid=jet_grid+jet
    END DO
    END DO
    END DO

    percent=(1.-jet_grid/tot_grid)*100

    PRINT*,Time*runTimesc/31556926.,percent
    IF(n==frame) OPEN(100,FILE='percent_amb.dat')
    WRITE(100,*) Time*runTimesc/31556926.,percent
    IF(n==frameend) CLOSE(100)
  END SUBROUTINE percent_amb
  
  SUBROUTINE CUT
    INTEGER :: i,j
    j=mxfix(2)/2
    IF(qnvars>=1) CALL Primitive(qn,1)
    IF(qnvars>=2) CALL Primitive(qvx,2)
    IF(qnvars>=3) CALL Primitive(qvy,3)
    IF(qnvars>=4) CALL Primitive(qTemp,4)
    DO i=1,mxFix(1)
       PRINT*,XLower(1)+(REAL(i)-0.5)*dxFix(1)*lscale/1.49598e13,pFix(i,j,1,1),&
            pFix(i,j,1,2)*1e-5,pFix(i,j,1,4),qFix(i,j,1,5)/qFix(i,j,1,1)
    END DO
  END SUBROUTINE CUT

  SUBROUTINE Total_vorticity
    USE BearIO
    REAL(KIND=qprec) :: mean_vor,rmean_vor
    INTEGER :: i,j,k
    !CALL PrimitiveInit(3)
    CALL Primitive(qvorticity,1)

    mean_vor=0
    rmean_vor=0
    DO k=1,mxfix(3)
    DO j=1,mxfix(2)
    DO i=1,mxfix(1)
       mean_vor=mean_vor+SQRT(DOT_PRODUCT(pFix(i,j,k,1:3),pFix(i,j,k,1:3)))
       rmean_vor=mean_vor*qFix(i,j,k,1)
    END DO
    END DO
    END DO
    
    ! vorticity is calculated in computational units.  Put on physical units
    mean_vor=mean_vor*31556926.
    rmean_vor=rmean_vor*31556926.*rscale

    IF(n==frame) OPEN(100,FILE='total_vorticity.dat')
    PRINT*,Time*runTimesc/31556926.,mean_vor,rmean_vor
    WRITE(100,*) Time*runTimesc/31556926.,mean_vor,rmean_vor
    IF(n==frameend) CLOSE(100)
  END SUBROUTINE Total_vorticity

!!$  SUBROUTINE RT_Bubble(rhoHeavy,rhoLight)
!!$    INTEGER :: j,ju,jl,i,ibubble
!!$    REAL :: rhoHeavy,rhoLight
!!$    REAL :: rhoBoundary,rhoU,rhoL,y
!!$    REAL,PARAMETER :: Bubblefrac=.6
!!$
!!$    rhoBoundary=Bubblefrac*(rhoHeavy-rhoLight)+rhoLight
!!$    ! locate the bubble
!!$    DO j=mxfix(2),1,-1
!!$       IF(ANY(qFix(1:mxFix(1),j,1,1)<=rhoBoundary)) THEN
!!$          ju=j+1
!!$          jl=j
!!$          ! find where along the x slice the bubble was detected
!!$          DO i=1,mxFix(1)
!!$             IF(qFix(i,jl,1,1)<=rhoBoundary) THEN
!!$                iBubble=i
!!$                EXIT ! the bubble is found, break out of loop
!!$             END IF
!!$          END DO
!!$          EXIT ! the bubble is found, break out of loop
!!$       END IF
!!$    END DO
!!$    ! interpolate to the Bubblefrac position
!!$    rhoU=qFix(iBubble,ju,1,1)
!!$    rhoL=qFix(iBubble,jl,1,1)
!!$    y = (REAL(jl) + (rhoBoundary-rhoL)/(rhoU-rhoL))*dxFix(2)
!!$    IF(n==frame) OPEN(100,FILE='out/bubble_position.dat')
!!$    WRITE(100,*) Time*runTimesc,y*lscale
!!$    IF(n==frameend) CLOSE(100)
!!$  END SUBROUTINE RT_Bubble

  SUBROUTINE MVBin(vmin,vmax,nbin)
    REAL :: vmin,vmax,dv
    INTEGER :: nbin
    INTEGER :: PGOPEN,i,j,k,nb,iErr
    REAL, ALLOCATABLE, DIMENSION(:) :: binL,binH,bin,mbin,mbinamb
    REAL :: v
    REAL(KIND=qprec) :: scale
    CHARACTER(LEN=10) :: fileName
    
    scale=rscale*PRODUCT(dxfix(1:nDim))*lscale**nDim/mSolar
    ALLOCATE(binL(nbin),binH(nbin),bin(nbin),mbin(nbin),mbinamb(nbin),STAT=iErr)
    IF(iErr/=0) THEN
       PRINT*,'Error allocating bins'
       STOP
    END IF
    binL=0;binH=0;bin=0;mbin=0

    dv=(vmax-vmin)/REAL(nbin)
    DO i=1,nbin
       binL(i)=(i-1)*dv+vmin
       binH(i)=i*dv+vmin
       bin(i)=(REAL(i)-0.5)*dv+vmin
    END DO

    DO i=1,mxFix(1);DO j=1,mxFix(2);DO k=1,mxFix(3)
       v=SQRT(SUM(qFix(i,j,k,2:iSpeedHI)**2))/qFix(i,j,k,1)*velscale
       IF(v<binL(1) .OR. v>binH(nbin)) CYCLE
       DO nb=1,nbin
          IF(v>binL(nb) .AND. v<=binH(nb)) THEN
             mbin(nb)=mbin(nb)+qFix(i,j,k,1)
             mbinamb(nb)=mbinamb(nb)+qFix(i,j,k,1)*(1.-qFix(i,j,k,6)/qFix(i,j,k,1))
             CYCLE
          END IF
       END DO       
    END DO;END DO;END DO
    mbin=mbin*scale;mbinamb=mbinamb*scale
    bin=bin*1e-5 !convert to km/s

    WRITE(fileName,'(A5,I5.5)')'mvtot',n
    OPEN(UNIT=100,IOSTAT=iErr,FILE=filename//'.dat')
    DO nb=1,nbin
       WRITE(100,*) bin(nb),mbin(nb)
    END DO
    CLOSE(100)

    WRITE(fileName,'(A5,I5.5)')'mvamb',n
    OPEN(UNIT=100,IOSTAT=iErr,FILE=filename//'.dat')
    DO nb=1,nbin
       WRITE(100,*) bin(nb),mbinamb(nb)
    END DO
    CLOSE(100)

    WRITE(fileName,'(A5,I5.5)')'mvtot',n
    OPEN(UNIT=100,IOSTAT=iErr,FILE=filename//'.log.dat')
    DO nb=1,nbin
       WRITE(100,*) bin(nb),log10(mbin(nb))
    END DO
    CLOSE(100)

    WRITE(fileName,'(A5,I5.5)')'mvamb',n
    OPEN(UNIT=100,IOSTAT=iErr,FILE=filename//'.log.dat')
    DO nb=1,nbin
       WRITE(100,*) bin(nb),log10(mbinamb(nb))
    END DO
    CLOSE(100)

    WRITE(fileName,'(A5,I5.5)')'mvtot',n
    OPEN(UNIT=100,IOSTAT=iErr,FILE=filename//'.loglog.dat')
    DO nb=1,nbin
       WRITE(100,*) log10(bin(nb)),log10(mbin(nb))
    END DO
    CLOSE(100)

    WRITE(fileName,'(A5,I5.5)')'mvamb',n
    OPEN(UNIT=100,IOSTAT=iErr,FILE=filename//'.loglog.dat')
    DO nb=1,nbin
       WRITE(100,*) log10(bin(nb)),log10(mbinamb(nb))
    END DO
    CLOSE(100)

    mbin=log10(mbin);mbinamb=log10(mbinamb)
    WRITE(fileName,'(A5,I5.5)')'mvbin',n
    IF (PGOPEN('out/'//FileName//'.ps/ps') .LT. 1) STOP
    CALL PGENV(minval(binL),maxval(binH), 12., 18.,  0,  0)
    CALL PGLAB('|v| (km/s)', 'M log\d10\u(M\d\(2281)\u)', '')
    CALL PGLINE(nbin, bin, mbin)
    CALL PGSLS(2)
    CALL PGLINE(nbin, bin, mbinamb)
    CALL PGCLOS

    DEALLOCATE(binL,binH,bin,mbin,mbinamb)
  END SUBROUTINE MVBin


  SUBROUTINE ProcessSlice(zfrac,lWrite)
    USE BearIO
    LOGICAL lWrite
    REAL zfrac
    INTEGER i,j,iErr
    CHARACTER(LEN=20) :: fileName
    IF(.NOT.(ASSOCIATED(pFix))) THEN
       ALLOCATE(pFix(1:mxFix(1),1:mxFix(2),1,1),STAT=iErr);pnvars=1
       IF (iErr /= 0) THEN
          PRINT *,'!!! ERROR: failed to allocate p array'
          STOP
       END IF
    END IF
    DO i=1,mxFix(1)
    DO j=1,mxFix(2)
       pFix(i,j,1,1) = qFix(i,j,NINT(mxFix(3)*zfrac),1)*nscale
    END DO
    END DO
    WRITE(fileName,'(A11,I5.5,A4)')'out/pfixcut',n,'.hdf'
!    IF(lWrite) CALL WriteHDF2D(fileName,PRIM)
  END SUBROUTINE ProcessSlice

  SUBROUTINE Process2Slice(zfrac1,zfrac2,lWrite)
    USE BearIO
    LOGICAL lWrite
    REAL :: zfrac1,zfrac2
    INTEGER i,j,iErr
    CHARACTER(LEN=20) :: fileName
    REAL :: del,pfix1,pfix2,pfix3,pfixImpose
    REAL :: amb=1.0
    INTEGER :: iL,ih_,j1,jL,jH
    LOGICAL :: LAmb1,LAmb2
    IF(.NOT.(ASSOCIATED(pFix))) THEN
       ALLOCATE(pFix(1:mxFix(1),1:mxFix(2),1,1),STAT=iErr);pnvars=1
       IF (iErr /= 0) THEN
          PRINT *,'!!! ERROR: failed to allocate p array'
          STOP
       END IF
    END IF
    DO j=1,mxFix(2)
       ! find y-dir jet by looking for step at bow shock
       iL=0;ih_=0
       DO i=2,mxFix(1)
          del=ABS(qFix(i-1,j,NINT(mxFix(3)*zfrac1),1)-qFix(i,j,NINT(mxFix(3)*zfrac1),1))/amb
          IF(del>.1) THEN
             iL=i
             EXIT
          END IF
       END DO
       DO i=mxFix(1)-1,1,-1
          del=ABS(qFix(i,j,NINT(mxFix(3)*zfrac1),1)-qFix(i+1,j,NINT(mxFix(3)*zfrac1),1))/amb
          IF(del>.1) THEN
             ih_=i
             EXIT
          END IF
       END DO
    DO i=1,mxFix(1)
       pFix1 = qFix(i,j,NINT(mxFix(3)*zfrac1),1)
       pFix2 = qFix(i,j,NINT(mxFix(3)*zfrac2),1)
       pFix3 = qFix(i,j,NINT(mxFix(3)/2.),1)
       pFixImpose=pFix1
       ! if previous slices are close to ambient value, superimpose foreground slices
       !IF(pfix1>0.9*amb .AND. pFix1<1.1*amb) pFixImpose=pFix2
       IF(i<iL .OR. i>ih_) pFixImpose=pFix2
       IF(i<iL .OR. i>ih_) THEN!.AND. &
            !pfix2>0.98*amb .AND. pFix2<1.02*amb) THEN
          ! find x-dir jet by looking for step at bow shock
          jL=0;jH=0
          DO j1=2,mxFix(2)
             del=ABS(qFix(i,j1-1,NINT(mxFix(3)*zfrac2),1)-qFix(i,j1,NINT(mxFix(3)*zfrac2),1))/amb
             IF(del>.1) THEN
                jL=j1
                EXIT
             END IF
          END DO
          DO j1=mxFix(2)-1,1,-1
             del=ABS(qFix(i,j1,NINT(mxFix(3)*zfrac2),1)-qFix(i,j1+1,NINT(mxFix(3)*zfrac2),1))/amb
             IF(del>.1) THEN
                jH=j1
                EXIT
             END IF
          END DO
          IF(j<jL .OR. j>jH) pFixImpose=pFix3
       END IF
       pFix(i,j,1,1) = pFixImpose*nScale
    END DO
    END DO
    WRITE(fileName,'(A11,I5.5,A4)')'out/pfixcut',n,'.hdf'
!    IF(lWrite) CALL WriteHDF2D(fileName,PRIM)
  END SUBROUTINE Process2Slice

 SUBROUTINE PALETT(TYPE, CONTRA, BRIGHT)
    !-----------------------------------------------------------------------
    ! Set a "palette" of colors in the range of color indices used by
    ! PGIMAG.
    !-----------------------------------------------------------------------
    INTEGER TYPE
    REAL CONTRA, BRIGHT
    !
    REAL GL(2), GR(2), GG(2), GB(2)
    REAL RL(9), RR(9), RG(9), RB(9)
    REAL HL(5), HR(5), HG(5), HB(5)
    REAL WL(10), WR(10), WG(10), WB(10)
    REAL AL(20), AR(20), AG(20), AB(20)
    !
    DATA GL /0.0, 1.0/
    DATA GR /0.0, 1.0/
    DATA GG /0.0, 1.0/
    DATA GB /0.0, 1.0/
    !
    DATA RL /-0.5, 0.0, 0.17, 0.33, 0.50, 0.67, 0.83, 1.0, 1.7/
    DATA RR / 0.0, 0.0,  0.0,  0.0,  0.6,  1.0,  1.0, 1.0, 1.0/
    DATA RG / 0.0, 0.0,  0.0,  1.0,  1.0,  1.0,  0.6, 0.0, 1.0/
    DATA RB / 0.0, 0.3,  0.8,  1.0,  0.3,  0.0,  0.0, 0.0, 1.0/
    !
    DATA HL /0.0, 0.2, 0.4, 0.6, 1.0/
    DATA HR /0.0, 0.5, 1.0, 1.0, 1.0/
    DATA HG /0.0, 0.0, 0.5, 1.0, 1.0/
    DATA HB /0.0, 0.0, 0.0, 0.3, 1.0/
    !
    DATA WL /0.0, 0.5, 0.5, 0.7, 0.7, 0.85, 0.85, 0.95, 0.95, 1.0/
    DATA WR /0.0, 1.0, 0.0, 0.0, 0.3,  0.8,  0.3,  1.0,  1.0, 1.0/
    DATA WG /0.0, 0.5, 0.4, 1.0, 0.0,  0.0,  0.2,  0.7,  1.0, 1.0/
    DATA WB /0.0, 0.0, 0.0, 0.0, 0.4,  1.0,  0.0,  0.0, 0.95, 1.0/
    !
    DATA AL /0.0, 0.1, 0.1, 0.2, 0.2, 0.3, 0.3, 0.4, 0.4, 0.5, &
             0.5, 0.6, 0.6, 0.7, 0.7, 0.8, 0.8, 0.9, 0.9, 1.0/
    DATA AR /0.0, 0.0, 0.3, 0.3, 0.5, 0.5, 0.0, 0.0, 0.0, 0.0, &
             0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0/
    DATA AG /0.0, 0.0, 0.3, 0.3, 0.0, 0.0, 0.0, 0.0, 0.8, 0.8, &
             0.6, 0.6, 1.0, 1.0, 1.0, 1.0, 0.8, 0.8, 0.0, 0.0/
    DATA AB /0.0, 0.0, 0.3, 0.3, 0.7, 0.7, 0.7, 0.7, 0.9, 0.9, &
             0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0/
    !
    IF (TYPE.EQ.1) THEN
       !-- gray scale
       CALL PGCTAB(GL, GR, GG, GB, 2, CONTRA, BRIGHT)
    ELSE IF (TYPE.EQ.2) THEN
       !-- rainbow
       CALL PGCTAB(RL, RR, RG, RB, 9, CONTRA, BRIGHT)
    ELSE IF (TYPE.EQ.3) THEN
       !-- heat
       CALL PGCTAB(HL, HR, HG, HB, 5, CONTRA, BRIGHT)
    ELSE IF (TYPE.EQ.4) THEN
       !-- weird IRAF
       CALL PGCTAB(WL, WR, WG, WB, 10, CONTRA, BRIGHT)
    ELSE IF (TYPE.EQ.5) THEN
       !-- AIPS
       CALL PGCTAB(AL, AR, AG, AB, 20, CONTRA, BRIGHT)
    END IF
  END SUBROUTINE PALETT


  SUBROUTINE SETVP
    !-----------------------------------------------------------------------
    ! Set the viewport, allowing margins around the edge for annotation.
    ! (This is similar in effect to PGVSTD, but has different margins.)
    ! The routine determines the view-surface size and allocates margins
    ! as fractions of the minimum of width and height.
    !-----------------------------------------------------------------------
    REAL D, VPX1, VPX2, VPY1, VPY2
    !
    CALL PGSVP(0.0, 1.0, 0.0, 1.0)
    CALL PGQVP(1, VPX1, VPX2, VPY1, VPY2)
    D = MIN(VPX2-VPX1, VPY2-VPY1)/40.0
!!$    VPX1 = VPX1 + 5.0*D
!!$    VPX2 = VPX2 - 2.0*D
!!$    VPY1 = VPY1 + 8.0*D
!!$    VPY2 = VPY2 - 2.0*D

    VPX1 = VPX1 + 5.0*D
    VPX2 = VPX2 - 8.0*D
    VPY1 = VPY1 + 5.0*D
    VPY2 = VPY2 - 2.0*D

!!$    VPX1 = VPX1 + 12.0*D
!!$    VPX2 = VPX2 - 16.0*D
!!$    VPY1 = VPY1 + 7.0*D
!!$    VPY2 = VPY2 - 4.0*D

    CALL PGVSIZ(VPX1, VPX2, VPY1, VPY2)
  END SUBROUTINE SETVP
