      subroutine stream(a,bx,by,nx,ny,dx,dy)
      USE globaldeclarations
      USE bearIO
      implicit none
c************************************************************************
C     Computes stream function a from vector field bx,by
c************************************************************************
C     A is the result, we need contour plot of
c     parameter (nx = 4, ny = 4)
      integer :: nx,ny,i,j
      real*4 dx,dy
      real*4 a(nx+1,ny+1), bx(1:nx,1:ny), by(1:nx,1:ny)
      real*4 at(-1:nx+1,-1:ny+1)
      real*4 d(0:nx+1,0:ny+1),phi(-2:nx+3,-2:ny+3),phi2(-2:nx+3,-2:ny+3)
     +     ,g2phi(0:nx+1,0:ny+1),rgauss(3,3)
      real*4,save :: scale,shift
      real*4 :: tol
      logical, save :: lfirst=.TRUE.
c
      tol=1.e-4*SQRT(MAXVAL(bx(1:nx,1:ny)**2+by(1:nx,1:ny)**2))
c     divergence cleaning
      d=0.
      phi=0.
      phi2=0.
      g2phi=0.
      IF(iCylindrical /= 0) THEN !assume x is symmetry-axis
         FORALL(i=1:nx,j=1:ny)
             bx(i,j) = bx(i,j)*(XLower(2)+(REAL(j)-0.5)*dxFix(2))
             by(i,j) = by(i,j)*(XLower(2)+(REAL(j)-0.5)*dxFix(2))
         END FORALL
      END IF
      FORALL(i=2:nx-1,j=2:ny-1)
     +    d(i,j)=bx(i+1,j)-bx(i-1,j)+by(i,j+1)-by(i,j-1)
c     jacobi iteration
      DO WHILE(MAXVAL(ABS(g2phi(1:nx,1:ny)-d(1:nx,1:ny)))
     +     >tol)
c$$$         FORALL(i=1:nx,j=1:ny)
c$$$     +      phi2(i,j)=0.25d0*(phi(i+2,j)+phi(i,j+2)
c$$$     +                         +phi(i-2,j)+phi(i,j-2))
c$$$     +                         -0.25d0*d(i,j)
c$$$         phi=phi2

         DO i=1,nx; DO j=1,ny
           phi(i,j)=0.25d0*(phi(i+2,j)+phi(i,j+2)
     +                         +phi(i-2,j)+phi(i,j-2))
     +                         -0.25d0*d(i,j)
         END DO; END DO
         DO i=nx,1,-1; DO j=ny,1,-1
           phi(i,j)=0.25d0*(phi(i+2,j)+phi(i,j+2)
     +                         +phi(i-2,j)+phi(i,j-2))
     +                         -0.25d0*d(i,j)
         END DO; END DO
         DO i=nx,1,-1; DO j=1,ny
           phi(i,j)=0.25d0*(phi(i+2,j)+phi(i,j+2)
     +                         +phi(i-2,j)+phi(i,j-2))
     +                         -0.25d0*d(i,j)
         END DO; END DO
         DO i=1,nx; DO j=ny,1,-1
           phi(i,j)=0.25d0*(phi(i+2,j)+phi(i,j+2)
     +                         +phi(i-2,j)+phi(i,j-2))
     +                         -0.25d0*d(i,j)
         END DO; END DO

         FORALL(i=1:nx,j=1:ny)
     +       g2phi(i,j)=(phi(i+2,j)+phi(i,j+2)
     +                   +phi(i-2,j)+phi(i,j-2))
     +                   -4.*phi(i,j)
      END DO
      FORALL(i=1:nx,j=1:ny)
         bx(i,j)=bx(i,j)-(phi(i+1,j)-phi(i-1,j))
         by(i,j)=by(i,j)-(phi(i,j+1)-phi(i,j-1))
      END FORALL
c     end of divergence clean, check divergence
c      PRINT*,MAXVAL(ABS(d(2:nx-1,2:ny-1)))
c      FORALL(i=2:nx-1,j=2:ny-1) 
c     +    d(i,j)=bx(i+1,j)-bx(i-1,j)+by(i,j+1)-by(i,j-1)
c      PRINT*,MAXVAL(ABS(d(2:nx-1,2:ny-1)))
      IF(iCylindrical /= 0) THEN !assume x is symmetry axis
         FORALL(i=1:nx,j=1:ny)
             bx(i,j) = bx(i,j)/(XLower(2)+(REAL(j)-0.5)*dxFix(2))
             by(i,j) = by(i,j)/(XLower(2)+(REAL(j)-0.5)*dxFix(2))
         END FORALL
      END IF

c     NOTE: there are two ways to integrate the vector potential
c     the first one integrates from the left boundary (assuming 
c     extrapolation condition on left).  The second integrates from
c     the bottom.
c
c     the frist seems to be best if the left boundary is "smooth"
c     the ssecond is best if the lower boundary is smooth.

cc     integrate vector potential, starting from left
cc     left boundary
c      at = 0.
c      at(0:1,1) = at(0:1,-1) + bx(1,1)
c      DO j=2,ny
c         at(0:1,j)=at(0:1,j-2)+bx(1,j-1)
c      END DO
cc     interior
c      DO i=2,nx
c      DO j=1,ny
c         at(i,j)=at(i-2,j)-by(i-1,j)
c      END DO
c      END DO

cc     integrate vector potential, starting from right
cc     right boundary
      at = 0.
      at(nx:nx+1,1) = at(nx:nx+1,-1) + bx(nx,1)
      DO j=2,ny
         at(nx:nx+1,j)=at(nx:nx+1,j-2)+bx(nx,j-1)
      END DO
cc     interior
      DO i=nx-1,1,-1
      DO j=1,ny
         at(i,j)=at(i+2,j)+by(i+1,j)
      END DO
      END DO

c$$$cc     integrate vector potential, starting from bottom
c$$$cc     bottom boundary
c$$$      at = 0.
c$$$      at(1,0:1) = at(-1,0:1) - by(1,1)
c$$$      DO i=2,nx
c$$$         at(i,0:1)=at(i-2,0:1)-by(i-1,1)
c$$$      END DO
c$$$cc     interior
c$$$      DO i=1,nx
c$$$      DO j=2,ny
c$$$         at(i,j)=at(i,j-2)+bx(i,j-1)
c$$$      END DO
c$$$      END DO


c     remove red-black decoupling
c     interpolate to grid corners, A is returned as grid corner data
      FORALL(i=2:nx,j=2:ny)
     +     a(i,j)=0.25*(at(i,j)+at(i-1,j)+at(i,j-1)+at(i-1,j-1))
      at(3:nx-1,3:ny-1) = a(3:nx-1,3:ny-1)

c     gauusian smoothing
c     eliminates even-odd noise inherent to divergence cleaning
c      f=0.75
c      FORALL(i=1:3,j=1:3)
c     +     rgauss(i,j)=exp(-((REAL(i)-2.)**2+(REAL(j)-2.)**2)*f**2)
c      rgauss=rgauss/SUM(rgauss)
c      FORALL(i=2:nx-1,j=2:ny-1)
c     +   at(i,j)=SUM(at(i-1:i+1,j-1:j+1)*rgauss)

      IF(lfirst) THEN
         shift=MINVAL(at(3:nx-1,3:ny-1))
         scale=1./MAXVAL(at(3:nx-1,3:ny-1)-shift)
      END IF
      a=0.
      a(3:nx-1,3:ny-1)=(at(3:nx-1,3:ny-1)-shift)*scale
      lfirst=.false.
      END
