!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    bov2jpeg.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
program bov2jpeg
   USE IOPPM
   USE IOBOV
   USE Images
   IMPLICIT NONE
   TYPE(ImageDef) :: Image
   REAL(KIND=qPREC) :: minvalue, maxvalue, lower(2), upper(2), tnow, mymin, mymax
   REAL(KIND=qPREC), DIMENSION(:,:), POINTER :: data
   INTEGER :: N, nfiles, i, iErr
   CHARACTER(LEN=10) :: SCALE
   CHARACTER(LEN=60) :: BOVFILE, MINSTRING, MAXSTRING, PPMFILE
   CHARACTER(LEN=200) :: syscmd
   REAL(KIND=qPREC), PARAMETER :: UNSPECIFIED=1e30
   N=IARGC()

   IF (N < 1) THEN
      WRITE(*,*) 'usage: bov2jpeg file(s) [ [ log | linear ] [ minvalue [ maxvalue ]]] '
      STOP
   END IF
   nFiles=0
   scale='linear'
   DO i=1, N
      CALL GetARG(i,BOVFile)
      IF (TRIM(BOVFile) .eq. 'LINEAR') THEN
         SCALE='linear    '
         EXIT
      ELSEIF (TRIM(BOVFile) .eq. 'LOG') THEN
         SCALE='log       '
         EXIT
      ELSEIF (TRIM(BOVFile) .eq. 'linear') THEN
         SCALE='linear    '
         EXIT
      ELSEIF (TRIM(BOVFile) .eq. 'log') THEN
         SCALE='log       '
         EXIT
      ELSE
         nFiles=i
      END IF
   END DO
   write(*,*) 'found ', nfiles, ' files'
   write(*,*) 'SCALE= ', TRIM(SCALE)

   IF (N >= nFiles+2) THEN 
      CALL GETARG(nFiles+2,MINSTRING)
      READ(MINSTRING, *) minvalue
   ELSE
      minvalue=UNSPECIFIED !MINOVERALL !minval(data)
   END IF

   IF (N >= nFiles+3) THEN 
      CALL GETARG(nFiles+3,MAXSTRING)
      READ(MAXSTRING, *) maxvalue
   ELSE
      maxvalue=UNSPECIFIED !MAXOVERALL !maxval(data)
   END IF
   OPEN(UNIT=11, FILE='cmap.data', STATUS='old', IOSTAT=iErr)
   IF (iErr == 0) THEN
      READ(11,*) Image%npoints
      IF (Image%npoints > 10) write(*,*), 'error image only supports ', MaxCMapPoints, ' points'
      Image%npoints=min(Image%npoints, 10)
      DO i=1,Image%npoints
         READ(11,*) Image%cmap(i,:)
      END DO
      CLOSE(11)
   END IF

   DO i=1,nfiles
      CALL GetARG(i,BOVFile)
      CALL ReadBOV2DScalar(BOVFile, lower, upper, tnow, data)
      write(*,*) 'found data:', lower, upper, tnow, shape(data)
      IF (minvalue == UNSPECIFIED) THEN
         mymin=minval(data)
      ELSE
         mymin=minvalue
      END IF
      IF (maxvalue == UNSPECIFIED) THEN
         mymax=maxval(data)
      ELSE
         mymax=maxvalue
      END IF

      write(*,*) 'mymin=', mymin
      write(*,*) 'mymax=', mymax
      IF (TRIM(SCALE) .eq. 'log') THEN
         mymin=log(mymin)
         mymax=log(mymax)
         data=log(data)
      END IF
      n=len_trim(bovfile)
      WRITE(PPMFILE,'(A,A4)') BOVFILE(1:n-4), '.ppm'
      CALL WritePPM(PPMFILE, Image%cmap(1:Image%npoints,:),data, mymin, mymax)
      WRITE(syscmd, '(A8,A,A1,A,A11,A)') 'convert ', TRIM(PPMFILE), ' ', BOVFILE(1:n-4), '.jpg && rm ', TRIM(PPMFILE)
      !    write(*,*) 'calling ', syscmd

      CALL System(syscmd)
   END DO
end program bov2jpeg
