!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    communication_control.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
MODULE CommunicationControl
   USE GlobalDeclarations
   USE CommunicationDeclarations
   USE MpiPacking
   USE MessageDeclarations
IMPLICIT NONE

   PUBLIC InitMessageGroups, CommInit, MPI_CHECK_MSG_GROUPS
PRIVATE

CONTAINS

   !> Allocates variables associated with module
   SUBROUTINE CommInit()


      INTEGER :: ierr
      INTEGER :: n
      CHARACTER(LEN=14) :: FILENAME

      !Do MPI Stuff
      CALL PrintProcName()
!      write(FILENAME,'(A5,I4.4,A4)') "comm_",mpi_id,".log"
!      OPEN (UNIT=COMM_LOG_HANDLE, file=FILENAME, status="unknown")

!      packet_buffers = 4096

!      packet_buffers(TRANSMIT_CHILD_GRIDS / 1000) = 80
!      packet_buffers(TRANSMIT_OVERLAPS_NEIGHBORS / 1000) = 40
!      packet_buffers(TRANSMIT_OLD_NODE_OVERLAPS / 1000) = 80
!      packet_buffers(TRANSMIT_NEIGHBORING_CHILDREN / 1000) = 80
!      packet_buffers(TRANSMIT_OLC_TO_OLD_NODES / 1000) = 80
!      packet_buffers(TRANSMIT_OLC_TO_NEW_NODES / 1000) = 80
!      packet_buffers(TRANSMIT_IO_WORKER_GRIDS / 1000) = 80


      !> @remark Read in packet buffer data.
!      OPEN(UNIT=COMMUNICATION_DATA_HANDLE,FILE=COMMUNICATION_DATA_FILE)
!      READ(COMMUNICATION_DATA_HANDLE,NML=CommunicationData)
!      CLOSE(COMMUNICATION_DATA_HANDLE)

      ALLOCATE(stage_times(-2:MaxLevel,nStages))
      stage_times = 0.d0

      CALL InitMessageGroups
   END SUBROUTINE CommInit

   !> Initializes Message Groups
   SUBROUTINE InitMessageGroups
      INTEGER :: i,j
      ALLOCATE(StageMessageGroups(nStages,-2:MaxLevel))
      DO i=1,nStages
         DO j=-2,Maxlevel
            NULLIFY(StageMessageGroups(i,j)%p)
         END DO
      END DO

   END SUBROUTINE InitMessageGroups


   SUBROUTINE MPI_CHECK_MSG_GROUPS(iRecvMessage, iSendMessage, nRecv, nSend)
      INTEGER :: iRecvMessage, iSendMessage, nRecv, nSend, iErr
      TYPE(StageMessageGroup), POINTER :: RecvMessageGroup, SendMessageGroup
      INTEGER, DIMENSION(:,:), ALLOCATABLE :: SendArray, RecvArray
      INTEGER, DIMENSION(:), POINTER :: RecvProcArray, SendProcArray
      INTEGER :: i, j
      TYPE(PackedMessage), POINTER :: message
      RecvMessageGroup=>StageMessageGroups(iRecvMessage, nRecv)%p
      SendMessageGroup=>StageMessageGroups(iSendMessage, nSend)%p
      ALLOCATE(SendArray(0:MPI_NP-1, 0:MPI_NP-1))
      ALLOCATE(RecvArray(0:MPI_NP-1, 0:MPI_NP-1))
      CALL GetProcListAsArray(RecvMessageGroup, RecvProcArray)
      CALL GetProcListAsArray(SendMessageGroup, SendProcArray)
      SendArray=0
      RecvArray=0
!      IF (ASSOCIATED(RecvProcArray)) RecvArray(RecvProcArray, MPI_ID)=1
!      IF (ASSOCIATED(SendProcArray)) SendArray(MPI_ID, SendProcArray)=1

      IF (ASSOCIATED(RecvProcArray)) THEN
         DO i=1, size(RecvProcArray)
            CALL ExtractMessageFromGroup(RecvMessageGroup, RecvProcArray(i), message)
            RecvArray(RecvProcArray(i), MPI_ID) = message%buffer_size
         END DO
      END IF
      IF (ASSOCIATED(SendProcArray)) THEN
         DO i=1, size(SendProcArray)
            CALL ExtractMessageFromGroup(SendMessageGroup, SendProcArray(i), message)
            SendArray(MPI_ID, SendProcArray(i)) = message%buffer_size
         END DO
      END IF

      CALL MPI_ALLREDUCE(MPI_IN_PLACE, SendArray, MPI_NP*MPI_NP, MPI_INTEGER, MPI_SUM, levels(nRecv)%MPI_COMM, iErr)
      CALL MPI_ALLREDUCE(MPI_IN_PLACE, RecvArray, MPI_NP*MPI_NP, MPI_INTEGER, MPI_SUM, levels(nSend)%MPI_COMM, iErr)

      IF (.NOT. ALL(SendArray==RecvArray)) THEN

         write(*,'(8I8)') SendArray
         write(*,*) '------------------'
         write(*,'(8I8)') RecvArray
         write(*,*) '------------------'
         DO i=0, MPI_NP-1
            DO j=0, MPI_NP-1
               IF (SendArray(i,j) > RecvArray(i,j)) THEN
                  write(*,*) 'processor ', i , 'only sending to ', j
               ELSE IF (SendArray(i,j) < RecvArray(i,j)) THEN
                  write(*,*) 'processor ', j , 'only receiving from ', i
               END IF
            END DO
            IF (SendArray(i,i) /= 0) THEN
               write(*,*) 'sending to myself'
               STOP
            END IF
         END DO
!         IF (.NOT. ALL(SendArray==RecvArray)) THEN
1        write(*,*) iRecvMessage, iSendMessage, nRecv, nSend, levels(nRecv)%CurrentLevelStep
         STOP
      END IF
   END SUBROUTINE MPI_CHECK_MSG_GROUPS


   !> Prints processor name
   SUBROUTINE PrintProcName()

       INTEGER :: ierr
       INTEGER :: resultlength
       CHARACTER(LEN=MPI_MAX_PROCESSOR_NAME) :: name_string

       CALL MPI_GET_PROCESSOR_NAME(name_string,resultlength,ierr)

!       PRINT *, "Proc ", MPI_id, " name = ", TRIM(name_string)

   END SUBROUTINE PrintProcName


!   SUBROUTINE CommunicationStats()
!
!       REAL(KIND=qPrec), DIMENSION(-2:MaxLevel) :: level_slice
!       REAL(KIND=qPrec) :: input, buffer
!       INTEGER :: ierr
!       
!       DO stage = 1, nStages
!            DO n = -2, MaxLevel
!                 input = stage_time(n,stage)
!                 CALL MPI_REDUCE(input, buffer, 1, MPI_DOUBLE_PRECISION, MPI_SUM, Master, MPI_COMM_WORLD, ierr)
!                 level_slice(n) = buffer
!            END DO
!
!            PRINT "('Level averages
!       END DO
!   END SUBROUTINE CommunicationStats



   
END MODULE CommunicationControl
