!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    communication_declarations.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
!> @dir communication
!! @brief Contains modules for handling communications

!> @defgroup Communication Communication
!! @brief Contains modules for handling communications

!> @file communication_declarations.f90
!! @brief Main file for module CommunicationDeclarations

!> @defgroup CommunicationDeclarations Communication Declarations
!! @brief Contains some initialization routines and communication parameters
!! @ingroup Communication

!> Contains some initialization routines and communication parameters
!! @ingroup CommunicationDeclarations
MODULE CommunicationDeclarations

   USE GlobalDeclarations
   USE MessageDeclarations
!   USE MpiPacking
   IMPLICIT NONE
   SAVE

   PRIVATE

   !Use TAG_STAGE_MULTIPLIER to define stages
   INTEGER, PUBLIC, PARAMETER :: iRecvGridsFromParents=1, iSendGridsToChildren=2, TRANSMIT_CHILD_GRIDS=1, &
                                 iRecvParentsData=3, iSendChildrenData=4, TRANSMIT_CHILD_DATA=2, &
                                 iRecvOverlapsNeighbors=5, iSendOverlapsNeighbors=6, TRANSMIT_OVERLAPS_NEIGHBORS=3, &
                                 iRecvOldNodeOverlaps=7, iSendOverlapsToOldNodesChildren=8, &
                                    iSendOverlapsToNodesOldChildren=10, TRANSMIT_OLD_NODE_OVERLAPS=4, &
                                 iRecvOverlaps=11, iSendOverlaps=12, TRANSMIT_OVERLAP_DATA=5, &
                                 iRecvNeighboringChildren=13, iSendNeighboringChildren=14, TRANSMIT_NEIGHBORING_CHILDREN=6, &
                                 iRecvOverlappingChildrenFromNewNodes=15, iSendOverlappingChildrenToOldNodes=16, &
                                 TRANSMIT_OLC_TO_OLD_NODES=7, &
                                 iRecvOverlappingChildrenFromOldNodes=17, iSendOverlappingChildrenToNewNodes=18, &
                                 TRANSMIT_OLC_TO_NEW_NODES=8, &
                                 iRecvChildrenData=19, iSendParentsData=20, TRANSMIT_PARENT_DATA=9, &
                                 iRecvFluxes=21, iSendFluxes=22, TRANSMIT_FLUX_DATA=10, &
                                 iRecvGenericData=23, iSendGenericData=24, TRANSMIT_GENERIC_DATA=11

    INTEGER, PUBLIC, PARAMETER :: TRANSMIT_DOMAIN_DATA=12
    INTEGER, PUBLIC, PARAMETER :: TRANSMIT_FRAME_DATA=13

    INTEGER, PUBLIC, PARAMETER :: TRANSMIT_IO_WORKER_GRIDS = 14
    INTEGER, PUBLIC, PARAMETER :: TRANSMIT_IO_WORKER_DATA = 15
    INTEGER, PUBLIC, PARAMETER :: LAYOUT_TAG=16

   INTEGER, PUBLIC, PARAMETER :: nStages=24
   INTEGER, PUBLIC, PARAMETER :: N_TRANSMIT_FLAGS = 15   

   REAL(KIND=qPrec), PUBLIC, ALLOCATABLE, DIMENSION(:,:) :: stage_times
   REAL(KIND=qPrec), PUBLIC :: tcache

!   INTEGER, PUBLIC, DIMENSION(N_TRANSMIT_FLAGS) :: packet_buffers

!   NAMELIST /CommunicationData/ packet_buffers

 !  PUBLIC CommunicationData
   Type(pStageMessageGroup), PUBLIC, Dimension(:,:), Allocatable :: StageMessageGroups
   LOGICAL, PUBLIC :: STAGE_RECV=.FALSE., STAGE_SEND=.TRUE.


!   INTEGER, PUBLIC :: MPI_NP=1
   INTEGER, PUBLIC, PARAMETER :: MASTER = 0
  
!  INCLUDE 'mpif.h'
END MODULE CommunicationDeclarations
