!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    elliptic_comms.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
MODULE EllipticComms
   USE DataLevelComms
   USE GlobalDeclarations
   USE TreeDeclarations
   USE DataLevelOps
  !  USE DataInfoOps


CONTAINS

   !> Manages Ghosting of fields in q on grids on level n for nghost cells
   !! @param n level
   !! @param fields index array to transfer
   !! @param nghost number of ghost cells to fill
   SUBROUTINE EllipticTransfer(n,fields,nghost)
      INTEGER :: n   
      INTEGER, DIMENSION(:) :: fields
      INTEGER :: nghost
      CALL GenericTransfer(n, fields, nghost, lEllipticPeriodic)
      !   write(*,*) 'ghosting', n, fields, nghost
!      CALL PostRecvGenericData(n, fields, nghost, lEllipticPeriodic)  ! [BDS][20110113]: Added fields, ghost to facilitate precalculation.
!      CALL PostSendGenericData(n,fields,nghost, lEllipticPeriodic)
!      CALL ApplyGenericOverlaps(n,fields,nghost, lEllipticPeriodic)
      !    CALL MPI_CHECK_MSG_GROUPS(iRecvEllipticData, iSendEllipticData, n, n)
!      CALL CompRecvGenericData(n,fields)
!      CALL CompSendGenericData(n)
   END SUBROUTINE EllipticTransfer

   !> Ghosts fields in q on local grids on level n for nghost cells
   !! @param n level
   !! @param fields index array to transfer
   !! @param nghost number of ghost cells to fill
!   SUBROUTINE ApplyEllipticOverlaps(n,fields,nghost)
!      INTEGER :: n,step
!      TYPE(NodeDef), POINTER :: node, neighbor
!      TYPE(NodeDefList), POINTER :: nodelist, neighborlist
!      INTEGER, DIMENSION(:) :: fields
!      INTEGER :: nghost
!      nodelist=>Nodes(n)%p 
!      DO WHILE (associated(nodelist))
!         node=>nodelist%self 
!         neighborlist=>node%neighbors 
!         DO WHILE (associated(neighborlist))
!            neighbor=>neighborlist%self 
!            IF (neighbor%box%MPI_ID == MPI_ID) CALL ApplyEllipticOverlap(node%info,neighbor%info,n,fields,nghost) 
!            neighborlist=>neighborlist%next
!         END DO
!         CALL ApplyEllipticOverlap(node%info,node%info,n,fields,nghost)
!         nodelist=>nodelist%next 
!      END DO
!   END SUBROUTINE ApplyEllipticOverlaps


END MODULE EllipticComms
