/*! \file extended_hypre_wrapper.h
\brief Header file for extended_hypre_wrapper.c
*/
#define F_HYPRE_STRUCT 0
#define F_HYPRE_SSTRUCT 1
#define F_HYPRE_PARCSR 2

void c_structgridcreate(long int *, int *, long int *, int *);
void c_structgridsetextents(long int *, int *, int *, int *);
void c_structgridassemble(long int *, int *);
void c_structgriddestroy(long int *, int *);
void c_structstencilcreate(int *, int *, long int *, int *);
void c_structstencilsetelement(long int *, int *, int *, int *);
void c_structstencildestroy(long int *, int *);
void c_structmatrixcreate(long int *, long int *, long int *, long int *, int *);
void c_structmatrixinitialize(long int *, int *);
void c_structmatrixsetboxvalues(long int *, int *, int *, int *, int *, double *, int *);
void c_structmatrixassemble(long int *, int *);
void c_structmatrixdestroy(long int *, int *);
void c_structvectorcreate(long int *, long int *, long int *, int *);
void c_structvectorinitialize(long int *, int *);
void c_structvectorsetboxvalues(long int *, int *, int *, double *, int *);
void c_structvectorgetboxvalues(long int *, int *, int *, double *, int *);
void c_structvectorassemble(long int *, int *);
void c_structvectordestroy(long int *, int *);
void c_structpcgcreate(long int *, long int *, int *);
void c_structpcgsetup(long int *, long int *, long int *, long int *, int *);
void c_structpcgsolve(long int *, long int *, long int *, long int *, int *);
void c_structpcgsettol(long int *, double *, int *);
void c_structpcgsetprintlevel(long int *, int *, int *);
void c_structpcgdestroy(long int *, int *);
void c_structgmrescreate(long int *, long int *, int *);
void c_structgmresdestroy(long int *, int *);
void c_structgmressetup(long int *, long int *, long int *, long int *, int *);
void c_structgmressolve(long int *, long int *, long int *, long int *, int *);
void c_structgmressettol(long int *, double *, int *);
void c_structgmressetprintlevel(long int *, int *, int *);

void c_sstructgridcreate(long int *, int *, int *, long int *, int *);
void c_sstructgridsetextents(long int *, int *, int *, int *, int *);
void c_sstructgridsetperiodic(long int *, int *, int *, int *);
void c_sstructgridsetvariables(long int *, int *, int *, int *);
void c_sstructgridassemble(long int *, int *);
void c_sstructgriddestroy(long int *, int *);
void c_sstructgridsetnumghost(long int *, int *, int *);
void c_sstructstencilcreate(int *, int *, long int *, int *);
void c_sstructstencilsetentry(long int *, int *, int *, int *, int *);
void c_sstructstencildestroy(long int *, int *);
void c_sstructgraphcreate(long int *, long int *, long int *, int *); 
void c_sstructgraphsetstencil(long int *, int *, int *, long int *, int *);
void c_sstructgraphaddentries(long int *, int *, int *, int *, int *, int *, int *, int *);
void c_sstructgraphassemble(long int *, int *);
void c_sstructgraphdestroy(long int *, int *);
void c_sstructmatrixcreate(long int *, long int *, long int *, int *);
void c_sstructmatrixsetobjecttype(long int *, int *, int *);
void c_sstructmatrixgetobject(long int *, long int *, int *);
void c_sstructmatrixinitialize(long int *, int *);
void c_sstructmatrixsetboxvalues(long int *, int *, int *, int *, int *, int *, int *, double *, int *);
void c_sstructmatrixsetvalues(long int *, int *, int *, int *, int *, int *, double *, int *);
void c_sstructmatrixassemble(long int *, int *);
void c_sstructmatrixdestroy(long int *, int *);
void c_sstructmatrixprint(char *, long int *, int *, int *);
void c_sstructvectorcreate(long int *, long int *, long int *, int *);
void c_sstructvectorinitialize(long int *, int *);
void c_sstructvectorsetboxvalues(long int *, int *, int *, int *, int *, double *, int *);
void c_sstructvectorgetboxvalues(long int *, int *, int *, int *, int *, double *, int *);
void c_sstructvectorsetbobjecttype(long int *, int *, int *);
void c_sstructvectorgetobject(long int *, long int *, int *);
void c_sstructvectorgather(long int *, int *);
void c_sstructvectorassemble(long int *, int *);
void c_sstructvectordestroy(long int *, int *);
void c_sstructpcgcreate(long int *, long int *, int *);
void c_sstructpcgsetup(long int *, long int *, long int *, long int *, int *);
void c_sstructpcgsolve(long int *, long int *, long int *, long int *, int *);
void c_sstructpcgsettol(long int *, double *, int *);
void c_sstructpcgsetprintlevel(long int *, int *, int *);
void c_sstructpcgdestroy(long int *, int *);

void c_parcsrpcgcreate(long int *, long int *, int *);
void c_parcsrpcgsettol(long int *, double *, int *);
void c_parcsrpcgsetup(long int *, long int *, long int *, long int *, int *);
void c_parcsrpcgsolve(long int *, long int *, long int *, long int *, int *);
void c_parcsrpcgsetprintlevel(long int *, int *, int *);
void c_parcsrpcgdestroy(long int *, int *);

void c_parcsrgotime(long int *, long int *, long int *, double *, int *, int *);

void c_sstructgmrescreate(long int *, long int *, int *);
void c_sstructgmresdestroy(long int *, int *);
void c_sstructgmressetup(long int *, long int *, long int *, long int *, int *);
void c_sstructgmressolve(long int *, long int *, long int *, long int *, int *);
void c_sstructgmressettol(long int *, double *, int *);
void c_sstructgmressetprintlevel(long int *, int *, int *);
void c_sstructgmressetkdim(long int *, int *, int *);

