!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    explicit_control.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
MODULE ExplicitControl

  USE GlobalDeclarations
  USE ResistiveSrc
  USE ConductiveSrc
  USE BViscositySrc
  USE PhysicsDeclarations
  USE ExplicitDeclarations
  IMPLICIT NONE

CONTAINS
  
  !> Initialize explicit solver
  SUBROUTINE ExplicitInit
    ALLOCATE(explicit_maxspeed(0:maxlevel))
    explicit_maxspeed=0d0
  END SUBROUTINE ExplicitInit

  !> Initial explicit call
  SUBROUTINE InitialExplicit(n)
    INTEGER :: n

    CALL ExplicitGetMaxSpeed(n)

  END SUBROUTINE InitialExplicit
  
  !> Apply explicit solver by calling the source term functions
  SUBROUTINE Explicit(n)
    INTEGER :: i,n,nmax,nsteps,stepping   

    stepping = 1; nmax=MaxLevel; nsteps=0

    DO i=0,n
       nsteps=nsteps+(levels(i)%step-1)*2**(nmax-i)
    END DO

    nsteps=mod(nsteps,6)

    SELECT CASE(nsteps)

    CASE(0)
       !PRINT*, "explicit case 0 called"
       IF(lResistive) THEN 
          CALL ResistiveGridAdvance(n,stepping)
          stepping=stepping+1
       END IF
       IF(lConductive) THEN
          CALL ConductiveGridAdvance(n,stepping)
          stepping=stepping+1
       END IF
       IF(lViscous)THEN
          CALL BViscosityGridAdvance(n,stepping)
       END IF

    CASE(1)
       !PRINT*, "explicit case 1 called"
       IF(lConductive) THEN
          CALL ConductiveGridAdvance(n,stepping)
          stepping=stepping+1
       END IF
       IF(lResistive) THEN 
          CALL ResistiveGridAdvance(n,stepping)
          stepping=stepping+1
       END IF
       IF(lViscous)THEN
          CALL BViscosityGridAdvance(n,stepping)
       END IF

    CASE(2)
       !PRINT*, "explicit case 2 called"
       IF(lConductive) THEN
          CALL ConductiveGridAdvance(n,stepping)
          stepping=stepping+1
       END IF
       IF(lViscous)THEN
          CALL BViscosityGridAdvance(n,stepping)
          stepping=stepping+1
       END IF
       IF(lResistive) THEN 
          CALL ResistiveGridAdvance(n,stepping)
       END IF

    CASE(3)
       !PRINT*, "explicit case 3 called"
       IF(lResistive) THEN 
          CALL ResistiveGridAdvance(n,stepping)
          stepping=stepping+1
       END IF
       IF(lViscous)THEN
          CALL BViscosityGridAdvance(n,stepping)
          stepping=stepping+1
       END IF
       IF(lConductive) THEN
          CALL ConductiveGridAdvance(n,stepping)
       END IF

    CASE(4)
       !PRINT*, "explicit case 4 called"
       IF(lViscous)THEN
          CALL BViscosityGridAdvance(n,stepping)
          stepping=stepping+1
       END IF
       IF(lResistive) THEN 
          CALL ResistiveGridAdvance(n,stepping)
          stepping=stepping+1
       END IF
       IF(lConductive) THEN
          CALL ConductiveGridAdvance(n,stepping)
       END IF

    CASE(5)
       !PRINT*, "explicit case 5 called"
       IF(lViscous)THEN
          CALL BViscosityGridAdvance(n,stepping)
          stepping=stepping+1
       END IF
       IF(lConductive) THEN
          CALL ConductiveGridAdvance(n,stepping)
          stepping=stepping+1
       END IF
       IF(lResistive) THEN 
          CALL ResistiveGridAdvance(n,stepping)
       END IF

   END SELECT

  END SUBROUTINE Explicit

  !> find out max speed of explicit solver
  SUBROUTINE ExplicitGetMaxSpeed(n)
    INTEGER :: n
    IF(lResistive)  CALL ResistiveGridGetMaxSpeed(n)
    IF(lConductive) CALL ConductiveGridGetMaxSpeed(n)
    IF(lViscous)    CALL BViscosityGridGetMaxSpeed(n)

  END SUBROUTINE ExplicitGetMaxSpeed
  
  
END MODULE ExplicitControl
