!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    sweep_declarations.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
!> @file sweep_declarations.f90
!> @brief Module for setting up stencil pieces and defining dependencies for sweep scheme
!! @details ghost module to set up dependencies


MODULE SchemeDeclarations
  USE StencilDeclarations
  USE GlobalDeclarations
  USE PhysicsDeclarations

  IMPLICIT NONE

  SAVE

  PUBLIC

  INTEGER :: w = 0
  INTEGER :: qLx = 0
  INTEGER :: qRx = 0
  INTEGER :: qLy = 0
  INTEGER :: qRy = 0
  INTEGER :: qLz = 0
  INTEGER :: qRz = 0
  INTEGER :: fx = 0
  INTEGER :: fy = 0
  INTEGER :: fz = 0
  INTEGER :: q2Lx = 0
  INTEGER :: q2Rx = 0
  INTEGER :: q2Ly = 0
  INTEGER :: q2Ry = 0
  INTEGER :: q2Lz = 0
  INTEGER :: q2Rz = 0
  INTEGER :: f2x = 0
  INTEGER :: f2y = 0
  INTEGER :: f2z = 0
  INTEGER :: limiter_x = 0
  INTEGER :: limiter_y = 0
  INTEGER :: limiter_z = 0
  INTEGER :: limiter_ppm = 0
  INTEGER :: pT = 0
  INTEGER :: qex = 0
  INTEGER :: qey = 0
  INTEGER :: qez = 0
  INTEGER :: dqx = 0
  INTEGER :: dqy = 0
  INTEGER :: dqz = 0
  INTEGER :: ex = 0
  INTEGER :: ey = 0
  INTEGER :: ez = 0
  INTEGER :: ex_bar = 0
  INTEGER :: ey_bar = 0
  INTEGER :: ez_bar = 0
  INTEGER :: e2x = 0
  INTEGER :: e2y = 0
  INTEGER :: e2z = 0
  INTEGER :: e2x_bar = 0
  INTEGER :: e2y_bar = 0
  INTEGER :: e2z_bar = 0
  INTEGER :: ctfy = 0
  INTEGER :: ctfz = 0
  INTEGER :: ctfx = 0
  INTEGER :: ctf2x = 0
  INTEGER :: ctf2y = 0
  INTEGER :: ctf2z = 0
  INTEGER :: w2 = 0
  INTEGER :: A2x = 0
  INTEGER :: A2y = 0
  INTEGER :: A2z = 0
  INTEGER :: Sx = 0
  INTEGER :: Sy = 0
  INTEGER :: Sz = 0
  INTEGER :: w3 = 0
  INTEGER :: A3x = 0
  INTEGER :: A3y = 0
  INTEGER :: A3z = 0
  INTEGER :: SpeedsX = 0
  INTEGER :: SpeedsY = 0
  INTEGER :: SpeedsZ = 0
  INTEGER :: leftX = 0
  INTEGER :: leftY = 0
  INTEGER :: leftZ = 0
  INTEGER :: rightX = 0
  INTEGER :: rightY = 0
  INTEGER :: rightZ = 0
  INTEGER :: nWaves = 0
  INTEGER :: req_eigens = 0
  INTEGER :: adfx = 0
  INTEGER :: adfy = 0
  INTEGER :: adfz = 0
  INTEGER :: eta2x = 0
  INTEGER :: eta2y = 0
  INTEGER :: eta2z = 0
  INTEGER :: etax = 0
  INTEGER :: etay = 0
  INTEGER :: etaz = 0
  INTEGER :: q = 0
  INTEGER :: aux = 0
  INTEGER :: recon = 0
  INTEGER :: beforesweepstep = 0
  INTEGER :: aftersweepstep = 0
  INTEGER :: source = 0
  INTEGER :: source2 = 0
  INTEGER :: cornerdiv = 0
  INTEGER :: gradphix = 0
  INTEGER :: gradphiy = 0
  INTEGER :: gradphiz = 0



  !> Contains a set of stencils for a given level

  INTEGER, DIMENSION(:), ALLOCATABLE :: index_start_bylevel
  INTEGER, PARAMETER :: THEBEGINNING=-999999 
  INTEGER, PARAMETER :: NO_VISCOSITY=0, ROE_VISCOSITY=1, H_VISCOSITY=2
  INTEGER, PARAMETER :: NONLAGRANGIAN=0, LAGRANGIAN=1

  REAL (KIND=xPrec), PARAMETER :: fourth=.25d0, third=1.d0/3.d0, sixth=1.d0/6.d0, epsilon=1e-13
  INTEGER :: SweepConsTemp, SweepCons
  LOGICAL :: lGudonov, lChar_Limiters, lCautious, lHLLTypeSolver, lCTU, lLimiter, lIsothermal, lUsePPML
  INTEGER :: InterpOrder = 3

  INTEGER :: ViscCD = NO_VISCOSITY
  LOGICAL :: lApplyLOF = .false.
  LOGICAL :: lApplyDiffusion=.true.
  REAL(KIND=qpREC) :: LOF_ALPHA=.075, DIFF_ALPHA=.1
  


  INTEGER, ALLOCATABLE, DIMENSION(:) :: SweepFluxFields
  INTEGER :: nSweepFlux
  INTEGER :: iTracer=NONLAGRANGIAN
  INTEGER :: CurrentLevelLoaded=-1

CONTAINS


  SUBROUTINE SetStencilNrVars
    IF (beforesweepstep /= 0) Stencil(beforesweepstep)%NrVars=(/1,NrHydroVars/)
    IF (w /= 0) Stencil(w)%NrVars=(/1,SweepCons/)
    IF (qLx /= 0) Stencil(qLx)%NrVars=(/1,SweepCons/)
    IF (qRx /= 0) Stencil(qRx)%NrVars=(/1,SweepCons/)
    IF (qLy /= 0) Stencil(qLy)%NrVars=(/1,SweepCons/)
    IF (qRy /= 0) Stencil(qRy)%NrVars=(/1,SweepCons/)
    IF (qLz /= 0) Stencil(qLz)%NrVars=(/1,SweepCons/)
    IF (qRz /= 0) Stencil(qRz)%NrVars=(/1,SweepCons/)
    IF (fx /= 0) Stencil(fx)%NrVars=(/1,SweepCons/)
    IF (fy /= 0) Stencil(fy)%NrVars=(/1,SweepCons/)
    IF (fz /= 0) Stencil(fz)%NrVars=(/1,SweepCons/)
    IF (ctfx /= 0) Stencil(ctfx)%NrVars=(/1,2/)
    IF (ctfy /= 0) Stencil(ctfy)%NrVars=(/1,2/)
    IF (ctfz /= 0) Stencil(ctfz)%NrVars=(/1,2/)
    !Second round of fluxes for CTU correction step
    IF (q2Lx /= 0) Stencil(q2Lx)%NrVars=(/1,SweepCons/)
    IF (q2Rx /= 0) Stencil(q2Rx)%NrVars=(/1,SweepCons/)
    IF (q2Ly /= 0) Stencil(q2Ly)%NrVars=(/1,SweepCons/)
    IF (q2Ry /= 0) Stencil(q2Ry)%NrVars=(/1,SweepCons/)
    IF (q2Lz /= 0) Stencil(q2Lz)%NrVars=(/1,SweepCons/)
    IF (q2Rz /= 0) Stencil(q2Rz)%NrVars=(/1,SweepCons/)
    IF (f2x /= 0) Stencil(f2x)%NrVars=(/1,NrHydroVars/)
    IF (f2y /= 0) Stencil(f2y)%NrVars=(/1,NrHydroVars/)
    IF (f2z /= 0) Stencil(f2z)%NrVars=(/1,NrHydroVars/)
    IF (ctf2x /= 0) Stencil(ctf2x)%NrVars=(/1,2/)
    IF (ctf2y /= 0) Stencil(ctf2y)%NrVars=(/1,2/)
    IF (ctf2z /= 0) Stencil(ctf2z)%NrVars=(/1,2/)
    IF (eta2x /= 0) Stencil(eta2x)%NrVars=(/1,1/)
    IF (eta2y /= 0) Stencil(eta2y)%NrVars=(/1,1/)
    IF (eta2z /= 0) Stencil(eta2z)%NrVars=(/1,1/)
    IF (etax /= 0) Stencil(etax)%NrVars=(/1,1/)
    IF (etay /= 0) Stencil(etay)%NrVars=(/1,1/)
    IF (etaz /= 0) Stencil(etaz)%NrVars=(/1,1/)

    IF (adfx /= 0) Stencil(adfx)%NrVars=(/1,Nrtracervars/)
    IF (adfy /= 0) Stencil(adfy)%NrVars=(/1,Nrtracervars/)
    IF (adfz /= 0) Stencil(adfz)%NrVars=(/1,Nrtracervars/)

    !Reconstruction work space
    IF (limiter_ppm /= 0) Stencil(limiter_ppm)%NrVars=(/1,1/)
    IF (limiter_x /= 0) Stencil(limiter_x)%NrVars=(/1,1/)
    IF (limiter_y /= 0) Stencil(limiter_y)%NrVars=(/1,1/)
    IF (limiter_z /= 0) Stencil(limiter_z)%NrVars=(/1,1/)
    IF (pT /= 0) Stencil(pT)%NrVars=(/1,1/)
    IF (dqx /= 0) Stencil(dqx)%NrVars=(/1,NrWaves/)
    IF (dqy /= 0) Stencil(dqy)%NrVars=(/1,NrWaves/)
    IF (dqz /= 0) Stencil(dqz)%NrVars=(/1,NrWaves/)
    IF (qex /= 0) Stencil(qex)%NrVars=(/1,NrWaves/)
    IF (qey /= 0) Stencil(qey)%NrVars=(/1,NrWaves/)
    IF (qez /= 0) Stencil(qez)%NrVars=(/1,NrWaves/)

    IF (SpeedsX /= 0) Stencil(SpeedsX)%NrVars=(/ 1,NrWaves/)
    IF (SpeedsY /= 0) Stencil(SpeedsY)%NrVars=(/ 1,NrWaves/)
    IF (SpeedsZ /= 0) Stencil(SpeedsZ)%NrVars=(/ 1,NrWaves/)
    IF (leftX /= 0) Stencil(leftX)%NrVars=(/ NrWaves,NrWaves/)
    IF (leftY /= 0) Stencil(leftY)%NrVars=(/ NrWaves,NrWaves/)
    IF (leftZ /= 0) Stencil(leftZ)%NrVars=(/ NrWaves,NrWaves/)
    IF (rightX /= 0) Stencil(rightX)%NrVars=(/ NrWaves,NrWaves/)
    IF (rightY /= 0) Stencil(rightY)%NrVars=(/ NrWaves,NrWaves/)
    IF (rightZ /= 0) Stencil(rightZ)%NrVars=(/ NrWaves,NrWaves/)
    IF (nWaves /= 0) Stencil(nWaves)%NrVars=(/ 1,nDim/)

    !MHD CT Stuff
    IF (ex /= 0) Stencil(ex)%NrVars=(/1,1/)
    IF (ey /= 0) Stencil(ey)%NrVars=(/1,1/)
    IF (ez /= 0) Stencil(ez)%NrVars=(/1,1/)
    IF (ex_bar /= 0) Stencil(ex_bar)%NrVars=(/1,1/)
    IF (ey_bar /= 0) Stencil(ey_bar)%NrVars=(/1,1/)
    IF (ez_bar /= 0) Stencil(ez_bar)%NrVars=(/1,1/)

    !Second Round of MHD CT stuff
    !     Storing fluxes directly into Info%emf
    IF (e2x /= 0) Stencil(e2x)%NrVars=(/1,1/)
    IF (e2y /= 0) Stencil(e2y)%NrVars=(/1,1/)
    IF (e2z /= 0) Stencil(e2z)%NrVars=(/1,1/)

    IF (e2x_bar /= 0) Stencil(e2x_bar)%NrVars=(/1,1/)
    IF (e2y_bar /= 0) Stencil(e2y_bar)%NrVars=(/1,1/)
    IF (e2z_bar /= 0) Stencil(e2z_bar)%NrVars=(/1,1/)
    !extra MHD Stuff

    IF (w2 /= 0) Stencil(w2)%NrVars=(/1,SweepCons/)
    IF (A2x /= 0) Stencil(A2x)%NrVars=(/1,1/)
    IF (A2y /= 0) Stencil(A2y)%NrVars=(/1,1/)
    IF (A2z /= 0) Stencil(A2z)%NrVars=(/1,1/)

    !Stone and Gardiner Source Terms
    IF (Sx /= 0) Stencil(Sx)%NrVars=(/1,SweepCons/)
    IF (Sy /= 0) Stencil(Sy)%NrVars=(/1,SweepCons/)
    IF (Sz /= 0) Stencil(Sz)%NrVars=(/1,SweepCons/)

    IF (Sx /= 0) Stencil(Sx)%clear=.true.
    IF (Sy /= 0) Stencil(Sy)%clear=.true.
    IF (Sz /= 0) Stencil(Sz)%clear=.true.

    IF (cornerdiv /= 0) Stencil(cornerdiv)%NrVars=(/1,1/)
    IF (gradphix /= 0) Stencil(gradphix)%NrVars=(/1,1/)
    IF (gradphiy /= 0) Stencil(gradphiy)%NrVars=(/1,1/)
    IF (gradphiz /= 0) Stencil(gradphiz)%NrVars=(/1,1/)



  END SUBROUTINE SetStencilNrVars

  !> Sets description strings for stencil pieces
  SUBROUTINE set_descriptions()
    IF (w /= 0) Stencil(w)%description="w"
    IF (q /= 0) Stencil(q)%description="q"
    IF (aux /= 0) Stencil(aux)%description="aux"
    IF (recon /= 0) Stencil(recon)%description="recon"
    IF (qLx /= 0) Stencil(qLx)%description="qLx"
    IF (qRx /= 0) Stencil(qRx)%description="qRx"
    IF (qLy /= 0) Stencil(qLy)%description="qLy"
    IF (qRy /= 0) Stencil(qRy)%description="qRy"
    IF (qLz /= 0) Stencil(qLz)%description="qLz"
    IF (qRz /= 0) Stencil(qRz)%description="qRz"
    IF (fx /= 0) Stencil(fx)%description="fx"
    IF (fy /= 0) Stencil(fy)%description="fy"
    IF (fz /= 0) Stencil(fz)%description="fz"
    IF (w2 /= 0) Stencil(w2)%description="w2"
    IF (q2Lx /= 0) Stencil(q2Lx)%description="q2Lx"
    IF (q2Rx /= 0) Stencil(q2Rx)%description="q2Rx"
    IF (q2Ly /= 0) Stencil(q2Ly)%description="q2Ly"
    IF (q2Ry /= 0) Stencil(q2Ry)%description="q2Ry"
    IF (q2Lz /= 0) Stencil(q2Lz)%description="q2Lz"
    IF (q2Rz /= 0) Stencil(q2Rz)%description="q2Rz"
    IF (f2x /= 0) Stencil(f2x)%description="f2x"
    IF (f2y /= 0) Stencil(f2y)%description="f2y"
    IF (f2z /= 0) Stencil(f2z)%description="f2z"
    IF (limiter_x /= 0) Stencil(limiter_x)%description="limiter_x"
    IF (limiter_y /= 0) Stencil(limiter_y)%description="limiter_y"
    IF (limiter_z /= 0) Stencil(limiter_z)%description="limiter_z"
    IF (limiter_ppm /= 0) Stencil(limiter_ppm)%description="limiter_ppm"
    IF (pT /= 0) Stencil(pT)%description="pT"
    IF (qex /= 0) Stencil(qex)%description="qex"
    IF (qey /= 0) Stencil(qey)%description="qey"
    IF (qez /= 0) Stencil(qez)%description="qez"
    IF (dqx /= 0) Stencil(dqx)%description="dqx"
    IF (dqy /= 0) Stencil(dqy)%description="dqy"
    IF (dqz /= 0) Stencil(dqz)%description="dqz"
    IF (ex /= 0) Stencil(ex)%description="ex"
    IF (ey /= 0) Stencil(ey)%description="ey"
    IF (ez /= 0) Stencil(ez)%description="ez"
    IF (ex_bar /= 0) Stencil(ex_bar)%description="ex_bar"
    IF (ey_bar /= 0) Stencil(ey_bar)%description="ey_bar"
    IF (ez_bar /= 0) Stencil(ez_bar)%description="ez_bar"
    IF (e2x /= 0) Stencil(e2x)%description="e2x"
    IF (e2y /= 0) Stencil(e2y)%description="e2y"
    IF (e2z /= 0) Stencil(e2z)%description="e2z"
    IF (e2x_bar /= 0) Stencil(e2x_bar)%description="e2x_bar"
    IF (e2y_bar /= 0) Stencil(e2y_bar)%description="e2y_bar"
    IF (e2z_bar /= 0) Stencil(e2z_bar)%description="e2z_bar"
    IF (A2x /= 0) Stencil(A2x)%description="A2x"
    IF (A2y /= 0) Stencil(A2y)%description="A2y"
    IF (A2z /= 0) Stencil(A2z)%description="A2z"
    IF (Sx /= 0) Stencil(Sx)%description="Sx"
    IF (Sy /= 0) Stencil(Sy)%description="Sy"
    IF (Sz /= 0) Stencil(Sz)%description="Sz"
    IF (SpeedsX /= 0) Stencil(SpeedsX)%description="SpeedsX"
    IF (SpeedsY /= 0) Stencil(SpeedsY)%description="SpeedsY"
    IF (SpeedsZ /= 0) Stencil(SpeedsZ)%description="SpeedsZ"
    IF (leftX /= 0) Stencil(leftX)%description="leftX"
    IF (RightX /= 0) Stencil(RightX)%description="RightX"
    IF (leftY /= 0) Stencil(leftY)%description="leftY"
    IF (RightY /= 0) Stencil(RightY)%description="RightY"
    IF (leftZ /= 0) Stencil(leftZ)%description="leftZ"
    IF (RightZ /= 0) Stencil(RightZ)%description="RightZ"
    IF (nWaves /= 0) Stencil(nWaves)%description="nWaves"
    IF (req_eigens /= 0) Stencil(req_eigens)%description="req_eigens"
    IF (adfx /= 0) Stencil(adfx)%description="adfx"
    IF (adfy /= 0) Stencil(adfy)%description="adfy"
    IF (adfz /= 0) Stencil(adfz)%description="adfz"
    IF (ctfx /= 0) Stencil(ctfx)%description="ctfx"
    IF (ctfy /= 0) Stencil(ctfy)%description="ctfy"
    IF (ctfz /= 0) Stencil(ctfz)%description="ctfz"
    IF (etax /= 0) Stencil(etax)%description="etax"
    IF (etay /= 0) Stencil(etay)%description="etay"
    IF (etaz /= 0) Stencil(etaz)%description="etaz"
    IF (eta2x /= 0) Stencil(eta2x)%description="eta2x"
    IF (eta2y /= 0) Stencil(eta2y)%description="eta2y"
    IF (eta2z /= 0) Stencil(eta2z)%description="eta2z"
    IF (A3x /= 0) Stencil(A3x)%description="A3x"
    IF (A3y /= 0) Stencil(A3y)%description="A3y"
    IF (A3z /= 0) Stencil(A3z)%description="A3z"
    IF (w3 /= 0) Stencil(w3)%description="w3"
    IF (ctf2x /= 0) Stencil(ctf2x)%description="ctf2x"
    IF (ctf2y /= 0) Stencil(ctf2y)%description="ctf2y"
    IF (ctf2z /= 0) Stencil(ctf2z)%description="ctf2z"
    IF (beforesweepstep /= 0) Stencil(beforesweepstep)%description="beforestep"
    IF (aftersweepstep /= 0) Stencil(aftersweepstep)%description="afterstep"
    IF (source /= 0) Stencil(source)%description="source"
    IF (source2 /= 0) Stencil(source2)%description="source2"
    IF (cornerdiv /= 0) Stencil(cornerdiv)%description="cornerdiv"
    IF (gradphix /= 0) Stencil(gradphix)%description="gradphix"
    IF (gradphiy /= 0) Stencil(gradphiy)%description="gradphiy"
    IF (gradphiz /= 0) Stencil(gradphiz)%description="gradphiz"
  END SUBROUTINE set_descriptions



  SUBROUTINE sweep_()
    INTEGER :: index,i,j,k
    CALL BeforeSweepStep_()
    CALL Init_prims_()
    CALL Reconstruct_()
    IF (viscCD == ROE_VISCOSITY .OR. viscCD == H_VISCOSITY) CALL HVisc_()
    IF (nDim >= 2 .AND. (lCTU .OR. lMHD)) THEN
       CALL calc_fluxes_()
       IF (lMHD) THEN
          CALL calc_emf_()
          CALL updateB_()
          CALL update_fluxes_()
       END IF
       IF (lMHD .OR. (NrTracerVars > 0 .AND. iTracer==LAGRANGIAN)) CALL updatew2_()
       CALL CTU_()
       CALL calc_final_fluxes_()
       IF (NrTracerVars > 0) CALL calc_tracer_fluxes_()
       CALL update_final_fluxes_()
       CALL update_final_()
       IF (lMHD) THEN
          CALL calc_final_emf_()
          CALL updateB_final_()
       END IF
    ELSE
       CALL calc_fluxes_noctu()
       !      CALL updatew2_()
       CALL update_final_fluxes_()
       CALL update_final_()
    END IF
    CALL store_fixup_fluxes_()
    CALL AfterSweepStep_()
  CONTAINS

    SUBROUTINE BeforeSweepStep_
      CALL set_dependency(beforesweepstep, q, (/0,0,0,0,0,0/))
    END SUBROUTINE BeforeSweepStep_

    SUBROUTINE AfterSweepStep_()
      CALL set_dependency(aftersweepstep, w3, (/0,0,0,0,0,0/))
    END SUBROUTINE AfterSweepStep_

    SUBROUTINE Init_prims_()
      !Calculating new primitive values needed for reconstruction
      CALL set_dependency(w, beforesweepstep, (/0,0,0,0,0,0/))
    END SUBROUTINE Init_prims_

    SUBROUTINE Reconstruct_
      IF (lGudonov) THEN
         CALL set_dependency(qRx, w, center_r)
         CALL set_dependency(qLx, w, center_l)
         IF (lMHD) THEN
            CALL set_dependency(qRx, aux, same)
            CALL set_dependency(qLx, aux, same)
         END IF
         IF (nDim >= 2) THEN
            CALL set_dependency(qRy, w, center_u)
            CALL set_dependency(qLy, w, center_d)
            IF (lMHD) THEN
               CALL set_dependency(qRy, aux, same)
               CALL set_dependency(qLy, aux, same)
            END IF
            IF (nDim >= 3) THEN
               CALL set_dependency(qRz, w, center_b)
               CALL set_dependency(qLz, w, center_f)
               IF (lMHD) THEN
                  CALL set_dependency(qRz, aux, same)
                  CALL set_dependency(qLz, aux, same)
               END IF
            END IF
         END IF
      ELSE
         IF (lLimiter .OR. lApplyLOF) THEN    
            CALL calc_limiters_()
         END IF
         IF (.NOT. request_eigens_()) THEN
         END IF
         CALL set_dependency(dqx, w, (/-1,1,0,0,0,0/))
         IF (lChar_Limiters) CALL set_dependency(dqx, req_eigens, same)
         IF (lLimiter) CALL set_dependency(dqx, limiter_ppm, same)
         IF (nDim >= 2) THEN
            CALL set_dependency(dqy, w, (/0,0,-1,1,0,0/))
            IF (lChar_Limiters) CALL set_dependency(dqy, req_eigens, same)
            IF (lLimiter) CALL set_dependency(dqy, limiter_ppm, same)
            IF (nDim >= 3) THEN
               CALL set_dependency(dqz, w, (/0,0,0,0,-1,1/))
               IF (lChar_Limiters) CALL set_dependency(dqz, req_eigens, same)
               IF (lLimiter) CALL set_dependency(dqz, limiter_ppm, same)
            END IF
         END IF
         IF (InterpOrder == 3) THEN
            IF (lUsePPML) THEN
               CALL set_dependency(qex, w, (/-2,1,0,0,0,0/))
            ELSE
               CALL set_dependency(qex, w, (/-1,0,0,0,0,0/))
            END IF
            CALL set_dependency(qex, dqx, (/-1,0,0,0,0,0/))
            IF (nDim >= 2) THEN
               CALL set_dependency(qey, w, (/0,0,-1,0,0,0/))
               CALL set_dependency(qey, dqy, (/0,0,-1,0,0,0/))
               IF (nDim >= 3) THEN
                  CALL set_dependency(qez, w, (/0,0,0,0,-1,0/))
                  CALL set_dependency(qez, dqz, (/0,0,0,0,-1,0/))
               END IF
            END IF
         END IF
         CALL set_codependency(qRx, qLx, (/1,0,0/))
         IF (nDim >= 2) THEN
            CALL set_codependency(qRy, qLy, (/0,1,0/))
            IF (nDim >= 3) THEN
               CALL set_codependency(qRz, qLz, (/0,0,1/))
            END IF
         END IF
         CALL set_dependency(qRx, w, center_r)
         IF (InterpOrder == 3) CALL set_dependency(qRx, qex, (/0,1,0,0,0,0/))
         CALL set_dependency(qRx, dqx, center_r)
!        IF (lLimiter) CALL set_dependency(qRx, limiter_ppm, center_r)
         CALL set_dependency(qRx, req_eigens, center_r)
         CALL set_dependency(qLx, w, center_l)
         CALL set_dependency(qLx, dqx, center_l)
         IF (InterpOrder == 3) CALL set_dependency(qLx, qex, (/-1,0,0,0,0,0/))
!        IF (lLimiter) CALL set_dependency(qLx, limiter_ppm, center_l)
         CALL set_dependency(qLx, req_eigens, center_l)
         IF (lUsePPML) THEN
            CALL set_dependency(qRx, w, (/-2,2,0,0,0,0/))
            CALL set_dependency(qLx, w, (/-2,2,0,0,0,0/))
         END IF
         IF (nDim >= 2) THEN
            CALL set_dependency(qRy, w, center_u)
            CALL set_dependency(qRy, dqy, center_u)
            IF (InterpOrder == 3) CALL set_dependency(qRy, qey, (/0,0,0,1,0,0/))
            IF (lLimiter) CALL set_dependency(qRy, limiter_ppm, center_u)
            CALL set_dependency(qRy, req_eigens, center_u)
            CALL set_dependency(qLy, w, center_d)
            CALL set_dependency(qLy, dqy, center_d)
            IF (InterpOrder == 3) CALL set_dependency(qLy, qey, (/0,0,-1,0,0,0/))
            IF (lLimiter) CALL set_dependency(qLy, limiter_ppm, center_d)
            CALL set_dependency(qLy, req_eigens, center_d)
            IF (nDim >= 3) THEN
               CALL set_dependency(qRz, w, center_f)
               CALL set_dependency(qRz, dqz, center_f)
               IF (InterpOrder == 3) CALL set_dependency(qRz, qez, (/0,0,0,0,0,1/))
               IF (lLimiter) CALL set_dependency(qRz, limiter_ppm, center_f)
               CALL set_dependency(qRz, req_eigens, center_f)
               CALL set_dependency(qLz, w, center_b)
               CALL set_dependency(qLz, dqz, center_b)
               IF (InterpOrder == 3) CALL set_dependency(qLz, qez, (/0,0,0,0,-1,0/))
               IF (lLimiter) CALL set_dependency(qLz, limiter_ppm, center_b)
               CALL set_dependency(qLz, req_eigens, center_b)
            END IF
         END IF
         IF (lMHD) THEN
            IF (nDim >= 2) THEN
               CALL set_dependency(qLx, aux, same)
               CALL set_dependency(qRx, aux, same)
               CALL set_dependency(qLy, aux, same)
               CALL set_dependency(qRy, aux, same)
               IF (nDim >= 3) THEN
                  CALL set_dependency(qLz, aux, same)
                  CALL set_dependency(qRz, aux, same)
               END IF
            END IF
         END IF
         IF (lMHD) CALL MHD_Source_Terms_()
      END IF
      IF (lSelfGravity) THEN
         CALL set_dependency(qLx, gradphix, same)
         CALL set_dependency(qRx, gradphix, same)
         IF (nDim >= 2) THEN
            CALL set_dependency(qLy, gradphiy, same)
            CALL set_dependency(qRy, gradphiy, same)
            IF (nDim >= 3) THEN
               CALL set_dependency(qLz, gradphiz, same)
               CALL set_dependency(qRz, gradphiz, same)
            END IF
         END IF
      END IF
    END SUBROUTINE Reconstruct_

    SUBROUTINE calc_limiters_()
      CALL set_dependency(pT, w, same)
      CALL set_dependency(limiter_x, pT, (/-2,2,0,0,0,0/))
      CALL set_dependency(limiter_x, w, (/-1,1,0,0,0,0/))
      IF (lLimiter) THEN
         IF (nDim == 1) CALL set_dependency(limiter_ppm, limiter_x, (/-1,1,0,0,0,0/))
         IF (nDim == 2) CALL set_dependency(limiter_ppm, limiter_x, (/-1,1,-1,1,0,0/))
         IF (nDim == 3) CALL set_dependency(limiter_ppm, limiter_x, (/-1,1,-1,1,-1,1/))
      END IF
      IF (nDim >= 2) THEN
         CALL set_dependency(limiter_y, pT, (/0,0,-2,2,0,0/))
         CALL set_dependency(limiter_y, w, (/0,0,-1,1,0,0/))
         IF (lLimiter) THEN
            IF (nDim == 2) CALL set_dependency(limiter_ppm, limiter_y, (/-1,1,-1,1,0,0/))
            IF (nDim == 3) CALL set_dependency(limiter_ppm, limiter_y, (/-1,1,-1,1,-1,1/))
         END IF
         IF (nDim >= 3) THEN
            CALL set_dependency(limiter_z, pT, (/0,0,0,0,-2,2/))
            CALL set_dependency(limiter_z, w, (/0,0,0,0,-1,1/))
            IF (lLimiter) CALL set_dependency(limiter_ppm, limiter_z, (/-1,1,-1,1,-1,1/))
         END IF
      END IF
    END SUBROUTINE calc_limiters_


    FUNCTION request_eigens_()
      LOGICAL :: request_eigens_
      CALL set_dependency(req_eigens, w, same)
      CALL set_group(req_eigens, nWaves)
      CALL set_group(req_eigens, SpeedsX)
      CALL set_group(req_eigens, LeftX)
      CALL set_group(req_eigens, RightX)
      IF (nDim >= 2) THEN
         CALL set_group(req_eigens, SpeedsY)
         CALL set_group(req_eigens, LeftY)
         CALL set_group(req_eigens, RightY)
         IF (nDim >= 3) THEN
            CALL set_group(req_eigens, SpeedsZ)
            CALL set_group(req_eigens, LeftZ)
            CALL set_group(req_eigens, RightZ)
         END IF
      END IF
      request_eigens_=.true.
    END FUNCTION request_eigens_

    SUBROUTINE MHD_Source_Terms_()
      INTEGER :: i,i2,j,k,m,index
      IF (nDim >= 2) THEN
         CALL set_dependency(qLx, w, center_l)
         CALL set_dependency(qLx, aux, (/-1,0,0,0,0,0/))
         CALL set_dependency(qLx, aux, (/-1,-1,0,1,0,0/))
         CALL set_dependency(qRx, w, center_r)
         CALL set_dependency(qRx, aux, (/0,1,0,0,0,0/))
         CALL set_dependency(qRx, aux, (/0,0,0,1,0,0/))

         CALL set_dependency(qLy, w, center_d)
         CALL set_dependency(qLy, aux, (/0,0,-1,0,0,0/))
         CALL set_dependency(qLy, aux, (/0,1,-1,-1,0,0/))
         CALL set_dependency(qRy, w, center_u)
         CALL set_dependency(qRy, aux, (/0,1,0,0,0,0/))
         CALL set_dependency(qRy, aux, (/0,0,0,1,0,0/))

         IF (nDim >= 3) THEN
            CALL set_dependency(qLx, aux, (/-1,-1,0,0,0,1/))
            CALL set_dependency(qLy, aux, (/0,0,-1,-1,0,1/))

            CALL set_dependency(qRx, aux, (/0,0,0,0,0,1/))
            CALL set_dependency(qRy, aux, (/0,0,0,0,0,1/))

            CALL set_dependency(qLz, w, center_b)
            CALL set_dependency(qLz, aux, (/0,0,0,0,-1,0/))
            CALL set_dependency(qLz, aux, (/0,1,0,0,-1,-1/))
            CALL set_dependency(qLz, aux, (/0,0,0,1,-1,-1/))

            CALL set_dependency(qRz, w, center_f)
            CALL set_dependency(qRz, aux, (/0,0,0,0,0,1/))
            CALL set_dependency(qRz, aux, (/0,1,0,0,0,0/))
            CALL set_dependency(qRz, aux, (/0,0,0,1,0,0/))
         END IF
      END IF
    END SUBROUTINE MHD_Source_Terms_

    SUBROUTINE calc_fluxes_()
      CALL set_dependency(fx, qLx, same)
      CALL set_dependency(fx, qRx, same)
      IF (nDim >= 2) THEN
         CALL set_dependency(fy, qLy, same)
         CALL set_dependency(fy, qRy, same)
         IF (nDim >= 3) THEN
            CALL set_dependency(fz, qLz, same)
            CALL set_dependency(fz, qRz, same)
         END IF
      END IF
    END SUBROUTINE calc_fluxes_


    SUBROUTINE calc_fluxes_noctu()
      CALL set_dependency(f2x, qLx, same)
      CALL set_dependency(f2x, qRx, same)
      IF (nDim >= 2) THEN
         CALL set_dependency(f2y, qLy, same)
         CALL set_dependency(f2y, qRy, same)
         IF (nDim >= 3) THEN
            CALL set_dependency(f2z, qLz, same)
            CALL set_dependency(f2z, qRz, same)
         END IF
      END IF
    END SUBROUTINE calc_fluxes_noctu

    SUBROUTINE calc_emf_()
      CALL set_dependency(ez_bar, w, same) 
      IF (nDim >= 3) THEN
         CALL set_dependency(ex_bar, w, same) 
         CALL set_dependency(ey_bar, w, same) 
      END IF

      CALL set_dependency(ez, ez_bar, (/-1,0,-1,0,0,0/))
      CALL set_dependency(ez, fy, (/-1,0,0,0,0,0/))
      CALL set_dependency(ez, fx, (/0,0,-1,0,0,0/))

      IF (nDim >= 3) THEN
         CALL set_dependency(ex, ex_bar, (/0,0,-1,0,-1,0/))
         CALL set_dependency(ex, fz, (/0,0,-1,0,0,0/))
         CALL set_dependency(ex, fy, (/0,0,0,0,-1,0/))
         CALL set_dependency(ey, ey_bar, (/-1,0,0,0,-1,0/))
         CALL set_dependency(ey, fx, (/0,0,0,0,-1,0/))
         CALL set_dependency(ey, fz, (/-1,0,0,0,0,0/))
      END IF
    END SUBROUTINE calc_emf_


    SUBROUTINE updateB_()
      CALL set_dependency(A2x, aux, same)
      CALL set_dependency(A2x, ez, (/0,0,0,1,0,0/))
      CALL set_dependency(A2y, aux, same)
      CALL set_dependency(A2y, ez, (/0,1,0,0,0,0/))

      IF (nDim >= 3) THEN
         CALL set_dependency(A2x, ey, (/0,0,0,0,0,1/))
         CALL set_dependency(A2y, ex, (/0,0,0,0,0,1/))

         CALL set_dependency(A2z, aux, same)
         CALL set_dependency(A2z, ex, (/0,0,0,1,0,0/))
         CALL set_dependency(A2z, ey, (/0,1,0,0,0,0/))
      END IF
    END SUBROUTINE updateB_

    SUBROUTINE updatew2_()
      CALL set_dependency(w2, beforesweepstep, same)
      CALL set_dependency(w2, fx, (/0,1,0,0,0,0/))
      CALL set_dependency(w2, fy, (/0,0,0,1,0,0/))
      IF (nDim >= 3) CALL set_dependency(w2, fz, (/0,0,0,0,0,1/))
      IF (lMHD) THEN
         CALL set_dependency(w2, A2x, (/0,1,0,0,0,0/))
         CALL set_dependency(w2, A2y, (/0,0,0,1,0,0/))
         IF (nDim >= 3) THEN
            CALL set_dependency(w2, ctfx, (/0,1,0,0,0,0/))
            CALL set_dependency(w2, ctfy, (/0,0,0,1,0,0/))
            CALL set_dependency(w2, A2z, (/0,0,0,0,0,1/))
            CALL set_dependency(w2, ctfz, (/0,0,0,0,0,1/))
         END IF
      END IF
      IF (lSelfGravity) THEN
         CALL set_dependency(w2, beforesweepstep, (/-1,1,0,0,0,0/))
         IF (nDim >= 2) THEN
            CALL set_dependency(w2, beforesweepstep, (/0,0,-1,1,0,0/))
            IF (nDim >= 3) THEN
               CALL set_dependency(w2, beforesweepstep, (/0,0,0,0,-1,1/))
            END IF
         END IF
      END IF
    END SUBROUTINE updatew2_


    SUBROUTINE update_fluxes_()
      IF (nDim == 3) THEN
         CALL set_dependency(ctfx, ez, (/0,0,0,1,0,0/))
         CALL set_dependency(ctfx, ey, (/0,0,0,0,0,1/))
         CALL set_dependency(ctfy, ez, (/0,1,0,0,0,0/))
         CALL set_dependency(ctfy, ex, (/0,0,0,0,0,1/))
         CALL set_dependency(ctfz, ex, (/0,0,0,1,0,0/))
         CALL set_dependency(ctfz, ey, (/0,1,0,0,0,0/))
      END IF
    END SUBROUTINE update_fluxes_


    SUBROUTINE CTU_()
      IF (lMHD) THEN
         CALL set_dependency(Sx, w, same)
         CALL set_dependency(Sy, w, same)

         IF (nDim == 2) THEN
            CALL set_dependency(Sx, aux, (/0,1,0,1,0,0/))
            CALL set_dependency(Sy, aux, (/0,1,0,1,0,0/))
         ELSE IF (nDim >= 3) THEN
            CALL set_dependency(Sz, w, same)
            CALL set_dependency(Sx, aux, (/0,1,0,1,0,1/))
            CALL set_dependency(Sy, aux, (/0,1,0,1,0,1/))
            CALL set_dependency(Sz, aux, (/0,1,0,1,0,1/))
         END IF
      END IF

      CALL set_dependency(q2Lx, qLx, same)
      CALL set_dependency(q2Lx, beforesweepstep, (/-1,-1,0,0,0,0/))
      CALL set_dependency(q2Lx, fy, (/-1,-1,0,1,0,0/))
      CALL set_dependency(q2Rx, qRx, same)
      CALL set_dependency(q2Rx, beforesweepstep, (/0,0,0,0,0,0/))
      CALL set_dependency(q2Rx, fy, (/0,0,0,1,0,0/))

      CALL set_dependency(q2Ly, qLy, same)
      CALL set_dependency(q2Ly, beforesweepstep, (/0,0,-1,-1,0,0/))
      CALL set_dependency(q2Ly, fx, (/0, 1, -1,-1,0,0/))
      CALL set_dependency(q2Ry, qRy, same)
      CALL set_dependency(q2Ry, beforesweepstep, (/0,0,0,0,0,0/))
      CALL set_dependency(q2Ry, fx, (/0,1,0,0,0,0/))

      IF (lMHD) THEN
         CALL set_dependency(q2Lx, Sx, center_l)
         CALL set_dependency(q2Rx, Sx, center_r)
         CALL set_dependency(q2Lx, A2x, same)
         CALL set_dependency(q2Rx, A2x, same)
         CALL set_dependency(q2Ly, Sy, center_d)
         CALL set_dependency(q2Ry, Sy, center_u)
         CALL set_dependency(q2Ly, A2y, same)
         CALL set_dependency(q2Ry, A2y, same)
      END IF
      IF (nDim >= 3) THEN
         CALL set_dependency(q2Lz, qLz, same)
         CALL set_dependency(q2Lx, fz, (/-1,-1,0,0,0,1/))
         CALL set_dependency(q2Rx, fz, (/0,0,0,0,0,1/))
         CALL set_dependency(q2Ly, fz, (/0,0,-1,-1,0,1/))
         CALL set_dependency(q2Ry, fz, (/0,0,0,0,0,1/))
         CALL set_dependency(q2Rz, qRz, same)
         CALL set_dependency(q2Lz, fx, (/0,1,0,0,-1,-1/))
         CALL set_dependency(q2Lz, fy, (/0,0,0,1,-1,-1/))
         CALL set_dependency(q2Rz, fx, (/0,1,0,0,0,0/))
         CALL set_dependency(q2Rz, fy, (/0,0,0,1,0,0/))

         IF (lMHD) THEN
            CALL set_dependency(q2Lx, ctfy, (/-1,-1,0,1,0,0/))
            CALL set_dependency(q2Rx, ctfy, (/0,0,0,1,0,0/))
            CALL set_dependency(q2Ly, ctfx, (/0, 1, -1,-1,0,0/))
            CALL set_dependency(q2Ry, ctfx, (/0,1,0,0,0,0/))
            CALL set_dependency(q2Lz, ctfx, (/0,1,0,0,-1,-1/))
            CALL set_dependency(q2Lz, ctfy, (/0,0,0,1,-1,-1/))
            CALL set_dependency(q2Rz, ctfx, (/0,1,0,0,0,0/))
            CALL set_dependency(q2Rz, ctfy, (/0,0,0,1,0,0/))
            CALL set_dependency(q2Lx, ctfz, (/-1,-1,0,0,0,1/))
            CALL set_dependency(q2Rx, ctfz, (/0,0,0,0,0,1/))
            CALL set_dependency(q2Ly, ctfz, (/0,0,-1,-1,0,1/))
            CALL set_dependency(q2Ry, ctfz, (/0,0,0,0,0,1/))
            CALL set_dependency(q2Lz, Sz, center_b)
            CALL set_dependency(q2Rz, Sz, center_f)
            CALL set_dependency(q2Lz, A2z, same)
            CALL set_dependency(q2Rz, A2z, same)
         END IF
      END IF
      IF (lSelfGravity) THEN
         CALL set_dependency(q2Lx, gradphiy, (/-1,-1,0,1,0,0/))
         CALL set_dependency(q2Rx, gradphiy, (/0,0,0,1,0,0/))
         CALL set_dependency(q2Ly, gradphix, (/0,1,-1,-1,0,0/))
         CALL set_dependency(q2Ry, gradphix, (/0,1,0,0,0,0/))
         IF (nDim >= 3) THEN
            CALL set_dependency(q2Lx, gradphiz, (/-1,-1,0,0,0,1/))
            CALL set_dependency(q2Rx, gradphiz, (/0,0,0,0,0,1/))
            CALL set_dependency(q2Ly, gradphiz, (/0,0,-1,-1,0,1/))
            CALL set_dependency(q2Ry, gradphiz, (/0,0,0,0,0,1/))
            CALL set_dependency(q2Lz, gradphix, (/0,1,0,0,-1,-1/))
            CALL set_dependency(q2Lz, gradphiy, (/0,0,0,1,-1,-1/))
            CALL set_dependency(q2Rz, gradphix, (/0,1,0,0,0,0/))
            CALL set_dependency(q2Rz, gradphiy, (/0,0,0,1,0,0/))
         END IF
      END IF

    END SUBROUTINE CTU_

    SUBROUTINE calc_tracer_fluxes_()
      CALL set_dependency(adfx, beforesweepstep, (/-1,1,0,0,0,0/))
      CALL set_dependency(f2x, w2, (/-1,0,0,0,0,0/))
      CALL set_dependency(f2x, adfx, (/-1,0,0,0,0,0/))
      IF (nDim >= 2) THEN
         CALL set_dependency(adfy, beforesweepstep, (/0,0,-1,1,0,0/))
         CALL set_dependency(f2y, w2, (/0,0,-1,0,0,0/))
         CALL set_dependency(f2y, adfy, (/0,0,-1,0,0,0/))
         IF (nDim >= 3) THEN
            CALL set_dependency(adfz, beforesweepstep, (/0,0,0,0,-1,1/))
            CALL set_dependency(f2z, w2, (/0,0,0,0,-1,0/))
            CALL set_dependency(f2z, adfz, (/0,0,0,0,-1,0/))
         END IF
      END IF
    END SUBROUTINE calc_tracer_fluxes_

    SUBROUTINE HVisc_()

      CALL set_dependency(etax, req_eigens, (/-1,0,0,0,0,0/))
      CALL set_dependency(eta2x, etax, same)

      IF (nDim >= 2) THEN
         CALL set_dependency(etay, req_eigens, (/0,0,-1,0,0,0/))
         CALL set_dependency(eta2y, etay, same)
         IF (nDim >= 3) THEN
            CALL set_dependency(etaz, req_eigens, (/0,0,0,0,-1,0/))  
            CALL set_dependency(eta2z, etaz, same)
         END IF
         IF (ViscCD >= 2) THEN
            CALL set_dependency(eta2x, etay, (/-1,0,0,1,0,0/))
            CALL set_dependency(eta2y, etax, (/0,1,-1,0,0,0/))
            IF (nDim >= 3) THEN
               CALL set_dependency(eta2x, etaz, (/-1,0,0,0,0,1/))
               CALL set_dependency(eta2y, etaz, (/0,0,-1,0,0,1/))
               CALL set_dependency(eta2z, etax, (/0,1,0,0,-1,0/))
               CALL set_dependency(eta2z, etay, (/0,0,0,1,-1,0/))
            END IF
         END IF
      END IF
    END SUBROUTINE HVisc_

    SUBROUTINE calc_final_fluxes_()
      CALL set_dependency(f2x, q2Lx, same)
      CALL set_dependency(f2x, q2Rx, same)
      IF (ViscCD > 0) CALL set_dependency(f2x, eta2x, same)
      IF (nDim >= 2) THEN
         CALL set_dependency(f2y, q2Ly, same)
         CALL set_dependency(f2y, q2Ry, same)
         IF (ViscCD > 0) CALL set_dependency(f2y, eta2y, same)
         IF (nDim >= 3) THEN
            CALL set_dependency(f2z, q2Lz, same)
            CALL set_dependency(f2z, q2Rz, same)
            IF (ViscCD > 0) CALL set_dependency(f2z, eta2z, same)
         END IF
      END IF
    END SUBROUTINE calc_final_fluxes_

    SUBROUTINE calc_final_emf_()

      CALL set_dependency(e2z_bar, w2, same)
      CALL set_dependency(e2z, e2z_bar, (/-1,0,-1,0,0,0/))
      CALL set_dependency(e2z, f2x, (/0,0,-1,0,0,0/))
      CALL set_dependency(e2z, f2y, (/-1,0,0,0,0,0/))

      IF (nDim >= 3) THEN
         CALL set_dependency(e2x_bar, w2, same)
         CALL set_dependency(e2y_bar, w2, same)
         CALL set_dependency(e2x, e2x_bar, (/0,0,-1,0,-1,0/))
         CALL set_dependency(e2x, f2y, (/0,0,0,0,-1,0/))
         CALL set_dependency(e2x, f2z, (/0,0,-1,0,0,0/))
         CALL set_dependency(e2y, e2y_bar, (/-1,0,0,0,-1,0/))
         CALL set_dependency(e2y, f2z, (/-1,0,0,0,0,0/))
         CALL set_dependency(e2y, f2x, (/0,0,0,0,-1,0/))
      END IF
    END SUBROUTINE calc_final_emf_

    SUBROUTINE store_fixup_fluxes_()
    END SUBROUTINE store_fixup_fluxes_



    SUBROUTINE update_final_fluxes_()

      IF (lApplyDiffusion) THEN
         IF (nDim == 1) CALL set_dependency(cornerdiv, w, (/-1,0,0,0,0,0/))
         IF (nDim == 2) CALL set_dependency(cornerdiv, w, (/-1,0,-1,0,0,0/))
         IF (nDim == 3) CALL set_dependency(cornerdiv, w, (/-1,0,-1,0,-1,0/))

         CALL set_dependency(f2x, beforesweepstep, (/-1,0,0,0,0,0/))
         IF (nDim == 1) CALL set_dependency(f2x, cornerdiv, (/0,0,0,0,0,0/))
         IF (nDim == 2) CALL set_dependency(f2x, cornerdiv, (/0,0,0,1,0,0/))
         IF (nDim == 3) CALL set_dependency(f2x, cornerdiv, (/0,0,0,1,0,1/))

         IF (nDim >= 2) THEN
            CALL set_dependency(f2y, beforesweepstep, (/0,0,-1,0,0,0/))
            IF (nDim == 2) CALL set_dependency(f2y, cornerdiv, (/0,1,0,0,0,0/))
            IF (nDim == 3) CALL set_dependency(f2y, cornerdiv, (/0,1,0,0,0,1/))
            IF (nDim == 3) THEN
               CALL set_dependency(f2z, beforesweepstep, (/0,0,0,0,-1,0/))
               CALL set_dependency(f2z, cornerdiv, (/0,1,0,1,0,0/))
            END IF
         END IF
      END IF

      IF (lApplyLOF) THEN
         CALL set_dependency(f2x, beforesweepstep, (/-2,1,0,0,0,0/))
         CALL set_dependency(f2y, beforesweepstep, (/0,0,-2,1,0,0/))
         CALL set_dependency(f2x, limiter_y, (/-1,0,0,0,0,0/))
         CALL set_dependency(f2y, limiter_x, (/0,0,-1,0,0,0/))
         IF (nDim == 3)  THEN
            CALL set_dependency(f2z, beforesweepstep, (/0,0,0,0,-2,1/))
            CALL set_dependency(f2x, limiter_z, (/-1,0,0,0,0,0/))
            CALL set_dependency(f2y, limiter_z, (/0,0,-1,0,0,0/))
            CALL set_dependency(f2z, limiter_x, (/0,0,0,0,-1,0/))
            CALL set_dependency(f2z, limiter_y, (/0,0,0,0,-1,0/))
         END IF
      END IF

      IF (lSourceTerms) THEN
         IF (lSelfGravity) THEN
            CALL set_dependency(gradphix, beforesweepstep, (/-1,0,0,0,0,0/))
            CALL set_dependency(f2x, gradphix, (/0,0,0,0,0,0/))
            IF (nDim >= 2) THEN
               CALL set_dependency(gradphiy, beforesweepstep, (/0,0,-1,0,0,0/))
               CALL set_dependency(f2x, gradphiy, (/-1,0,0,1,0,0/))
               CALL set_dependency(f2y, gradphix, (/0,1,-1,0,0,0/))
               CALL set_dependency(f2y, gradphiy, (/0,0,0,0,0,0/))
               IF (nDim == 3) THEN
                  CALL set_dependency(gradphiz, beforesweepstep, (/0,0,0,0,-1,0/))
                  CALL set_dependency(f2x, gradphiz, (/-1,0,0,0,0,1/))
                  CALL set_dependency(f2y, gradphiz, (/0,0,-1,0,0,1/))
                  CALL set_dependency(f2z, gradphix, (/0,1,0,0,-1,0/))
                  CALL set_dependency(f2z, gradphiy, (/0,0,0,1,-1,0/))
                  CALL set_dependency(f2z, gradphiz, (/0,0,0,0,0,0/))
               END IF
            END IF
         END IF
      END IF
    END SUBROUTINE update_final_fluxes_

    SUBROUTINE updateB_final_()
      CALL set_dependency(A3x, aux, same)
      CALL set_dependency(A3x, e2z, (/0,0,0,1,0,0/))
      CALL set_dependency(A3y, e2z, (/0,1,0,0,0,0/))

      IF (nDim >= 3) THEN
         CALL set_dependency(A3x, e2y, (/0,0,0,0,0,1/))
         CALL set_dependency(A3y, e2x, (/0,0,0,0,0,1/))
         CALl set_dependency(A3z, e2x, (/0,0,0,1,0,0/))
         CALl set_dependency(A3z, e2y, (/0,1,0,0,0,0/))
      END IF
    END SUBROUTINE updateB_final_



    SUBROUTINE update_final_()
      CALL set_dependency(w3, beforesweepstep, same)
      CALL set_dependency(w3, f2x, (/0,1,0,0,0,0/))
      IF (nDim >= 2) THEN
         CALL set_dependency(w3, f2y, (/0,0,0,1,0,0/))
         IF (nDim >= 3) THEN
            CALL set_dependency(w3, f2z, (/0,0,0,0,0,1/))
         END IF
      END IF
      IF (lMHD .AND. nDim >= 2) THEN
         CALL set_dependency(aftersweepstep, A3x, (/0,1,0,0,0,0/))
         CALL set_dependency(aftersweepstep, A3y, (/0,0,0,1,0,0/))
         IF (nDim == 3) CALL set_dependency(aftersweepstep, A3z, (/0,0,0,0,0,1/))
      END IF
    END SUBROUTINE update_final_

    SUBROUTINE update_final_noctu_()
      CALL set_dependency(w3, beforesweepstep, same)
      CALL set_dependency(w3, f2x, (/0,1,0,0,0,0/))
      IF (nDim >= 2) THEN
         CALL set_dependency(w3, f2y, (/0,0,0,1,0,0/))
         IF (nDim >= 3) THEN
            CALL set_dependency(w3, f2z, (/0,0,0,0,0,1/))
         END IF
      END IF
    END SUBROUTINE update_final_noctu_

  END SUBROUTINE sweep_

END MODULE SchemeDeclarations
