!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    io_declarations.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
!> @file io_declarations.f90
!! @brief Main file for module IODeclarations

!> @defgroup IODeclarations IO Declarations
!! @brief Declarations module for IO control, provides an accumulator and several iDataFileType values.
!! @ingroup IO

!> Declarations file for IO control, provides an accumulator and several iDataFileType values.
!! @ingroup IODeclarations
!! @author Brandon D. Shroyer
!! @date 7-13-2010
MODULE IODeclarations

    USE GlobalDeclarations

	IMPLICIT NONE
        SAVE

	PUBLIC
	
	
	! Value tags for iDataFileType.
	INTEGER, PARAMETER :: IO_CHOMBO = 0	!! iDataFileType tag for the Chombo format.
	INTEGER, PARAMETER :: IO_BOV = 1	!! iDataFileType tag for the BOV format.
        INTEGER :: NrInputVars
	
	NAMELIST/IOData/iDataFileType
	
	REAL(KIND=qPrec) :: t_io_cumulative = 0.d0, t_io_start, t_io_end !! Stores the cumulative time spent generating files.
       
END MODULE IODeclarations

