!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    io_okc.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
!> @file io_okc.f90
!! @brief Main file for module IOOkc

!> @defgroup IOOkc IO OKC
!! @brief Writes OKC files for viewing particle data in visit
!! @ingroup IO

!> Writes OKC files for viewing particle data in visit
!! @ingroup IOOkc
MODULE IOOkc
USE ParticleDeclarations
USE ParticleControl
IMPLICIT NONE

CONTAINS

  !> Writes an okc file for the current frame
  !! @param nframe Current frame
  SUBROUTINE MakeOKCFile(nframe)
    CHARACTER(19) :: filename
    INTEGER :: i,nframe,nractive, j, nrsinkfields
    REAL(KIND=qPREC), ALLOCATABLE, DIMENSION(:,:) :: data
    TYPE(ParticleListDef), POINTER :: ParticleList
    TYPE(ParticleDef), POINTER :: Particle
    IF (.NOT. lParticles) RETURN
    IF (MPI_ID > 0) RETURN
    j=0
    NrSinkFields=3+NrHydroVars+nAngularMomentum

    ALLOCATE(data(NrSinkFields, NrSinkParticles))
    ParticleList=>SinkParticles

    DO i=1, NrSinkParticles
       IF (.NOT. ASSOCIATED(ParticleList)) THEN
          print*, 'error - NrSinkParticles > Count(SinkParticles)'
          STOP
       END IF
       Particle=>ParticleList%Self
       data(:,i)=(/particle%xloc-GxBounds(:,1),particle%Q(1:NrHydroVars), particle%J(1:nAngularMomentum)/)
!       data(1:7,i)=(/Particle%xloc-GxBounds(:,1), Particle%Mass, Particle%vel/)
!       IF (nDim == 2) THEN
!          data(10,i)=Particle%J(1)
!       ELSE
!          data(8:10,i)=Particle%J
!       END IF
       ParticleList=>ParticleList%Next
    END DO
    write(filename, '(A10,I5.5,A4)') "out/sinks_", nframe, ".okc"
    OPEN (UNIT=11, file=filename, status="unknown")
!    IF (nframe==0) THEN
! Always create 1 dummy particle to make visit happy
       write(11, '(3I6)') NrSinkFields, max(1,NrSinkParticles), NrSinkFields !makes visit happy to have at least one particle when opening the database
!    ELSE
!       write(11, '(3I6)') 10, NrSinkParticles, 10
!    END IF
    write(11, *) "x"
    write(11, *) "y"
    write(11, *) "z"
    DO i=1, NrCons
       write(11, *) trim(FieldName(i))
    END DO

    ! Creates tags for tracer variables.
    DO i = 1, NrTracerVars !NrCons+1,NrHydroVars
       write(11, *) trim(TracerName(i))
    END DO

    IF (nDim == 3) THEN
       write(11, *) "sink_Jx"
       write(11, *) "sink_Jy"
    END IF
    write(11, *) "sink_Jz"
    DO i=1,3
       write(11,'(2E15.5,I4)') GxBounds(i,1), GxBounds(i,2)
    END DO
    IF (NrSinkParticles==0) THEN
       DO i=4,NrSinkFields
          write(11, '(2E15.5,I4)') 0d0,0d0
       END DO
       write(11, '(100E24.16)') (/(i*0d0,i=1,NrSinkFields)/)
    ELSE
       DO i=4,NrSinkFields
          write(11, '(2E15.5)') minval(data(i,:)), maxval(data(i,:))
       END DO
       DO i=1,NrSinkParticles
          write(11, '(100E24.16)') data(:,i)
       END DO
    END IF
    close(11)
    DEALLOCATE(data)
  END SUBROUTINE MakeOKCFile

END MODULE IOOkc


