MODULE LayoutControl
   USE LayoutDeclarations
   USE LayoutComms
   USE GlobalDeclarations
   USE CommunicationDeclarations
   USE SlopeLim
   USE PFFT
   IMPLICIT NONE

   INTERFACE ProlongateLayout
      MODULE PROCEDURE ProlongateLayoutC, ProlongateLayoutR
   END INTERFACE ProlongateLayout


CONTAINS
   ! Subroutine that takes a layout object that has data - and increases the level by 1 via prolongation
   SUBROUTINE ProlongateLayoutC(layout, data, method, FieldID)
      TYPE(PFFTPlanDef), POINTER :: plan, newplan
      TYPE(LayoutDef), POINTER :: layout
      TYPE(LayoutDef), POINTER :: newlayout
      TYPE(LayoutDef), POINTER :: parentlayout
      INTEGER :: method
      INTEGER :: FieldID(:)
      INTEGER, DIMENSION(3,2) :: mB, mC
      COMPLEX(8), DIMENSION(:,:,:,:), POINTER :: data, newdata, parentdata
      REAL(8), DIMENSION(:,:,:), POINTER :: temp_real, temp_cmplx
      INTEGER :: i, nGhost


      !life gets more complicated if we use an arbitrary new layout instead of just prolongating the one we have...
      ALLOCATE(newlayout)
      ALLOCATE(newlayout%mB(0:MPI_NP-1, 3, 2))
      newlayout%level=layout%level+1
      DO i=0, MPI_NP-1
         newlayout%mB(i,:,:)=LevelUp(layout%mB(i,:,:), layout%level)
      END DO
      mB=newlayout%mB(MPI_ID,:,:)
      ALLOCATE(newdata(mB(1,1):mB(1,2), mB(2,1):mB(2,2), mB(3,1):mB(3,2), size(data, 4)))



      IF (method == SPECTRAL_PROLONGATION) THEN
         !We need to take our layout - map it to a PFFT layout
         !And take our new layout and map it to a PFFT layout
         !Then load data into the low res PFFT layout and do the transform
         !Then map the transformed data from the old PFFT layout to the new PFFT layout
         !And then transform back to the new data set
         mC(:,1)=minval(layout%mB(:,:,1),1)
         mC(:,2)=maxval(layout%mB(:,:,2),1)
         CALL CreatePlan(plan,layout%level, mC, size(data,4))
         CALL TransferLayoutsC(layout, plan%layouts(1)%p, data, plan%data)
         CALL ExecutePlan(plan, FORWARD)

         CALL CreatePlan(newplan,newlayout%level, LevelUp(mC,layout%level), size(data,4))


         CALL SpectralProlongation(plan, newplan)



         !Now we need to take plan%data and map it to newplan%data and add phase shifts

         CALL ExecutePlan(newplan, BACKWARD)
         CALL TransferLayoutsC(newplan%layouts(1)%p, newlayout, newplan%data, newdata)
         CALL DestroyPlan(plan)
         CALL DestroyPlan(newplan)

      ELSE
         ALLOCATE(temp_real(mB(1,1):mB(1,2), mB(2,1):mB(2,2), mB(3,1):mB(3,2)))
         ALLOCATE(temp_cmplx(mB(1,1):mB(1,2), mB(2,1):mB(2,2), mB(3,1):mB(3,2)))

         nGhost=GetnGhost(method)
         IF (nGhost > 0) THEN !need to create a larger layout with ghost zones
            ALLOCATE(parentlayout)
            ALLOCATE(parentlayout%mB(0:MPI_NP-1,3,2))
            parentlayout%level=layout%level
            parentlayout%mB=layout%mB
            DO i=0, MPI_NP-1
               parentlayout%mB(i,:,:)=expand(parentlayout%mB(i,:,:), nGhost)
            END DO

            mB=parentlayout%mB(MPI_ID,:,:)
            ALLOCATE(parentdata(mB(1,1):mB(1,2), mB(2,1):mB(2,2), mB(3,1):mB(3,2), size(data, 4)))

            parentdata=0
            !now fill new data with fields so that external ghost zones will be populated
            !        DO i=0, parentlayout%level
            !           CALL LoadFieldIntoLayout(parentlayout, parentdata, FieldID, parentlayout%level)
            CALL LoadFieldIntoLayout(parentlayout, parentdata, FieldID)
            !        END DO
            !and then transfer previous data set (potentially prolongated)
            CALL TransferLayoutsC(layout, parentlayout, data, parentdata)
         ELSE
            parentdata=>data
            parentlayout=>layout
         END IF

         DO i=1,size(parentdata, 4)
            CALL ProlongateCellCenteredData(REAL(parentdata(:,:,:,i)), temp_real, levels(layout%level)%CoarsenRatio, nGhost, method)
            CALL ProlongateCellCenteredData(AIMAG(parentdata(:,:,:,i)), temp_cmplx, levels(layout%level)%CoarsenRatio, nGhost, method)
            newdata(:,:,:,i)=cmplx(temp_real, temp_cmplx, 8)
         END DO

         IF (nGhost > 0) THEN
            DEALLOCATE(parentdata)
            DEALLOCATE(parentlayout%mB)
            DEALLOCATE(parentlayout)
         END IF

         DEALLOCATE(temp_real, temp_cmplx)
      END IF
      DEALLOCATE(data)
      DEALLOCATE(layout%mB)
      DEALLOCATE(layout)

      data=>newdata    
      layout=>newlayout




   END SUBROUTINE ProlongateLayoutC


   ! Subroutine that takes a layout object that has data - and increases the level by 1 via prolongation
   SUBROUTINE ProlongateLayoutR(layout, data, method, FieldID)
      TYPE(LayoutDef), POINTER :: layout
      TYPE(LayoutDef), POINTER :: newlayout
      TYPE(LayoutDef), POINTER :: parentlayout
      INTEGER :: method
      INTEGER :: FieldID(:)
      INTEGER, DIMENSION(3,2) :: mB
      REAL(8), DIMENSION(:,:,:,:), POINTER :: data, newdata, parentdata
      INTEGER :: i, nGhost

      !life gets more complicated if we use an arbitrary new layout instead of just prolongating the one we have...
      ALLOCATE(newlayout)
      ALLOCATE(newlayout%mB(0:MPI_NP-1, 3, 2))
      newlayout%level=layout%level+1
      DO i=0, MPI_NP-1
         newlayout%mB(i,:,:)=LevelUp(layout%mB(i,:,:), layout%level)
      END DO
      mB=newlayout%mB(MPI_ID,:,:)
      ALLOCATE(newdata(mB(1,1):mB(1,2), mB(2,1):mB(2,2), mB(3,1):mB(3,2), size(data, 4)))

      nGhost=GetnGhost(method)
      IF (nGhost > 0) THEN !need to create a larger layout with ghost zones
         ALLOCATE(parentlayout)
         parentlayout%level=layout%level
         ALLOCATE(parentlayout%mB(0:MPI_NP-1,3,2))
         DO i=0, MPI_NP-1
            parentlayout%mB(i,:,:)=expand(parentlayout%mB(i,:,:), nGhost)
         END DO
         mB=parentlayout%mB(MPI_ID,:,:)
         ALLOCATE(parentdata(mB(1,1):mB(1,2), mB(2,1):mB(2,2), mB(3,1):mB(3,2), size(data, 4)))
         !now fill new data with fields so that external ghost zones will be populated
         CALL LoadFieldIntoLayout(parentlayout, parentdata, FieldID)

         !and then transfer previous data set (potentially prolongated)
         CALL TransferLayoutsR(layout, parentlayout, data, parentdata)
      ELSE
         parentdata=>data
         parentlayout=>layout
      END IF
      DO i=1,size(parentdata, 4)
         CALL ProlongateCellCenteredData(parentdata(:,:,:,i),newdata(:,:,:,i), levels(layout%level)%CoarsenRatio, nGhost, method)
      END DO

      IF (nGhost > 0) THEN
         DEALLOCATE(parentdata)
         DEALLOCATE(parentlayout%mB)
         DEALLOCATE(parentlayout)
      END IF

      DEALLOCATE(data)
      DEALLOCATE(layout%mB)
      DEALLOCATE(layout)

      data=>newdata    
      layout=>newlayout


   END SUBROUTINE ProlongateLayoutR
END MODULE LayoutControl
