!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    layout.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
MODULE LayoutDeclarations
  USE GlobalDeclarations
  IMPLICIT NONE

  TYPE LayoutDef
     INTEGER, ALLOCATABLE, DIMENSION(:,:,:) :: mB
     INTEGER :: level
  END TYPE LayoutDef

  TYPE pLayoutDef
     TYPE(LayoutDef), POINTER :: p
  END type pLayoutDef

CONTAINS
  
  SUBROUTINE CreateLayout(mB, layout)
    TYPE(LayoutDef), POINTER :: layout
    INTEGER, DIMENSION(3,2) :: mB
    ALLOCATE(layout)
    ALLOCATe(layout%mB(0:MPI_NP-1, 3, 2))
    CALL split(mB, (/0,MPI_NP-1/), layout)
  END SUBROUTINE CreateLayout

  SUBROUTINE DestroyLayout(layout)
    TYPE(LayoutDef), POINTER :: layout
    DEALLOCATE(layout%mB)
    DEALLOCATE(layout)
    NULLIFY(layout)
  END SUBROUTINE DestroyLayout
  


  recursive subroutine split(mB, procs, layout)
    INTEGER, DIMENSION(3,2) :: mB, mBl, mBr
    INTEGER, DIMENSION(2) :: procs, procsL, procsR
    TYPE(LayoutDef) :: layout
    INTEGER :: nprocs, mx(3), split_point, split_dir
    REAL(8) :: split_weight
    mx=mB(:,2)-mB(:,1)+1
    nprocs=procs(2)-procs(1)+1
    IF (nprocs == 1) THEN
       IF (ALL(mB(:,2) >= mB(:,1))) THEN
          layout%mB(procs(1),:,:)=mB
       ELSE
          layout%mB(procs(1),:,:)=0
       END IF
       RETURN
    END IF
    split_weight=REAL((nprocs/2))/REAL(nprocs) !if procs is odd this is < ncells
    split_dir=sum(maxloc(mx))
    split_point=mB(split_dir,1)-1+nint(split_weight*mx(split_dir))
    mBL=mB
    mBR=mB
    mBL(split_dir,2)=split_point
    mBR(split_dir,1)=split_point+1
    procsl=procs
    procsr=procs
    procsl(2)=procs(1)-1+nprocs/2
    procsr(1)=procs(1)-1+nprocs/2+1
    CALL split(mBL, procsl, layout)
    CALL split(mBR, procsR, layout)
  END subroutine split



  SUBROUTINE StoreLayout(layout, data, name)
     TYPE(LayoutDef), POINTER :: layout
     REAL(KIND=qPREC), DIMENSION(:,:,:,:), POINTER :: data
     CHARACTER(LEN=*) :: name
     CHARACTER(LEN=80) :: myname
     INTEGER :: nfields
     INTEGER :: mB(3,2)
     nfields=size(data,4)
     WRITE(myname, '(A,I4.4,A)') TRIM(name), MPI_ID, '.dat'
     OPEN(UNIT=LAYOUT_DATA_HANDLE, FILE=myname, STATUS='replace')
     WRITE(LAYOUT_DATA_HANDLE, '(I4)') nfields
     WRITE(LAYOUT_DATA_HANDLE, '(6I10)') layout%mB
     WRITE(LAYOUT_DATA_HANDLE, '(16E25.16)') data
     CLOSE(LAYOUT_DATA_HANDLE)
  END SUBROUTINE StoreLayout
  
  SUBROUTINE LoadLayout(layout, data, name)
     TYPE(LayoutDef), POINTER :: layout
     REAL(KIND=qPREC), DIMENSION(:,:,:,:), POINTER :: data
     CHARACTER(LEN=*) :: name
     CHARACTER(LEN=80) :: myname
     INTEGER :: nfields
     INTEGER :: mB(3,2)
     WRITE(myname, '(A,I4.4,A)') TRIM(name), MPI_ID, '.dat'
     OPEN(UNIT=LAYOUT_DATA_HANDLE, FILE=myname, STATUS='replace')
     READ(LAYOUT_DATA_HANDLE, '(I4)') nfields
     READ(LAYOUT_DATA_HANDLE, '(6I10)') layout%mB
     mb=layout%mB(MPI_ID,:,:)
     ALLOCATE(data(mb(1,1):mb(1,2), mb(2,1):mb(2,2), mb(3,1):mb(3,2),nfields))
     READ(LAYOUT_DATA_HANDLE, '(16E25.16)') data
     CLOSE(LAYOUT_DATA_HANDLE)     
  END SUBROUTINE LoadLayout

END MODULE LayoutDeclarations
