!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    problem.f90 of module 1DWaves is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
!> @dir 1DWaves
!! @brief Contains files necessary for the 1DWaves module

!> @file problem.f90
!! @brief Main file for module Problem

!> @defgroup 1DWaves 1D Waves Module
!! @brief Module for testing 1D Waves
!! @ingroup Modules

!> MultiClump Module
!! @ingroup 1DWaves
MODULE Problem
  USE DataDeclarations
  USE SplitRegions
  USE Shapes
  USE EOS
  USE RiemannSolvers
  USE Ambients
  USE Totals
  USE Fields
  IMPLICIT NONE
  SAVE

  PUBLIC ProblemModuleInit, ProblemGridInit, &
       ProblemBeforeStep, ProblemAfterStep, ProblemSetErrFlag, ProblemBeforeGlobalStep
  REAL(KIND=qPREC) :: amplitude, wave_number, qout(20)
  INTEGER :: dir
CONTAINS

  !> Initializes module variables
  SUBROUTINE ProblemModuleInit()      
    TYPE(AmbientDef), POINTER :: Ambient
    REAL(KIND=qPREC) :: rhoOut, pOut, vxOut, vyOut, vzOut, BxOut, ByOut, BzOut
    TYPE(TotalDef), POINTER :: Total
    NAMELIST /AmbientData/ rhoOut, pOut, vxOut, vyOut, vzOut, BxOut, ByOut, BzOut
    NAMELIST /ProblemData/ amplitude, wave_number,dir
    OPEN(UNIT=PROBLEM_DATA_HANDLE, FILE='problem.data', STATUS="OLD")
    READ(PROBLEM_DATA_HANDLE,NML=ProblemData)
    !      IF (MPI_NP /= 1 .OR. MaxLevel /= 0) THEN
    !         PRINT*, 'error - this module is only setup to run on a single processor with maxlevel=0'
    !         PRINT*, 'stopping'
    !         STOP
    !      END IF
    CALL CreateTotal(Total)
    Total%Field%Component=GASCOMP
    Total%Field%id=ivx
    Total%Field%name=FieldName(ivx)

    IF (ivy /= 0) THEN
       CALL CreateTotal(Total)
       Total%Field%Component=GASCOMP
       Total%Field%id=ivx
       Total%Field%name=FieldName(ivx)
    END IF
    CALL CreateTotal(Total)
    Total%Field%Component=GASCOMP
    Total%Field%id=1
    Total%Field%name=FieldName(1)
    IF (iE /= 0) THEN
       CALL CreateTotal(Total)
       Total%Field%Component=GASCOMP
       Total%Field%id=iE
       Total%Field%name=FieldName(iE)
    END IF

    CALL CreateTotal(Total)
    Total%Field%Component=GASCOMP
    Total%Field%id=GravEnergy_Field
    Total%Field%name=FieldName(GravEnergy_Field)
    CALL CreateAmbient(Ambient)
    READ(PROBLEM_DATA_HANDLE,NML=AmbientData)
    Ambient%density=rhoOut
    Ambient%pressure=pOut
    Ambient%B(:)=(/BxOut, ByOut, BzOut/)
    Ambient%velocity(:)=(/vxOut, vyOut, vzOut/)
    qout(1)=rhoOut
    IF (ivx /= 0) qout(ivx)=vxOut*rhoout
    IF (ivy /= 0) qout(ivy)=vyOut*rhoOut
    IF (ivz /= 0) qout(ivz)=vzOut*rhoOut
    IF (iBx /= 0) qout(iBx)=BxOut
    IF (iBy /= 0) qout(iBy)=ByOut    
    IF (iBz /= 0) qout(iBz)=BzOut
    IF (iE /= 0) qout(iE) = gamma7*pOut+half*rhoOut*(vxOut**2+vyOut**2+vzOut**2)+half*(BxOut**2+ByOut**2+BzOut**2)
    CLOSE(PROBLEM_DATA_HANDLE)
    write(*,*) 'Jeans length=', JeansLength(rhoout, pOut/rhoOut)
  END SUBROUTINE ProblemModuleInit

   !> Applies initial conditions
   !! @param Info Info object
   SUBROUTINE ProblemGridInit(Info)
      TYPE(InfoDef) :: Info
      INTEGER :: i,j,k
      REAL(KIND=qPREC) :: x,y,z,dev
      CALL ConvertTotalToInternalEnergy(Info%q(:,:,:,:))          
      IF (dir==1) THEN
         DO i=1, Info%mX(1)
            x=Info%xbounds(1,1)+(real(i)-half)*levels(Info%level)%dx
            Info%q(i,:,:,1:m_high)=Info%q(i,:,:,1:m_high)*(1d0+amplitude*sin(2d0*Pi*wave_number*x/(GxBounds(1,2)-GxBounds(1,1))))
            IF (iE /= 0) Info%q(i,:,:,iE)=Info%q(i,:,:,iE)*(1d0+amplitude*sin(2d0*Pi*wave_number*x/(GxBounds(1,2)-GxBounds(1,1))))
         END DO
      ELSEIF (dir == 2) THEN

         DO i=1, Info%mX(2)
            x=Info%xbounds(2,1)+(real(i)-half)*levels(Info%level)%dx
            Info%q(:,i,:,1:m_high)=Info%q(:,i,:,1:m_high)*(1d0+amplitude*sin(2d0*Pi*wave_number*x/(GxBounds(2,2)-GxBounds(2,1))))
            IF (iE /= 0) Info%q(:,i,:,iE)=Info%q(:,i,:,iE)*(1d0+amplitude*sin(2d0*Pi*wave_number*x/(GxBounds(2,2)-GxBounds(2,1))))
         END DO

      ELSEIF (dir == 3) THEN

         DO i=1, Info%mX(3)
            x=Info%xbounds(3,1)+(real(i)-half)*levels(Info%level)%dx
            Info%q(:,:,i,1:m_high)=Info%q(:,:,i,1:m_high)*(1d0+amplitude*sin(2d0*Pi*wave_number*x/(GxBounds(3,2)-GxBounds(3,1))))
            IF (iE /= 0) Info%q(:,:,i,iE)=Info%q(:,:,i,iE)*(1d0+amplitude*sin(2d0*Pi*wave_number*x/(GxBounds(3,2)-GxBounds(3,1))))
         END DO
         
      ELSEIF (dir == 4) THEN
         DO i=1,Info%mX(1)
            x=Info%xbounds(1,1)+(real(i)-half)*levels(Info%level)%dx
            DO j=1,Info%mX(2)
               y=Info%xbounds(2,1)+(real(j)-half)*levels(Info%level)%dx
               Info%q(i,j,:,1:m_high)=Info%q(i,j,:,1:m_high)*(1d0+amplitude*sin(4d0*Pi*wave_number*(x+y)/(SUM(GxBounds(1:2,2)-GxBounds(1:2,1)))))
               IF (iE /= 0) Info%q(i,j,:,1:iE)=Info%q(i,j,:,1:iE)*(1d0+amplitude*sin(4d0*Pi*wave_number*(x+y)/(SUM(GxBounds(1:2,2)-GxBounds(1:2,1)))))
               
            END DO
         END DO
      ELSEIF (dir == 5) THEN
         DO i=1,Info%mX(2)
            x=Info%xbounds(2,1)+(real(i)-half)*levels(Info%level)%dx
            DO j=1,Info%mX(3)
               y=Info%xbounds(3,1)+(real(j)-half)*levels(Info%level)%dx
               Info%q(:,i,j,1:m_high)=Info%q(:,i,j,1:m_high)*(1d0+amplitude*sin(4d0*Pi*wave_number*(x+y)/(SUM(GxBounds(2:3,2)-GxBounds(2:3,1)))))
               IF (iE /= 0) Info%q(:,i,j,1:iE)=Info%q(:,i,j,1:iE)*(1d0+amplitude*sin(4d0*Pi*wave_number*(x+y)/(SUM(GxBounds(2:3,2)-GxBounds(2:3,1)))))
               
            END DO
         END DO

      ELSEIF (dir == 7) THEN
         DO i=1,Info%mX(1)
            x=Info%xbounds(1,1)+(real(i)-half)*levels(Info%level)%dx
            DO j=1,Info%mX(2)
               y=Info%xbounds(2,1)+(real(j)-half)*levels(Info%level)%dx
               DO k=1,Info%mX(3)
                  z=Info%xbounds(3,1)+(real(k)-half)*levels(Info%level)%dx
                  dev=(1d0+amplitude*sin(6d0*Pi*wave_number*(x+y+z)/sum((GxBounds(1:3,2)-GxBounds(1:3,1)))))

!                  dev=(1d0+amplitude*sin(2d0*Pi*wave_number*(x)/(GxBounds(1,2)-GxBounds(1,1))))* &
!                       (1d0+amplitude*sin(2d0*Pi*wave_number*(y)/(GxBounds(2,2)-GxBounds(2,1))))* &
!                       (1d0+amplitude*sin(2d0*Pi*wave_number*(z)/(GxBounds(3,2)-GxBounds(3,1))))
                  Info%q(i,j,k,1:m_high)=Info%q(i,j,k,1:m_high)*dev
                  IF (iE /= 0) Info%q(i,j,k,1:iE)=Info%q(i,j,k,1:iE)*dev
               END DO
            END DO
         END DO
      END IF
      CALL ConvertInternalToTotalEnergy(Info%q(:,:,:,:))          
   END SUBROUTINE ProblemGridInit

   !> Applies Boundary conditions
   !! @param Info Info object
   SUBROUTINE ProblemBeforeStep(Info)
      TYPE(InfoDef) :: Info
   END SUBROUTINE ProblemBeforeStep

   !> Could be used to update grids pre-output
   !! @param Info Info Object
   SUBROUTINE ProblemAfterStep(Info)
      TYPE(InfoDef) :: Info
      INTEGER :: i
      REAL(KIND=qPREC), ALLOCATABLE, DIMENSION(:,:) :: qExact
      REAL(KIND=qPREC) :: x
      REAL(KIND=qPREC), ALLOCATABLE, DIMENSION(:) :: wmiddle
      RETURN
      IF (levels(info%level)%tnow+levels(info%level)%dt == final_time) THEN
         OPEN(UNIT=11, FILE='data.curve', status='unknown')
         write(11,*) ' #rho'
         DO i=1, Info%mX(1)
            write(11,*) Info%xbounds(1,1)+(REAL(i)-half)*levels(Info%level)%dx, Info%q(i,1,1,1)
         END DO
         write(11,*) ' #vx'
         DO i=1, Info%mX(1)
            write(11,*) Info%xbounds(1,1)+(REAL(i)-half)*levels(Info%level)%dx, Info%q(i,1,1,ivx)/Info%q(i,1,1,1)
         END DO
         write(11,*) ' #P'
         DO i=1, Info%mX(1)
            write(11,*) Info%xbounds(1,1)+(REAL(i)-half)*levels(Info%level)%dx, (Press(Info%q(i,1,1,:)))
         END DO                 
         ALLOCATE(qExact(Info%mX(1), NrHydroVars))
!         ALLOCATE(wmiddle(1:NrHydroVars))
         DO i=1, Info%mX(1)
            x=Info%xbounds(1,1)+(real(i)-half)*levels(Info%level)%dx - final_time**3/6d0
            qExact(i,1:m_high)=qOut(1:m_high)*(1d0+amplitude*sin(2d0*Pi*wave_number*x/(GxBounds(1,2)-GxBounds(1,1))))
            qExact(i,iE)=qOut(iE)
         END DO
         write(11,*) ' #rho_Exact'
         DO i=1, Info%mX(1)
            write(11,*) Info%xbounds(1,1)+(REAL(i)-half)*levels(Info%level)%dx, qExact(i,1)
         END DO
         write(11,*) ' #vx_Exact'
         DO i=1, Info%mX(1)
            write(11,*) Info%xbounds(1,1)+(REAL(i)-half)*levels(Info%level)%dx, qExact(i,ivx)
         END DO
         write(11,*) ' #P_Exact'
         DO i=1, Info%mX(1)
            write(11,*) Info%xbounds(1,1)+(REAL(i)-half)*levels(Info%level)%dx, qExact(i,iE)
         END DO                 
         CLOSE(11)
         write(*,*) 'dx, L2 Norm=', levels(Info%level)%dx, sum(abs(qExact(:,1)-Info%q(1:Info%mX(1),1,1,1)))/Info%mX(1)
      END IF
      
   END SUBROUTINE ProblemAfterStep

   !> Could be used to set force refinement
   !! @param Info Info object
   SUBROUTINE ProblemSetErrFlag(Info)
      TYPE(InfoDef) :: Info
   END SUBROUTINE ProblemSetErrFlag


   SUBROUTINE ProblemBeforeGlobalStep(n)
      INTEGER :: n
   END SUBROUTINE ProblemBeforeGlobalStep
END MODULE Problem

