!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    problem.f90 of module Binary is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
!> @dir OrbitingParticles
!! @brief Contains files necessary for the Orbiting Particles test problem

!> @file problem.f90
!! @brief Main file for module Problem

!> @defgroup OrbitingParticles Orbiting Particle Module
!! @brief Module for setting up orbiting particles
!! @ingroup Modules

!> Orbiting Particle Module
!! @ingroup OrbitingParticles
MODULE Problem
  USE DataDeclarations
  USE ParticleDeclarations
  USE Ambients
  USE Disks
  USE Winds
  IMPLICIT NONE
  SAVE
  PUBLIC ProblemModuleInit, ProblemGridInit, &
       ProblemBeforeStep, ProblemAfterStep, ProblemSetErrFlag, ProblemBeforeGlobalStep
  REAL(KIND=qPREC) :: alpha, densw, velw, t1, t2
  INTEGER :: radiusw, nWinds
  LOGICAL :: windsPresent=.false., disk=.false.
  !TYPE(pWindDef), DIMENSION(:), ALLOCATABLE :: MyWinds

CONTAINS

  !> Initializes module variables
   SUBROUTINE ProblemModuleInit()      
      TYPE(InfoDef) :: Info
		TYPE(WindDef), POINTER :: Wind
      INTEGER :: nParticles, edge
      REAL(KIND=qPREC) :: mass=0
      REAL(KIND=qPREC) :: xloc(3)
      REAL(KIND=qPREC) :: vel(3)
      TYPE(ParticleDef), POINTER :: Particle
		TYPE(ParticleListDef), POINTER :: particlelist
      INTEGER :: i, grav_soft_rad
      INTEGER :: ids(2)
      TYPE(AmbientDef), POINTER :: Ambient
      TYPE(DiskDef), POINTER :: mydisk
      REAL(KIND=qPREC) :: time, rhoOut, pOut, vxOut, vyOut, vzOut, BxOut, ByOut, BzOut, &
		   buff(17) 
      NAMELIST /AmbientData/ rhoOut, pOut, vxOut, vyOut, vzOut, BxOut, ByOut, BzOut
      NAMELIST /ProblemData/ nParticles, densw, velw, windsPresent, disk, t1, t2
      NAMELIST /ParticleData/ mass,xloc,vel,alpha,radiusw,grav_soft_rad, buff
      NAMELIST /RestartData/ ids

!      time=levels(Info%level)%tnow

      OPEN(UNIT=PROBLEM_DATA_HANDLE, FILE='problem.data', STATUS="OLD")
      READ(PROBLEM_DATA_HANDLE,NML=ProblemData)

if (.not. lrestart) then		
      CALL CreateAmbient(Ambient)
      READ(PROBLEM_DATA_HANDLE,NML=AmbientData)
      if (disk) then
		   Ambient%density=1d0
		else ; Ambient%density=rhoOut
		end if
      Ambient%pressure=Ambient%density
      Ambient%B(:)=(/BxOut, ByOut, BzOut/)
      Ambient%velocity(:)=(/vxOut, vyOut, vzOut/)
end if      

if (windsPresent) then
   DO i=1,nDim
      DO edge=1,2
         IF (Gmthbc(i,edge) == 1) THEN 
            NULLIFY(Wind)
            CALL CreateWind(Wind)
            Wind%dir=i
            Wind%edge=edge
				Wind%type=OUTFLOW_ONLY
         END IF
      END DO
   END DO
!  ALLOCATE(MyWinds(6))
!  nWinds=0
!  DO i=1,nDim
!     DO edge=1,2
!        IF (Gmthbc(i,edge) == 1) THEN 
!           nWinds=nWinds+1
!           CALL CreateWind(MyWinds(nWinds)%p)
!           MyWinds(nWinds)%p%dir=i
!           MyWinds(nWinds)%p%edge=edge
!  			MyWinds(nWinds)%p%type=OUTFLOW_ONLY
!        END IF
!     END DO
!  END DO
end if
		
     IF (lRestart) THEN
       particleList=>SinkParticles
		 i=1
       DO WHILE (ASSOCIATED(particlelist))
          particle=>particlelist%self
          READ(PROBLEM_DATA_HANDLE,NML=ParticleData)

          if (i==1) then
			    Particle%PointGravityObj%soft_length=REAL(grav_soft_rad,qPREC)*sink_dx
			    Particle%PointGravityObj%alpha = alpha
                if (alpha==0d0) then 
				       Particle%iAccrete=NOACCRETION
                else 
				       Particle%iAccrete=KRUMHOLZ_ACCRETION
					    ! see particle_declarations
				    end if
			 end if
      
	         !if (time.ge.t1   .and.   time.le.t2) then
			   !   Particle%PointGravityObj%alpha = alpha*(time-t1)/(t2-t1) ! (0,1)
			   !else ; Particle%PointGravityObj%alpha = 0d0
			   !end if

			 IF (i==2) THEN
             CALL CreateOutflowObject(Particle%OutflowObj)
             Particle%OutflowObj%duration				= 1.e30
             Particle%OutflowObj%radius					=REAL(radiusw,qPREC)*sink_dx
             Particle%OutflowObj%thickness				=REAL(radiusw,qPREC)*sink_dx
             Particle%OutflowObj%open_angle			= Pi
             Particle%OutflowObj%density				= densw
             Particle%OutflowObj%temperature			= 1d0
             Particle%OutflowObj%velocity				= velw
             Particle%OutflowObj%source_vel(1:nDim)	= Particle%Q(imom(1:nDim))
             Particle%OutflowObj%position= Particle%xloc
             CALL UpdateOutflow(Particle%OutflowObj)
          END IF
          particlelist=>particlelist%next
			 i=i+1
       END DO

     ELSE!lrestart

         DO i=1,nParticles
            READ(PROBLEM_DATA_HANDLE,NML=ParticleData)
            NULLIFY(Particle)
            CALL CreateParticle(Particle)
            Particle%Q(1)=mass
            Particle%xloc=xloc
            Particle%Q(imom(1:nDim))=vel(1:nDim)
            Particle%Buffer=buff
            CALL AddSinkParticle(Particle)
             
				if (i==1) then
			      Particle%iAccrete=KRUMHOLZ_ACCRETION
               CALL CreatePointGravityObject(Particle%PointGravityObj)
			      Particle%PointGravityObj%alpha = alpha
               Particle%PointGravityObj%soft_length	=	REAL(grav_soft_rad,qPREC)*sink_dx
               Particle%PointGravityObj%soft_function	=SPLINESOFT
               Particle%PointGravityObj%Mass				=Particle%Q(1)
               Particle%PointGravityObj%v0(1:nDim)		=Particle%Q(imom(1:nDim))
               Particle%PointGravityObj%x0				=Particle%xloc
            end if
!
!!!
if (disk) then
ALLOCATE(MyDisk)
!		mydisk%HeightProfile=0
		!mydisk%HeightProfile=1 !flared
      mydisk%soft_length=REAL(grav_soft_rad,qPREC)*sink_dx
      mydisk%soft_function=SPLINESOFT
      mydisk%density=densw
      mydisk%pressure=	&!mydisk%density
								Ambient%pressure
      mydisk%velocity=Particle%Q(imom(1:nDim))
      !
		   mydisk%theta=0d0 !5feb12
		   !mydisk%theta=10d0*(Pi/180d0) !4feb12
        !mydisk%theta=Pi*.5d0 !3feb12
		!  
      mydisk%phi=0d0
      mydisk%position=Particle%xloc
      mydisk%thickness=0d0
      mydisk%radius=	2d0 !6dec
							!1d0
							!6d0*REAL(radiusw,qPREC)*sink_dx
		               !24d0*sink_dx
 !     if (.not.mydisk%HeightProfile) 
 mydisk%height=2d0*REAL(grav_soft_rad,qPREC)*sink_dx
      !mydisk%height=mydisk%radius*.1d0
      mydisk%central_mass=mass
      CALL UpdateDisk(mydisk)
end if!lock 
!!!
!
            IF (i.eq.2) THEN
               CALL CreateOutflowObject(Particle%OutflowObj)
               Particle%OutflowObj%duration				= 1.e30
               Particle%OutflowObj%radius					=REAL(radiusw,qPREC)*sink_dx
               Particle%OutflowObj%thickness				=REAL(radiusw,qPREC)*sink_dx
               Particle%OutflowObj%open_angle			= Pi
               Particle%OutflowObj%density				= densw
               Particle%OutflowObj%temperature			= 1d0
               Particle%OutflowObj%velocity				= velw
               Particle%OutflowObj%source_vel(1:nDim)	= Particle%Q(imom(1:nDim))
               Particle%OutflowObj%position= Particle%xloc
               CALL UpdateOutflow(Particle%OutflowObj)
            END IF
         END DO
   END IF!lrestart=0/1
CLOSE(PROBLEM_DATA_HANDLE)      

   END SUBROUTINE ProblemModuleInit

  !> Applies initial conditions
  !! @param Info Info object
  SUBROUTINE ProblemGridInit(Info)
    TYPE(InfoDef) :: Info
  END SUBROUTINE ProblemGridInit

  !> Applies Boundary conditions
  !! @param Info Info object
  SUBROUTINE ProblemBeforeStep(Info)
    TYPE(InfoDef) :: Info
   INTEGER :: i, nParticles, grav_soft_rad
   REAL(KIND=xprec) :: beta,time, mass, xloc(3), vel(3),buff(17)
  	TYPE(ParticleListDef), POINTER :: particlelist
     TYPE(ParticleDef), POINTER :: Particle
	  LOGICAL,SAVE :: lock=.false.
     NAMELIST /ProblemData/ nParticles, densw, velw, windsPresent, disk, t1, t2
     NAMELIST /ParticleData/ mass,xloc,vel,alpha,radiusw,grav_soft_rad, buff

     return

     time=levels(Info%level)%tnow
        if (time.lt.t1) then ; return
   	  else if (time.ge.t1   .and.   time.le.t2) then
     	     beta = (time-t1)/(t2-t1) ! 0<= beta <=1
   	  else ; beta=1d0
   	  end if

           OPEN(UNIT=PROBLEM_DATA_HANDLE, FILE='problem.data', STATUS="OLD")
              READ(PROBLEM_DATA_HANDLE,NML=ProblemData)
                 particleList=>SinkParticles
       	         i=1
                 DO WHILE (ASSOCIATED(particlelist))
                    particle=>particlelist%self
                    READ(PROBLEM_DATA_HANDLE,NML=ParticleData)
       	   		      if (i==1) then
       				         Particle%PointGravityObj%alpha =alpha*beta
                          !print*,'t1,t2i,a*b=',t1,t2,i,alpha*beta
       					   end if
                       particlelist=>particlelist%next
       	      	   i=i+1
                 END DO
           CLOSE(PROBLEM_DATA_HANDLE)      
   
              if (time.gt.t2   .and.   Particle%PointGravityObj%alpha.eq.1d0) lock=.true.

  END SUBROUTINE ProblemBeforeStep

  !> Could be used to update grids pre-output
  !! @param Info Info Object
  SUBROUTINE ProblemAfterStep(Info)
    TYPE(InfoDef) :: Info
  END SUBROUTINE ProblemAfterStep

  !> Could be used to set force refinement
  !! @param Info Info object
  SUBROUTINE ProblemSetErrFlag(Info)
    TYPE(InfoDef) :: Info
  END SUBROUTINE ProblemSetErrFlag

  SUBROUTINE ProblemBeforeGlobalStep(n)
     INTEGER :: n
  END SUBROUTINE ProblemBeforeGlobalStep

END MODULE Problem

