#!/bin/bash
charlimiters=( .true. .false. )
char_names=( 'Characteristic_Limiting' 'Primitive_Limiting' )
file_names=( 'First order' 'Second Order' 'Third Order' )
#interporders=( 1 2 3 )
vars=( rho P vx vy Bx By )
for (( i=0;i<${#charlimiters[@]};i++)); do
    charlimiter=${charlimiters[i]}
    char_name=${char_names[i]}
    for (( j=0;j<${#vars[@]};j++)); do
	var=${vars[j]}
	
	files=($(ls out/data_*_${charlimiter}*.curve))
	echo > gnu_script
	echo "set terminal png size 800,600" >> gnu_script
	echo "set output '${var}_${charlimiter}.png'"  >> gnu_script
	echo "set title '${var} using ${char_name}'" >> gnu_script
#	echo "show title" >> gnu_script

	file=${files[1]}
	echo "plot 'out/exact.curve' index '${var}' w l lt 1 t 'Exact', \\" >> gnu_script
	for (( m=0;m<$((${#files[@]} - 1));m++)); do 
	    file=${files[m]}
	    title=${file_names[m]}
	    echo "'${file}' index '${var}' w l lt $(($m + 2)) t '${title}', \\" >> gnu_script
	    
	done
	file=${files[m]}
	title=${file}
	title=${file_names[m]}
	echo "'${file}' index '${var}' w l lt $(($m + 2)) t '${title}'" >> gnu_script
	cat gnu_script | gnuplot
    done
done
#display rho.png
montage -tile 2x7 *_*.png -geometry 800x600 images/sim.png
grep 'L2 Norm' logs/testlog | awk '{print $5}' > logs/max_errors.data
success=$(pr -m -t -s\  logs/max_errors.data ref/max_errors.data | awk 'BEGIN{pass=1}{pass = pass && $1 < 2*$2}END{print pass}')

if [ ${success} = "1" ]; then
    echo 'test comparison results:  T'
else
    echo 'test comparison results:  F'
fi

