!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    genak.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
!=======================================================================
!
! SUBROUTINE: genak.f90
!
! PURPOSE   : determines amplitude and phase in k-space for fldgen.F
!             assigns gaussians to Ak(kx,ky,kz) and Ak(-kx,-ky,kz)
!             requires 0 <= kx, ky <= dots and 0<= kz <= dots/2
!             note A(-k) = Ak(k)* c
!
! INPUT     : nx,ny,nz: array dimensions
!             kx,ky,kz: wavenumber
!             iseed   : random seed
!             pk      : amplitude
! 
! OUTPUT    : ak      : amplitude array
!
!======================================================================

subroutine genak (nx, ny, nz, kx, ky, kz, pk, iseed, pi, x)

  implicit none

  integer  kx, ky, kz, nkx, nky, nkz, &
           nx, ny, nz, iseed, dots

  double precision pk, pi, phi, rnd1, rnd2, r

  double precision x(2*nx*ny*nz)

!  double precision nr_randnum

!  external nr_randnum

!----------------------------------------------------------------------

  rnd1 = nr_randnum(iseed)
  phi  = 2d0*pi*rnd1            ! for the phase
  rnd2 = nr_randnum(iseed)          ! for the amplitude

  r    = dsqrt(-2.0*dlog(rnd2))*pk          ! amplitude

!       x(kx,ky,kz) = (r*cos(phi),r*sin(phi))

  x(2*(kx*ny*nz + ky*nz + kz)+1) = r*dcos(phi)  ! real. part
  x(2*(kx*ny*nz + ky*nz + kz)+2) = r*dsin(phi)  ! imag. part
!                   !
!                     ! now use Ak(-kx,-ky,-kz)=compl.conj. Ak(kx,ky,kz)
!                     ! in the array of fourn (Num. Rec. (1989): p.451)
!                   !
  if ((kx .ne. 0) .and. (ky .ne. 0) .and. (kz .ne. 0)) then
    nkx = nx - kx
    nky = ny - ky
    nkz = nz - kz
!        x(nkx,nky,nkz) = (r*cos(phi),-r*sin(phi))
    x(2*(nkx*ny*nz + nky*nz + nkz)+1) =  r*dcos(phi) ! real. part
    x(2*(nkx*ny*nz + nky*nz + nkz)+2) = -r*dsin(phi) ! imag. part
  end if

!=======================================================================

  return
end subroutine genak        
