!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    nr_randnum.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
!===================================================
!
! ROUTINE   : nr_randnum. See NumRec.
! PURPOSE   : returns random number between 0 and 1
!             as double precision
!===================================================

function nr_randnum (idum)

 implicit none

  integer         idum , j   , k    , idum2  , iy   , &
                  im1   , im2 , imm1 , ia1    , &
                  ia2  , iq1 , iq2  , ir1    , ir2  , &
                  ntab

  double precision am   , temp, ndiv , eps    , rnmx , &
                   nr_randnum

  parameter (im1 = 2147483563, im2 = 2147483399, &
             imm1= im1-1     , ia1 = 40014     , ia2 = 40692        , &
             iq1 = 53668     , iq2 = 52774     , ir1 = 12111        , &
             ir2 = 3791      , ntab= 32        , ndiv= 1+imm1/ntab  , &
             eps = 1.2d-12   , rnmx= 1d0-eps)

  integer          iv(0:ntab-1)

  common /randnumcom/ iy, iv, idum2

!------------------------------------------------------

      idum2 = 123456789     
      am    = 1d0/dble(im1)

      if (idum .le. 0) then
        if (-idum .lt. 1) then
          idum = 1
        else 
          idum = -idum
        end if
        idum2 = idum
        do j=ntab+7,0,-1
          k     = idum / iq1
          idum  = ia1*(idum-k*iq1)-k*ir1
          if (idum .lt. 0) idum = idum + im1
          if (j .lt. ntab) iv(j) = idum
        end do
        iy = iv(0)
      end if
      k    = idum/iq1
      idum = ia1*(idum-k*iq1)-k*ir1
      if (idum .lt. 0) idum = idum + im1
      k     = idum2/iq2
      idum2 = ia2 * (idum2-k*iq2)-k*ir2
      if (idum2 .lt. 0) idum2 = idum2 + im2
      j     = iy/ndiv
      iy    = iv(j) - idum2
      iv(j) = idum
      if (iy .lt. 1) iy = iy + imm1
      temp  = am * dble(iy)
      if (temp .gt. rnmx) then
        nr_randnum = rnmx
      else
        nr_randnum = temp
      end if

!===========================================================

  return
end function nr_randnum
