#!/bin/bash
#Effect of Grid Size on scaling
mxs=(512 1024 2048 4096 8192 16384)
n=3072
maxlevel=4
./subst.s MaxLevel $maxlevel global.data
cat header.out
for (( j=0;j<${#mxs[@]};j++)); do
  mx=${mxs[j]}
  ./subst.s Gmx $mx,$mx,1 global.data
  ./subst.s domain%mGlobal 1,1,1,$mx,$mx,1

  ./subst.s iThreaded -1 global.data
  ./subst.s LevelBalance 0d0,0d0 global.data
  mpirun -n $n ./astrobear 2>&1 | grep stats
  ./subst.s iThreaded 0 global.data
  ./subst.s LevelBalance 0d0,1d0 global.data
  mpirun -n $n ./astrobear 2>&1 | grep stats
  ./subst.s iThreaded 1 global.data
  ./subst.s LevelBalance 0d0,1d0 global.data
  mpirun -n $n ./astrobear 2>&1 | grep stats
  ./subst.s iThreaded 1 global.data
  ./subst.s LevelBalance 0d0,0d0 global.data
  mpirun -n $n ./astrobear 2>&1 | grep stats
done
