!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    problem.f90 of module GaussDiffusion is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
MODULE Problem
  USE DataDeclarations
  USE GlobalDeclarations
  USE PhysicsDeclarations
  USE Refinements
  USE Shapes
 ! USE IFPORT
  IMPLICIT NONE
  PRIVATE
  
  PUBLIC ProblemModuleInit, ProblemGridInit, &
       ProblemBeforeStep, ProblemAfterStep, ProblemSetErrFlag, ProblemBeforeGlobalStep

  LOGICAL :: Equi
  REAL(KIND=qPrec) :: rho0,rho1,r0,t0,t1,B0x,B0y
  INTEGER, PARAMETER :: ResTest_FILEHANDLE = 32
CONTAINS
  SUBROUTINE ProblemModuleInit
		!! @brief Reads the problem data file and performs a quick sanity check on the parameters.
    INTEGER :: iErr
    TYPE(RefinementDef), POINTER :: Refinement
    REAL(KIND=qPREC) :: d(3) = (/2.56,5.12,0.16/)

    !CALL CreateRefinement(Refinement)
    !CALL CreateShape(Refinement%Shape)
    !CALL SetShapeType(Refinement%Shape,5,d)
    !Refinement%Shape%position=(/1.28,0.0,0.0/)
    !Refinement%Shape%vel=(/0d0,0d0,0d0/)
    !CALL SetShapeBounds(Refinement%Shape)
    !Refinement%BufferCells=4
    !Refinement%tolerance=-1d0

		
  END SUBROUTINE ProblemModuleInit

  SUBROUTINE ProblemGridInit(Info)
	!! @brief Initializes the grid data according to the requirements of the problem.
	!! @param Info A grid structure.	
    TYPE (InfoDef) :: Info
    INTEGER :: i,j,k,iErr
    INTEGER :: rmbc,zrmbc
    INTEGER :: mx, my, mz
    REAL(KIND=qPrec) :: dx,r,Bx,By,Bz,Bp,Bxp,Byp,rho,l,kw,t,a,pos(3),B0x0,B0y0,B0x1,B0y1
    !NAMELIST /ProblemData/ rho0,rho1,r0,t0,t1,B0x,B0y
      
    rmbc = levels(Info%level)%gmbc(1)!CoarsenRatio(Info%level-1) * mbc

    IF(nDim==2)THEN
       zrmbc=0
    ELSE
       zrmbc=rmbc
    END IF

    mx=Info%mX(1); my=Info%mX(2); mz=Info%mX(3); dx=levels(Info%level)%dx

    rho0=1.0;rho1=20.0
    t0=20.0;t1=1.0
    r0=1.28
    B0x0=0.7d0;B0y0=0.7d0
    !B0x1=0d0;B0y1=0d0

    pos=0d0; Info%q=0d0; Info%aux=0d0
    DO k=1-zrmbc,mz+zrmbc; DO j=1-rmbc,my+rmbc; DO i=1-rmbc, mx+rmbc
       pos=Info%xBounds(1:3,1)+(/REAL(i)-half,REAL(j)-half,REAL(k)-half/)*levels(Info%level)%dx
       r=sqrt(pos(1)**2+pos(2)**2)
       IF(r.lt.r0)THEN ! inside
       !IF(pos(1).gt.0d0)THEN
          rho=rho1
          t=t1
          !Bx=B0x1
          !By=0.0!B0y1
          !PRINT*, "inside"
       ELSE ! outside
          rho=rho0
          t=t0
          !Bx=B0x0
          !By=4.0!B0y0
          !PRINT*, "outside"
       END IF

       Info%q(i,j,k,1)=rho
       Info%q(i,j,k,iBx)=B0x0
       Info%q(i,j,k,iBy)=B0y0
       !PRINT*, i,j,Info%aux(i,j,k,2)
       Info%q(i,j,k,iE)=rho*t/(gamma-1.)+0.5*By**2

    END DO; END DO; END DO

    IF (MaintainAuxArrays) THEN
       DO i=1-rmbc+1,mx+rmbc; DO j=1-rmbc,my+rmbc; DO k=1-zrmbc,mz+zrmbc
         Info%aux(i,j,k,1)=.5*(Info%q(i-1,j,k,iBx)+Info%q(i,j,k,iBx))
       END DO; END DO; END DO
       DO i=1-rmbc,mx+rmbc; DO j=1-rmbc,my+rmbc+1; DO k=1-zrmbc,mz+zrmbc
         Info%aux(i,j,k,2)=.5*(Info%q(i,j-1,k,iBy)+Info%q(i,j,k,iBy))
       END DO; END DO; END DO
       IF(nDim==3)THEN
          DO i=1-rmbc,mx+rmbc; DO j=1-rmbc,my+rmbc; DO k=1-zrmbc+1,mz+zrmbc
             Info%aux(i,j,k,3)=.5*(Info%q(i,j,k-1,iBz)+Info%q(i,j,k,iBz))
          END DO; END DO; END DO
       END IF
    END IF

  END SUBROUTINE ProblemGridInit

  SUBROUTINE ProblemBeforeStep(Info)
	!! @brief Performs any tasks required before the advance step.
	!! @param Info A grid structure.	
    TYPE (InfoDef) :: Info
    INTEGER :: i,j
    INTEGER :: rmbc
    INTEGER :: mx,my
    INTEGER :: iErr

  END SUBROUTINE ProblemBeforeStep

  SUBROUTINE ProblemAfterStep(Info)
  	!! @brief Performs any post-step corrections that are required.
	!! @param Info A grid structure.	
    TYPE (InfoDef) :: Info
  END SUBROUTINE ProblemAfterStep

  SUBROUTINE ProblemSetErrFlag(Info)
  	!! @brief Sets error flags according to problem-specific conditions..
	!! @param Info A grid structure.	
    TYPE (InfoDef) :: Info
  END SUBROUTINE ProblemSetErrFlag

  SUBROUTINE ProblemBeforeGlobalStep(n)
    INTEGER :: n
  END SUBROUTINE ProblemBeforeGlobalStep

END MODULE Problem
