#!/bin/bash
wave_names=( 'Left_Sound' 'Right_Sound' )
interp_names=( 'First order' 'Second Order' 'Third Order' )
#interporders=( 1 2 3 )
for (( i=0;i<${#wave_names[@]};i++)); do
    wave_name=${wave_names[i]}
#    for (( j=0;j<${#interp_names[@]};j++)); do
#	interp_name=${interp_names[j]}
    
    files=($(ls out/scaling_*_$(($i + 1)).curve))
    echo > gnu_script
    echo "set terminal png size 800,600" >> gnu_script
    echo "set output '${wave_name}.png'"  >> gnu_script
    echo "set title '${wave_name}'" >> gnu_script
    echo "set logscale xy" >> gnu_script
#	echo "show title" >> gnu_script
    echo "plot [x=.01:.1] 1e-6*(x/.015)**1 ls 0 t '', 2e-8*(x/.015)**2 ls 0 t '', 3e-10*(x/.015)**3 ls 0 t '', \\" >> gnu_script 
#    echo "plot '${file}' w l lt 1 t '${title}', \\" >> gnu_script
    for (( m=0;m<$((${#files[@]} - 1));m++)); do 
	file=${files[m]}
	title=${interp_names[m]}
	echo "'${file}' w l lt $(($m + 1)) t '${title}', \\" >> gnu_script
    done
    file=${files[m]}
    title=${interp_names[m]}
    echo "'${file}' w l lt $(($m + 1)) t '${title}'" >> gnu_script
    cat gnu_script | gnuplot
done
#done
#display rho.png
montage -tile 1x2 Left_Sound.png Right_Sound.png -geometry 800x600 images/sim.png
grep 'dx' logs/testlog | awk '{print $4}' > logs/max_errors.data
success=$(pr -m -t -s\  logs/max_errors.data ref/max_errors.data | awk 'BEGIN{pass=1}{pass = pass && $1 < 2*$2}END{print pass}')

if [ ${success} = "1" ]; then
    echo 'test comparison results:  T'
else
    echo 'test comparison results:  F'
fi

