#!/bin/bash

code_dir=/scratch/bliu17/Bear2BTest
run_dir=/scratch/bliu17/bearTest

rm ${run_dir}/testrun_slurm.sh
rm ${run_dir}/scaling_*_*.curve
rm ${run_dir}/MHDWaves.out
rm ${run_dir}/MHDWaves.log

cat >> ${run_dir}/testrun_slurm.sh <<EOF
#!/bin/bash
#SBATCH -J testRun
#SBATCH -N 1
#SBATCH -n 1
#SBATCH -c 1 
#SBATCH -p debug 
#SBATCH -t 00:30:00

module purge
module load mpi-xl
module load hdf5-1.8.8-MPI-XL 
module load fftw-3.3.2-MPI-XL
module load hypre-2.8.0b-MPI-XL

ulimit -s unlimited
srun /scratch/bliu17/bearTest/astrobear > MHDWaves.out 
EOF

interporders=( 1 2 3 )
Gmxs=( 16 32 64 )
Waves=7

for (( i=0;i<${#interporders[@]};i++)); do
    interporder=${interporders[i]}
    ${code_dir}/scripts/subst.s InterpOrder  $interporder ${run_dir}/solver.data
    for (( j=1;j<=$Waves;j++)); do
	${code_dir}/scripts/subst.s WaveFamily $j ${run_dir}/problem.data
	echo  > scaling_${interporder}_${j}.curve
	for (( m=0;m<${#Gmxs[@]};m++)); do
	    Gmx=${Gmxs[m]}
	    ${code_dir}/scripts/subst.s Gmx $Gmx,1,1 ${run_dir}/global.data
	    sbatch testrun_slurm.sh 
            sleep 4

            if [ $? != 0 ]; then
              echo "submiting jobs returned $?"
            else
              jobRunning=1
              jobQueue=0
              while [[ ${jobRunning} -ge 1 || ${jobQueue} -ge 1 ]]
              do
                jobRunning=`qstat | grep testRun | awk '{print $5}' |  grep "R" | wc | awk '{print $1}'`
                jobQueue=`qstat | grep testRun | awk '{print $5}' |  grep "Q" | wc | awk '{print $1}'`
                sleep 4
              done
            fi
	    grep dx MHDWaves.out | awk '{print $3, $4}' >> scaling_${interporder}_${j}.curve
	    mv out/data.curve data_${interporder}_${j}_${Gmx}.curve
            cat ${run_dir}/MHDWaves.out >> ${run_dir}/MHDWaves.log
	done
    done
done
mv data_*.curve testdata
mv scaling_*.curve testdata

