!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    problem.f90 of module MTI is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
MODULE Problem

  USE DataDeclarations
  USE GlobalDeclarations
  USE PhysicsDeclarations
  USE Refinements
  USE Shapes
 ! USE IFPORT
  IMPLICIT NONE
  PRIVATE
  
  PUBLIC ProblemModuleInit, ProblemGridInit, &
       ProblemBeforeStep, ProblemAfterStep, ProblemSetErrFlag, ProblemBeforeGlobalStep

  INTEGER :: nmodex, nmodey, bc
  REAL(KIND=qPrec) :: rho0, p0, y0, v0, B0, B_static, lx
  INTEGER, PARAMETER :: MTI_FILEHANDLE = 32
CONTAINS


  SUBROUTINE ProblemModuleInit
    !! @brief Reads the problem data file and performs a quick sanity check on the parameters.
    INTEGER :: iErr

		
  END SUBROUTINE ProblemModuleInit


  SUBROUTINE ProblemGridInit(Info)
	!! @brief Initializes the grid data according to the requirements of the problem.
	!! @param Info A grid structure.	
    TYPE (InfoDef) :: Info
    INTEGER :: i,j,k,iErr
    INTEGER :: rmbc,zrmbc
    INTEGER :: mx, my, mz
    REAL(KIND=qPrec) :: dx,rho,p,vy,pos(3)
    !NAMELIST /ProblemData/ rho0,rho1,r0,t0,t1,B0x,B0y
      
    rmbc = levels(Info%level)%gmbc(1)!CoarsenRatio(Info%level-1) * mbc

    IF(nDim==2)THEN
       zrmbc=0
    ELSE
       zrmbc=rmbc
    END IF

    Info%q=0d0;Info%aux=0d0
    mx=Info%mX(1); my=Info%mX(2); mz=Info%mX(3); dx=levels(Info%level)%dx

    pos=0d0; Info%q(:,:,:,:)=0d0
    DO k=1-zrmbc,mz+zrmbc; DO j=1-rmbc,my+rmbc; DO i=1-rmbc, mx+rmbc
       pos=Info%xBounds(1:3,1)+(/REAL(i,8)-1.,REAL(j,8)-1.,REAL(k,8)-1./)*levels(Info%level)%dx
       rho = rho0*(1d0-pos(2)/y0)**2
       p = p0*(1d0-pos(2)/y0)**3
       vy = v0*sin(real(nmodex)*pi*pos(1)/lx)
       Info%q(i,j,k,1) = rho
       Info%q(i,j,k,3) = rho*vy
       Info%q(i,j,k,iBx) = B0
       Info%q(i,j,k,iE) = p/(gamma-1d0)+0.5*rho*vy**2+0.5*B0**2
       
    END DO; END DO; END DO

    IF (MaintainAuxArrays) THEN
       DO i=1-rmbc+1,mx+rmbc; DO j=1-rmbc,my+rmbc; DO k=1-zrmbc,mz+zrmbc
         Info%aux(i,j,k,1)=.5*(Info%q(i-1,j,k,iBx)+Info%q(i,j,k,iBx))
       END DO; END DO; END DO
       DO i=1-rmbc,mx+rmbc; DO j=1-rmbc+1,my+rmbc; DO k=1-zrmbc,mz+zrmbc
         Info%aux(i,j,k,2)=.5*(Info%q(i,j-1,k,iBy)+Info%q(i,j,k,iBy))
       END DO; END DO; END DO
       IF(nDim==3)THEN
          DO i=1-rmbc,mx+rmbc; DO j=1-rmbc,my+rmbc; DO k=1-zrmbc+1,mz+zrmbc
             Info%aux(i,j,k,3)=.5*(Info%q(i,j,k-1,iBz)+Info%q(i,j,k,iBz))
          END DO; END DO; END DO
       END IF
    END IF

  END SUBROUTINE ProblemGridInit

  SUBROUTINE ProblemBeforeStep(Info)
	!! @brief Performs any tasks required before the advance step.
	!! @param Info A grid structure.	
    TYPE (InfoDef) :: Info
    INTEGER :: i,j
    INTEGER :: rmbc
    INTEGER :: mx,my
    INTEGER :: iErr

  END SUBROUTINE ProblemBeforeStep

  SUBROUTINE ProblemAfterStep(Info)
  	!! @brief Performs any post-step corrections that are required.
	!! @param Info A grid structure.	
    TYPE (InfoDef) :: Info
  END SUBROUTINE ProblemAfterStep

  SUBROUTINE ProblemSetErrFlag(Info)
  	!! @brief Sets error flags according to problem-specific conditions..
	!! @param Info A grid structure.	
    TYPE (InfoDef) :: Info
  END SUBROUTINE ProblemSetErrFlag

  SUBROUTINE ProblemBeforeGlobalStep(n)
    INTEGER :: n
  END SUBROUTINE ProblemBeforeGlobalStep

END MODULE Problem
