!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    problem.f90 of module OrbitingParticles is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
!> @dir OrbitingParticles
!! @brief Contains files necessary for the Orbiting Particles test problem

!> @file problem.f90
!! @brief Main file for module Problem

!> @defgroup OrbitingParticles Orbiting Particle Module
!! @brief Module for setting up orbiting particles
!! @ingroup Modules

!> Orbiting Particle Module
!! @ingroup OrbitingParticles
MODULE Problem
  USE DataDeclarations
  USE ParticleDeclarations
  USE Ambients
  IMPLICIT NONE
  SAVE
  PUBLIC ProblemModuleInit, ProblemGridInit, &
       ProblemBeforeStep, ProblemAfterStep, ProblemSetErrFlag, ProblemBeforeGlobalStep
CONTAINS

  !> Initializes module variables
   SUBROUTINE ProblemModuleInit()      
      INTEGER :: nParticles
!      INTEGER, PARAMETER :: MaxParticles=50
      REAL(KIND=qPREC) :: mass=0
      REAL(KIND=qPREC) :: xloc(3)
      REAL(KIND=qPREC) :: vel(3)
      TYPE(ParticleDef), POINTER :: Particle
      INTEGER :: i
      INTEGER :: ids(2)
      TYPE(AmbientDef), POINTER :: Ambient
      REAL(KIND=qPREC) :: rhoOut, pOut, vxOut, vyOut, vzOut, BxOut, ByOut, BzOut
      NAMELIST /AmbientData/ rhoOut, pOut, vxOut, vyOut, vzOut, BxOut, ByOut, BzOut
!      LOGICAL :: lRestart ! COMMENT!!!
      !INTEGER :: ids(MaxParticles)
      NAMELIST /ProblemData/ nParticles
      NAMELIST /ParticleData/ mass,xloc,vel
      NAMELIST /RestartData/ ids
      OPEN(UNIT=PROBLEM_DATA_HANDLE, FILE='problem.data', STATUS="OLD")
      READ(PROBLEM_DATA_HANDLE,NML=ProblemData)
      CALL CreateAmbient(Ambient)
      READ(PROBLEM_DATA_HANDLE,NML=AmbientData)
      Ambient%density=rhoOut
      Ambient%pressure=pOut
      Ambient%B(:)=(/BxOut, ByOut, BzOut/)
      Ambient%velocity(:)=(/vxOut, vyOut, vzOut/)
      
!      IF (nParticles > MaxParticles) THEN
!         PRINT*, 'need to increase MaxParticles in problem.f90'
!         STOP
!      END IF
!      IF (lRestart) THEN
!         CLOSE(PROBLEM_DATA_HANDLE)
!         OPEN(UNIT=PROBLEM_DATA_HANDLE, FILE='restart.data', STATUS="OLD")
!         READ(PROBLEM_DATA_HANDLE,NML=RestartData)         
!         CLOSE(PROBLEM_DATA_HANDLE)
!         DO i=1,nParticles
!   !         CALL FindParticle(Particle,id(i))
!            IF (.NOT. ASSOCIATED(Particle)) THEN
!               PRINT*, 'did not find particle in problem.f90'
!               STOP
!            END IF
!            CALL CreatePointGravityObject(Particle%PointGravityObj)
!            Particle%PointGravityObj%soft_length=Particle%radius*sink_dx
!            Particle%PointGravityObj%soft_function=SPLINESOFT
!            Particle%PointGravityObj%mass=Particle%mass
!         END DO
!      ELSE
       IF (.NOT. lRestart) THEN
         DO i=1,nParticles
            READ(PROBLEM_DATA_HANDLE,NML=ParticleData)
            NULLIFY(Particle)
            CALL CreateParticle(Particle)
            Particle%Q(1)=mass
            Particle%xloc=xloc
            Particle%Q(imom(1:nDim))=vel(1:nDim)
            CALL AddSinkParticle(Particle)
            !
            CALL CreatePointGravityObject(Particle%PointGravityObj)
            Particle%PointGravityObj%soft_length=Particle%radius*sink_dx
            Particle%PointGravityObj%soft_function=SPLINESOFT
            Particle%PointGravityObj%Mass=Particle%Q(1)
            Particle%PointGravityObj%v0(1:nDim)=Particle%Q(imom(1:nDim))
            Particle%PointGravityObj%x0=Particle%xloc
            IF (i.eq.2) THEN
               CALL CreateOutflowObject(Particle%OutflowObj)
               Particle%OutflowObj%duration    = 1.e30
               Particle%OutflowObj%radius      = 0.025d0
               Particle%OutflowObj%thickness   = 0.025d0
               Particle%OutflowObj%open_angle  = 1.57080 !pi/4
               Particle%OutflowObj%density     = 4d0*rhoOut !see modules.data
               Particle%OutflowObj%temperature = pOut/rhoOut
               Particle%OutflowObj%velocity    = 8.d0*abs(Particle%Q(imom(1)))*sqrt(2d0) !Escape velocity x 5
                                                !4.d0*abs(Particle%vel(1))*sqrt(2d0) !Escape velocity x 4
                                                !2.d0*abs(Particle%vel(1))*sqrt(2d0) !Escape velocity x 2
               Particle%OutflowObj%source_vel(1:nDim)  = Particle%Q(imom(1:nDim))
               Particle%OutflowObj%position        = Particle%xloc
               CALL UpdateOutflow(Particle%OutflowObj)
            END IF
         END DO
         CLOSE(PROBLEM_DATA_HANDLE)      
         OPEN(UNIT=PROBLEM_DATA_HANDLE, FILE='restart.data', STATUS="UNKNOWN")
         WRITE(PROBLEM_DATA_HANDLE,NML=RestartData)
         CLOSE(PROBLEM_DATA_HANDLE)
       END IF
!      END IF
   END SUBROUTINE ProblemModuleInit

  !> Applies initial conditions
  !! @param Info Info object
  SUBROUTINE ProblemGridInit(Info)
    TYPE(InfoDef) :: Info
  END SUBROUTINE ProblemGridInit

  !> Applies Boundary conditions
  !! @param Info Info object
  SUBROUTINE ProblemBeforeStep(Info)
    TYPE(InfoDef) :: Info
    INTEGER :: i
!    DO i=1,nWinds
!       CALL BeforeStepWind(Info,Wind(i))
!    END DO
  END SUBROUTINE ProblemBeforeStep

  !> Could be used to update grids pre-output
  !! @param Info Info Object
  SUBROUTINE ProblemAfterStep(Info)
    TYPE(InfoDef) :: Info
  END SUBROUTINE ProblemAfterStep

  !> Could be used to set force refinement
  !! @param Info Info object
  SUBROUTINE ProblemSetErrFlag(Info)
    TYPE(InfoDef) :: Info
  END SUBROUTINE ProblemSetErrFlag

  SUBROUTINE ProblemBeforeGlobalStep(n)
     INTEGER :: n
  END SUBROUTINE ProblemBeforeGlobalStep

END MODULE Problem

