#!/bin/bash
###############################################################################################
# Script name: ph2zformat.s
# Created:  01/23/2012 by Eddie Hansen
# Purpose:  Reformats PHcooling.tab which is Pat Hartigan's cooling table used for Z cooling.
#           Reformatted table is written to a file named Zcooling.tab.
# Notes:    This script assumes it is being run from the TABLES directory and that the file you
#           want to be reformatted is called PHcooling.tab (this could be changed in the future).
#           For more details see https://clover.pas.rochester.edu/trac/astrobear/wiki/zcooling
###############################################################################################

# Declare original file and new file names
ORIG_FILE=PHcooling.tab
NEW_FILE=Zcooling.tab

# Put nDensities, nTemps, nXs in NEW_FILE
awk '{print $1}' ${ORIG_FILE} | sort -u | wc -l > ${NEW_FILE}
awk '{print $2}' ${ORIG_FILE} | sort -u | wc -l >> ${NEW_FILE}
awk '{print $3}' ${ORIG_FILE} | sort -u | wc -l >> ${NEW_FILE}

# Put minimum and maximum values in NEW_FILE
awk '{print $1}' ${ORIG_FILE} | sort -n -r | tail -n 1 >> ${NEW_FILE}
awk '{print $1}' ${ORIG_FILE} | sort -n | tail -n 1 >> ${NEW_FILE}
awk '{print $2}' ${ORIG_FILE} | sort -n -r | tail -n 1 >> ${NEW_FILE}
awk '{print $2}' ${ORIG_FILE} | sort -n | tail -n 1 >> ${NEW_FILE}
awk '{print $3}' ${ORIG_FILE} | sort -n -r | tail -n 1 >> ${NEW_FILE}
awk '{print $3}' ${ORIG_FILE} | sort -n | tail -n 1 >> ${NEW_FILE}

# Resort cooling rates and put them in NEW_FILE
sort -n -k 3 -k 2 -k 1 ${ORIG_FILE} | awk '{print $13}' >> ${NEW_FILE}
