!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    problem.f90 of module RadiativeInstability0 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
!> @dir RadiativeInstability0
!! @brief Contains files necessary for module RadiativeInstability0

!> @file problem.f90
!! @brief Main file for module RadiativeInstability0

!> @defgroup RadiativeInstability0 RadiativeInstability0 Module
!! @brief Module for displaying a template across the grid
!! @ingroup Modules

!> Radiative Instability0 problem module
!! @ingroup RadiativeInstability0
MODULE Problem
  USE GlobalDeclarations
  USE PhysicsDeclarations
  USE DataDeclarations
  USE CoolingSrc
  IMPLICIT NONE
  PUBLIC ProblemModuleInit, ProblemGridInit, &
         ProblemBeforeStep, ProblemAfterStep, ProblemSetErrFlag, ProblemBeforeGlobalStep
  TYPE(CoolingDef),POINTER :: coolingobj

  INTEGER :: iCooling
  REAL(KIND=qPrec) :: vx, alpha, beta
  
  NAMELIST/problemdata/iCooling,vx,alpha,beta

CONTAINS

  !> Initializes module variables
  SUBROUTINE ProblemModuleInit()
    INTEGER :: i,edge
    REAL(KIND=qPrec) :: power, cs

    OPEN(PROBLEM_DATA_HANDLE,FILE='problem.data',STATUS='old')
    READ(PROBLEM_DATA_HANDLE,NML=problemdata)
    CLOSE(PROBLEM_DATA_HANDLE)

    IF(iCooling>0) THEN
       IF (.NOT. lRestart) THEN
           CALL CreateCoolingObject(coolingobj)
       ELSE
           coolingobj => firstcoolingobj
       END IF
    END IF

    coolingobj%iCooling=iCooling
    SELECT CASE(iCooling)
       CASE(NoCool)
       CASE(AnalyticCool)
         cs=sqrt(gamma*Boltzmann*TempScale/Xmu/hMass)
         power=.5d0*(1d0-2d0*beta)
         coolingobj%alpha=alpha*4.76e-20*&! (ergs*cm^3/s/K^.5)
                          (3d0/16d0*Xmu*hMass/Boltzmann*(cs*vx)**2)**(power)
         coolingobj%beta=beta
       CASE(DMCool)
       CASE(IICool)
       CASE DEFAULT
    END SELECT

    coolingobj%floortemp=1000
    coolingobj%mintemp=0.01
  END SUBROUTINE ProblemModuleInit

  !> Applies initial conditions
  !! @param Info Info object
  SUBROUTINE ProblemGridInit(Info)
    TYPE(InfoDef) :: Info
	 REAL (KIND=qPrec), POINTER, DIMENSION (:,:,:,:) :: q
    INTEGER :: i,j,k,rmbc,zrmbc,level,mx, my, mz
	 REAL(KIND=xprec) :: x,y,z,xl,yl,zl,dx,dy,dz,r
    REAL(KIND=qPrec) :: dens

    q=>Info%q
    q(:,:,:,:) = 0d0
    q(:,:,:,1) = 1d0 !dens/rScale
    q(:,:,:,2) = vx*sqrt(gamma*Boltzmann*TempScale/Xmu/hMass)/velScale!*q(:,:,:,1) < but q(:,:,:,1)=1
    q(:,:,:,iE)= 1d0/(gamma-1d0)+5d-1*q(:,:,:,2)**2!/q(:,:,:,1) < but q(:,:,:,1)=1
  END SUBROUTINE ProblemGridInit

  !> Applies Boundary conditions
  !! @param Info Info object
  SUBROUTINE ProblemBeforeStep(Info)
    TYPE(InfoDef) :: Info
    INTEGER :: i
  END SUBROUTINE ProblemBeforeStep

  !> Could be used to update grids pre-output
  !! @param Info Info Object
  SUBROUTINE ProblemAfterStep(Info)
    TYPE(InfoDef) :: Info
  END SUBROUTINE ProblemAfterStep

  !> Could be used to set force refinement
  !! @param Info Info object
  SUBROUTINE ProblemSetErrFlag(Info)
    TYPE(InfoDef) :: Info
    INTEGER :: i
    i=(GxBounds(1,2)-2*levels(0)%dx-Info%xBounds(1,1))/levels(Info%level)%dx
    IF (i <= Info%mX(1)) THEN
       Info%ErrFlag(max(i,1):Info%mX(1),:,:)=1
    END IF
  END SUBROUTINE ProblemSetErrFlag

  SUBROUTINE ProblemBeforeGlobalStep(n)
     INTEGER :: n
  END SUBROUTINE ProblemBeforeGlobalStep


END MODULE Problem

