#!/bin/bash
#SBATCH -J BondiTest
#SBATCH -N 1
#SBATCH -n 1 
#SBATCH -c 1 
#SBATCH -p debug 
#SBATCH -t 01:20:00

module purge
module load mpi-xl
module load hdf5-1.8.8-MPI-XL
module load fftw-3.3.2-MPI-XL
ulimit -s unlimited

if [ $# -gt 0 ]; then
  np=$1
fi

interporders=( 1 2 3 )
#charlimiters=( .true. .false. )
#lapplydiffusions=( .true. .false. )
#lLimiters=( .true. .false. )
iSolvers=( 1 2 3 )

mkdir out
mkdir testdata
for (( i=0;i<${#interporders[@]};i++)); do
    interporder=${interporders[i]}
    ../../scripts/subst.s InterpOrder  $interporder solver.data
    for (( m=0;m<${#iSolvers[@]};m++)); do
	iSolver=${iSolvers[m]}
	../../scripts/subst.s iSolver $iSolver solver.data
	dir=out_${interporder}_${iSolver}
 	srun ../../astrobear
	mv out/data.curve data_${interporder}_${iSolver}.curve
    done
done
mv data_*.curve testdata
