#!/bin/bash

code_dir=/scratch/bliu17/Bear2BTest
run_dir=/scratch/bliu17/bearTest

rm ${run_dir}/testrun_slurm.sh
rm ${run_dir}/scaling_*_*.curve
rm ${run_dir}/SodShockTube.out

cat >> ${run_dir}/testrun_slurm.sh <<EOF
#!/bin/bash
#SBATCH -J testRun
#SBATCH -N 1
#SBATCH -n 1
#SBATCH -c 1 
#SBATCH -p debug 
#SBATCH -t 00:30:00

module purge
module load mpi-xl
module load hdf5-1.8.8-MPI-XL 
module load fftw-3.3.2-MPI-XL
module load hypre-2.8.0b-MPI-XL

ulimit -s unlimited
srun /scratch/bliu17/bearTest/astrobear >> SodShockTube.log 
EOF

#if [ $# -gt 0 ]; then
#  np=$1
#fi

interporders=( 1 2 3 )
#charlimiters=( .true. .false. )
#lapplydiffusions=( .true. .false. )
#lLimiters=( .true. .false. )
iSolvers=( 1 2 3 )

cp /scratch/bliu17/Bear2BTest/modules/SodShockTube/exact.curve /scratch/bliu17/bearTest/testdata

for (( i=0;i<${#interporders[@]};i++)); do
    interporder=${interporders[i]}
    ${code_dir}/scripts/subst.s InterpOrder  $interporder ${run_dir}/solver.data
    for (( m=0;m<${#iSolvers[@]};m++)); do
	iSolver=${iSolvers[m]}
        ${code_dir}/scripts/subst.s iSolver $iSolver ${run_dir}/solver.data
	dir=out_${interporder}_${iSolver}
        sbatch testrun_slurm.sh	
        sleep 4

        if [ $? != 0 ]; then
          echo "submiting jobs returned $?"
        else
          jobRunning=1
          jobQueue=0
          while [[ ${jobRunning} -ge 1 || ${jobQueue} -ge 1 ]]
          do
            jobRunning=`qstat | grep testRun | awk '{print $5}' |  grep "R" | wc | awk '{print $1}'`
            jobQueue=`qstat | grep testRun | awk '{print $5}' |  grep "Q" | wc | awk '{print $1}'`
          sleep 4
          done
         fi
         
	mv out/data.curve data_${interporder}_${iSolver}.curve
    done
done
mv data_*.curve testdata

