!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    problem.f90 of module jets is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
!> @dir OrbitingParticles
!! @brief Contains files necessary for the Orbiting Particles test problem

!> @file problem.f90
!! @brief Main file for module Problem

!> @defgroup OrbitingParticles Orbiting Particle Module
!! @brief Module for setting up orbiting particles
!! @ingroup Modules

!> Orbiting Particle Module
!! @ingroup OrbitingParticles
MODULE Problem
  USE DataDeclarations
  USE ParticleDeclarations
  USE CoolingSrc
  USE SourceDeclarations
  USE Projections !n
  USE Fields !n
  USE Refinements
  USE Shapes
  IMPLICIT NONE
  SAVE
  PUBLIC ProblemModuleInit, ProblemGridInit, &
       ProblemBeforeStep, ProblemAfterStep, ProblemSetErrFlag, ProblemBeforeGlobalStep
  INTEGER :: nParticles,itracer2,iProp
  REAL(KIND=qPREC) :: namb, njet, tamb, Rjet, tjet, vjet,torusalpha,torusbeta
  LOGICAL :: lCooling, jet, rings, stratified, anotherClump=.false.,torus,lform
  TYPE(CoolingDef),POINTER :: coolingobj

CONTAINS

  !> Initializes module variables
   SUBROUTINE ProblemModuleInit()      
!     INTEGER, PARAMETER :: MaxParticles=50

![6fecb12	 
!     TYPE(InfoDef) :: Info
!     INTEGER :: i,j,k,l,m,ii,jj,kk
!     INTEGER :: rmbc,zrmbc,level
!     INTEGER :: mx, my, mz
!     REAL (KIND=qPrec), POINTER, DIMENSION (:,:,:,:)     :: q
!     REAL(KIND=xprec) :: x,y,z,xl,yl,zl,dx,dy,dz,r,r2
!]6feb12
      REAL(KIND=qPREC) :: mass=0
      REAL(KIND=qPREC) :: xloc(3),buff(17)
      REAL(KIND=qPREC) :: vel(3)
      TYPE(ParticleDef), POINTER :: Particle, RefParticle
      INTEGER :: i
      INTEGER :: ids(2)
      TYPE(ProjectionDef), POINTER :: Projection
!     TYPE(AmbientDef), POINTER :: Ambient
!     REAL(KIND=qPREC) :: rhoOut, pOut, vxOut, vyOut, vzOut, BxOut, ByOut, BzOut
      TYPE(RefinementDef), POINTER :: Refinement
      REAL(KIND=qPREC) :: d(3), vshape
!     NAMELIST /AmbientData/ rhoOut, pOut, vxOut, vyOut, vzOut, BxOut, ByOut, BzOut
      NAMELIST /ProblemData/ nParticles, jet, namb, njet, tamb, Rjet, &
		                                tjet, vjet, lCooling, rings, stratified,anotherClump,torus,torusalpha,torusbeta
      NAMELIST /ParticleData/ mass,xloc,vel,buff
      NAMELIST /RestartData/ ids
      OPEN(UNIT=PROBLEM_DATA_HANDLE, FILE='problem.data', STATUS="OLD")
      READ(PROBLEM_DATA_HANDLE,NML=ProblemData)

     CALL AddTracer(itracer2, 'Clump tracer')
     !CALL CreateAmbient(Ambient)
     !READ(PROBLEM_DATA_HANDLE,NML=AmbientData)
     !Ambient%density=rhoOut
     !Ambient%pressure=pOut
     !Ambient%B(:)=(/BxOut, ByOut, BzOut/)
     !Ambient%v(:)=(/vxOut, vyOut, vzOut/)
      
!
!!!16mar'12
!CALL CreateProjection(Projection)
!  Projection%Field%id=CoolingStrength_Field
!  Projection%Field%component=GASCOMP
!  Projection%Field%name='Cooling_integrated_emiss'
!  Projection%dim=3d0
!!!
!


       IF (.NOT. lRestart) THEN
         DO i=1,nParticles
            READ(PROBLEM_DATA_HANDLE,NML=ParticleData)
            NULLIFY(Particle)
            CALL CreateParticle(Particle)
            Particle%Q(1)=mass
            Particle%xloc=xloc
            Particle%Q(imom(1:nDim))=vel(1:nDim)/velscale
            if (maxval(buff).ne.0) Particle%Buffer=buff
            CALL AddSinkParticle(Particle)
         END DO
         CLOSE(PROBLEM_DATA_HANDLE)      
         OPEN(UNIT=PROBLEM_DATA_HANDLE, FILE='restart.data', STATUS="UNKNOWN")
         WRITE(PROBLEM_DATA_HANDLE,NML=RestartData)
         CLOSE(PROBLEM_DATA_HANDLE)
       END IF

      IF (lCooling) THEN
         IF (.NOT. lRestart) THEN
            CALL CreateCoolingObject(coolingobj)
         ELSE
            coolingobj => firstcoolingobj
         END IF
         coolingobj%iCooling=DMCool
         coolingobj%floortemp=100d0 !K
         coolingobj%mintemp=1d0    !K
      END IF

      vshape = half*vjet/VelScale
      CALL CreateRefinement(Refinement)
      CALL CreateShape(Refinement%Shape)
      IF(iCylindrical/=0) THEN
         iProp = 3       ! cylindrical run, jet propagates in cylindrical z-direction
         d = (/ 3d0, 2d0, 3d0 /)
         Refinement%Shape%velocity=(/ 0d0, vshape, 0d0 /)
         Refinement%Shape%Position = (/ 0d0, -1d0, 3d0 /)
      ELSE
         iProp = 2       ! cartesian run, jet propagates in cartesian x-direction
         d = (/ 2d0, 3d0, 3d0 /)
         Refinement%Shape%velocity=(/ vshape, 0d0, 0d0 /)
         Refinement%Shape%Position = (/ -1d0, 3d0, 3d0 /)
      END IF
      CALL SetShapeType(Refinement%Shape, RECTANGULAR_PRISM, d)
      CALL SetShapeBounds(Refinement%Shape)
      Refinement%BufferCells = 4
      Refinement%field = Mass_Field

      CALL AddDiagnosticVar(MPI_ID_FIELD)
      CALL AddDiagnosticVar(ErrFlag_Field)
   END SUBROUTINE ProblemModuleInit

  !> Applies initial conditions
  !! @param Info Info object
  SUBROUTINE ProblemGridInit(Info)
    TYPE(InfoDef) :: Info
   INTEGER :: i,j,k,l,m,ii,jj,kk
	INTEGER :: rmbc,zrmbc,level
	INTEGER :: mx, my, mz
	INTEGER :: iErr
    REAL (KIND=qPrec), POINTER, DIMENSION (:,:,:,:)     :: q
    REAL(KIND=xprec) :: x,y,z,xl,yl,zl,dx,dy,dz,r,r2,dr,dt,r3,torus2,cos2theta,ex1,ex2,Ftheta
    REAL(KIND=xprec), PARAMETER :: tt=0.006945d0 !time_final/200

IF (lRestart) RETURN
	
   level=Info%level
   q=>Info%q
	! Calculating the number of ghost cells on each side of the grid.
   rmbc=levels(level)%gmbc(levels(level)%step)
   mx = Info%mX(1)
   my = Info%mX(2)
   mz = Info%mX(3)
   dx=levels(level)%dX
   dy=dx
   dz=dx
   zrmbc=rmbc
   xl=Info%xBounds(1,1)
   yl=Info%xBounds(2,1)
   zl=Info%xBounds(3,1)
   dt=levels(level)%dt
!---------

   q(:,:,:,itracer2)=0d0

   IF(nDim==2) THEN
      zrmbc = 0
      dz = 0d0
   END IF

   DO i=1-rmbc, mx+rmbc         ; x = (xl+(REAL(i,xPrec)-half)*dx)
      DO j=1-rmbc, my+rmbc      ; y = (yl+(REAL(j,xPrec)-half)*dy)  
         DO k=1-zrmbc, mz+zrmbc ; z = (zl+(REAL(k,xPrec)-half)*dz)
            r = SQRT( x**2 + y**2 + z**2 )               ! from origin
            r2 = SQRT( (x-2d0*Rjet)**2 + y**2 + z**2 )   ! from clump center
            dr = SQRT( dx**2 + dy**2 + dz**2 )
                      
            IF(iCylindrical/=0) r2 = SQRT( x**2 + (y-2d0*Rjet)**2 + z**2 )
            IF (.NOT. jet) r = r2     ! b4 27jan'12

            !A M B I E N T 
            q(i,j,k,1) = namb/nScale     ! density

 	    torus2 = 1d0
            IF (torus) THEN
	       IF (r == 0d0 .OR. (x-2d0*Rjet) == 0d0) THEN
		  PRINT*,'torus error';stop
	       ELSE
	          cos2theta = 2d0*ACOS((x-2d0*Rjet)/r)        !----------------------------B
		  IF (jet) cos2theta = 2d0*ACOS((x-0d0*Rjet)/r)
	       END IF
               ex1 = -2d0*torusbeta
               ex2 = torusbeta*COS(cos2theta)-torusbeta       !----------------------------B
               Ftheta = 1d0-( torusalpha*(dexp(ex2)-1d0)/(dexp(ex1)-1d0) )
	       torus2 = 1d0/Ftheta
            END IF
	    q(i,j,k,1) = q(i,j,k,1)*torus2

	    IF (stratified) THEN    !27jan'12
	       IF (jet) THEN
		  q(i,j,k,1) = q(i,j,k,1) / (r + 1d0 + .25d0*dr)**2
	       ELSE
                  IF (r > Rjet) q(i,j,k,1) = q(i,j,k,1) / (r-Rjet + 1d0 + .25d0*dr)**2
	       END IF
	    END IF

	    IF (rings) q(i,j,k,1) = q(i,j,k,1)*&
		              	    ( 2d0*(exp(-(2d0*(r- 2d0/1.5d0))**2)+&
            			           exp(-(2d0*(r- 6d0/1.5d0))**2)+&
		                           exp(-(2d0*(r-10d0/1.5d0))**2)+&
				           exp(-(2d0*(r-14d0/1.5d0))**2)+&
				           exp(-(2d0*(r-18d0/1.5d0))**2)+&
				           exp(-(2d0*(r-22d0/1.5d0))**2)+&
				           exp(-(2d0*(r-26d0/1.5d0))**2)+&
			                   exp(-(2d0*(r-30d0/1.5d0))**2)+&
				           exp(-(2d0*(r-34d0/1.5d0))**2)+&
					   exp(-(2d0*(r-38d0/1.5d0))**2)+&
	                                   exp(-(2d0*(r-42d0/1.5d0))**2)+&
				           exp(-(2d0*(r-46d0/1.5d0))**2)+&
				           exp(-(2d0*(r-50d0/1.5d0))**2)+&
			                   exp(-(2d0*(r-54d0/1.5d0))**2)+&
					   exp(-(2d0*(r-58d0/1.5d0))**2)+&
					   exp(-(2d0*(r-62d0/1.5d0))**2)+&
					   exp(-(2d0*(r-66d0/1.5d0))**2)+&
				           exp(-(2d0*(r-70d0/1.5d0))**2)+&
					   exp(-(2d0*(r-74d0/1.5d0))**2)+&
					   exp(-(2d0*(r-78d0/1.5d0))**2)+&
					   exp(-(2d0*(r-82d0/1.5d0))**2)+&
				           exp(-(2d0*(r-86d0/1.5d0))**2)+&
					   exp(-(2d0*(r-90d0/1.5d0))**2)+&
					   exp(-(2d0*(r-94d0/1.5d0))**2)+&
					   exp(-(2d0*(r-98d0/1.5d0))**2)+&
					   exp(-(2d0*(r-102d0/1.5d0))**2)+&
					   exp(-(2d0*(r-106d0/1.5d0))**2)+&
					   exp(-(2d0*(r-110d0/1.5d0))**2)+&
					   exp(-(2d0*(r-114d0/1.5d0))**2)+&
					   exp(-(2d0*(r-118d0/1.5d0))**2)+&
					   exp(-(2d0*(r-122d0/1.5d0))**2)+&
					   exp(-(2d0*(r-126d0/1.5d0))**2)+&
					   exp(-(2d0*(r-130d0/1.5d0))**2)+&
					   exp(-(2d0*(r-134d0/1.5d0))**2)+&
					   exp(-(2d0*(r-138d0/1.5d0))**2)+&
					   exp(-(2d0*(r-142d0/1.5d0))**2)+&
					   exp(-(2d0*(r-146d0/1.5d0))**2)+&
					   exp(-(2d0*(r-150d0/1.5d0))**2)+&
				 	   .5d0) )

            q(i,j,k,2:m_high) = 0d0       ! momenta=number density*v
            q(i,j,k,iE) = q(i,j,k,1)*tamb/TempScale/gamma1    ! specific internal energy
            q(i,j,k,itracer2) = GetCoolingStrength(q(i,j,k,:),lform)*pScale/TimeScale   ! erg/cc/s

            IF (jet) THEN
               IF(iCylindrical/=0) THEN
                  IF (y > dy) CYCLE
                  r = DSQRT( x**2 + z**2)
               ELSE
                  IF (x > dx) CYCLE
                  r = DSQRT( y**2 + z**2 )
               END IF
               IF (r <= Rjet) THEN
                  q(i,j,k,1) = njet/nscale ![cu]
                  q(i,j,k,iProp) = vjet/500d0*q(i,j,k,1)/velScale*(1d0-.1d0*(r/Rjet)**2)
                  q(i,j,k,iE) = q(i,j,k,1)*tjet/TempScale/gamma1 + &    ! internal enegy [cu]
 			        half*SUM(q(i,j,k,2:m_high)**2)/q(i,j,k,1)    ! kinetic energy
               END IF   ! r < Rjet
	    ELSE
               IF (r2 <= Rjet) THEN
                  q(i,j,k,1) = nAmb/nScale + njet/nscale*(1d0-(r2/Rjet)**2)   ! [cu] !27jul11
                  q(i,j,k,iProp) = vjet*q(i,j,k,1)/velscale ![cu]
                  q(i,j,k,iE) = q(i,j,k,1)*tjet/TempScale/gamma1 + &    ! internal enegy     [cu]
	                        half*SUM(q(i,j,k,2:m_high)**2)/q(i,j,k,1)    ! kinetic energy
               END IF  ! r < Rjet
	    END IF  ! jet/clump
         END DO
      END DO
   END DO	
  END SUBROUTINE ProblemGridInit

  !> Applies Boundary conditions
  !! @param Info Info object
  SUBROUTINE ProblemBeforeStep(Info)
   TYPE(InfoDef) :: Info
   REAL (KIND=qPrec), POINTER, DIMENSION (:,:,:,:)     :: q
   INTEGER :: i,j,k,ii,jj,kk,mx,my,mz,rmbc,zrmbc,level,iErr
   REAL(KIND=xprec) :: x,y,z,xl,yl,zl,dx,dy,dz,time, r, dt, dr,velFactor,torus2,cos2theta,ex1,ex2,Ftheta
   REAL(KIND=xprec), PARAMETER :: tt=0.006945d0 !time_final/200

  level=Info%level
  dt=levels(level)%dt
  time=levels(level)%tnow
  if (time.eq.dt) return 
     !we don't want to overwrite the initial conditions
     !and for the clump case we don't want to use this routine

  q=>Info%q
  !Calculating the number of ghost cells on each side of the grid.
   rmbc=levels(level)%gmbc(levels(level)%step)
	mx = Info%mX(1)
	my = Info%mX(2)
	mz = Info%mX(3)
  dx=levels(level)%dX
  dy=dx
  dz=dx
  zrmbc=rmbc
  xl=Info%xBounds(1,1)
  yl=Info%xBounds(2,1)
  zl=Info%xBounds(3,1)

  IF (nDim == 2) THEN
     zrmbc = 0
     dz = 0d0
  END IF

!emission
   DO i=1-rmbc, mx+rmbc ; DO j=1-rmbc, my+rmbc ; DO k=1-zrmbc, mz+zrmbc
      q(i,j,k,itracer2) = GetCoolingStrength(q(i,j,k,:),lform)
   END DO;END DO;END DO
!!!

   IF (.NOT. jet) RETURN
   DO i=1-rmbc, mx+rmbc
      x = (xl+(REAL(i,xPrec)-half)*dx)

      ! ONLY DO THE FOLLOWING INSIDE THE -Z BOUNDARY:
      IF (iCylindrical==0 .AND. x > 0d0) CYCLE
		
         DO j=1-rmbc, my+rmbc 
            y = (yl+(REAL(j,xPrec)-half)*dy)
            IF (iCylindrical/=0 .AND. y > 0d0) CYCLE
	    DO k=1-zrmbc, mz+zrmbc 
               z = (zl+(REAL(k,xPrec)-half)*dz)
               
               IF(iCylindrical/=0) y = x   ! cylindrical run changes symmetry axis

               !A M B I E N T 
               r =SQRT( y**2 + z**2 )
               dr =SQRT( dy**2 + dz**2 )
               q(i,j,k,1) = namb/nScale !density

!
!!! TORUS
!From Frnak & Mellema, 1994ApJ...430..800F:
!produced a pole-to-equator density contrast
   torus2 = 1d0
   IF (torus) THEN
      IF (r == 0d0) THEN
         PRINT*,'torus error';stop
      ELSE
         cos2theta = 2d0*ACOS(x/r)
      END IF
      ex1 = -2d0*torusbeta
      ex2 = torusbeta*COS(cos2theta)-torusbeta
      Ftheta = 1d0-( torusalpha*(dexp(ex2)-1d0)/(dexp(ex1)-1d0) )
      torus2 = 1d0/Ftheta
   END IF
   q(i,j,k,1) = q(i,j,k,1)*torus2
!!!
!

   IF (stratified) q(i,j,k,1) = q(i,j,k,1) / (r + 1d0 + .5d0*dr)**2   ! 12 jul '11
   q(i,j,k,2:m_high) = 0d0
   q(i,j,k,iE) = q(i,j,k,1)*tamb/TempScale/gamma1 !specific internal energy

   IF (r <= Rjet) THEN
      q(i,j,k,1) = njet/nscale ![cu]
!     q(i,j,k,itracer2) = q(i,j,k,1) !tracer

      ! ramps up the jet vel:
      IF (time <= 0.0001d0) THEN
         velFactor = 1d0/500d0
      ELSE IF (time > 0.0001d0 .AND. time < tt) THEN
	 velFactor = (1d0-1d0/500d0)/(tt-0.0001d0)*(time-0.0001d0)+1d0/500d0
      ELSE
         velFactor = 1d0
      END IF
      q(i,j,k,iProp) = vjet*q(i,j,k,1)/velScale*(1d0 - .1d0*(r/Rjet)**2)*velFactor
      q(i,j,k,iE) = q(i,j,k,1)*tjet/TempScale/gamma1 + &        ! internal enegy [cu]
		    half*SUM(q(i,j,k,2:m_high)**2)/q(i,j,k,1)   ! kinetic energy
      END IF  ! r < Rjet

   END DO ; END DO ; END DO

  END SUBROUTINE ProblemBeforeStep

  !> Could be used to update grids pre-output
  !! @param Info Info Object
  SUBROUTINE ProblemAfterStep(Info)
    TYPE(InfoDef) :: Info
  END SUBROUTINE ProblemAfterStep

  !> Could be used to set force refinement
  !! @param Info Info object
  SUBROUTINE ProblemSetErrFlag(Info)
     TYPE(InfoDef) :: Info
     REAL (KIND=qPrec), POINTER, DIMENSION (:,:,:,:) :: q
     INTEGER :: i,j,k,mx,my,mz,rmbc,zrmbc,level
     REAL(KIND=xprec) :: x,y,z,xl,yl,zl,dx,dy,dz

!     IF(.NOT. jet) RETURN
!     q=>Info%q
!     level=Info%level
!      rmbc=levels(level)%gmbc(levels(level)%step)
!      SELECT CASE(nDim)
!      CASE(2)
!         zrmbc=0
!      CASE(3)
!         zrmbc=rmbc
!      END SELECT
!     mx = Info%mX(1)
!     my = Info%mX(2)
!     mz = Info%mX(3)
!     dx=levels(level)%dX
!     dy=dx;dz=dx
!      xl=Info%xBounds(1,1)
!      yl=Info%xBounds(2,1)
!      zl=Info%xBounds(3,1) 

!	DO i=1, mx ; x = (xl+(REAL(i,xPrec)-half)*dx)
!	   if (x>2d0*dx) cycle
!      DO k=1,mz ; z = (zl+(REAL(k,xPrec)-half)*dz) 
!					    if (sqrt(z**2).gt.Rjet*1.15d0) cycle
!            DO j=1, my ; y = (yl+(REAL(j,xPrec)-half)*dy)
!					    if (sqrt(y**2+z**2).lt.Rjet*1.15d0) Info%ErrFlag(i,j,k)=1
!      END DO; END DO; END DO

     IF (nDim == 2) THEN
        IF (vjet/VelScale * levels(Info%level)%tnow <= 2d0*levels(0)%dx) THEN
           i=min(Info%mX(1),ceiling((Rjet-Info%xBounds(1,1))/levels(info%level)%dx))
           j=min(Info%mX(2),ceiling((vjet/VelScale * levels(Info%level)%tnow+levels(Info%level)%dx - Info%xBounds(2,1))/levels(Info%level)%dx))
           IF (i >= 1 .AND. j >= 1) Info%ErrFlag(1:i,1:j,1)=1
        END IF
     END IF
        

  END SUBROUTINE ProblemSetErrFlag

  SUBROUTINE ProblemBeforeGlobalStep(n)
     INTEGER :: n
  END SUBROUTINE ProblemBeforeGlobalStep

END MODULE Problem

