!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    objects.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
MODULE ObjectControl
  USE Ambients
  USE Clumps
  USE CollidingFlows
  USE Disks
  USE Outflows
  USE Refinements
  USE Splitregions
  USE Uniformregions
  USE Winds
  USE ObjectDeclarations

  IMPLICIT NONE

CONTAINS


  SUBROUTINE ObjectsGridInit(Info,type)
    TYPE(ObjectDef), POINTER :: Object
    TYPE (InfoDef) :: Info  
    INTEGER, OPTIONAL :: type
    Object => ListHead
    !write(*,*) "traversing...."
    DO WHILE(ASSOCIATED(Object))
       IF (PRESENT(TYPE)) THEN
          IF (Object%type == TYPE) CALL ObjectGridInit(Info, Object)
       ELSE
          CALL ObjectGridInit(Info, Object)
       END IF
       Object => Object%next
    END DO
  END SUBROUTINE ObjectsGridInit

  SUBROUTINE ObjectGridInit(Info,Object)
    TYPE(ObjectDef), POINTER :: Object
    TYPE (InfoDef) :: Info 

    SELECT CASE (Object%type)
    CASE (AMBIENTOBJ)
       pAmbient = transfer(Object%storage,pAmbient)
       CALL AmbientGridInit(Info, pAmbient%ptr)
    CASE (CLUMPOBJ)
       pClump = transfer(Object%storage,pClump)
       CALL ClumpGridInit(Info,pClump%ptr)
    CASE (COLLIDINGFLOWOBJ)
       pCollidingFlow = transfer(Object%storage,pCollidingFlow)
       CALL CollidingFlowGridInit(Info, pCollidingFlow%ptr)
    CASE (DISKOBJ)
       pDisk = transfer(Object%storage,pDisk)
       CALL DiskGridInit(Info, pDisk%ptr)
    CASE (SPLITREGIONOBJ)
       pSplitRegion = transfer(Object%storage,pSplitRegion)
       CALL SplitRegionGridInit(Info, pSplitRegion%ptr)
    CASE (UNIFORMREGIONOBJ)
       pUniformRegion = transfer(Object%storage,pUniformRegion)
       CALL UniformRegionGridInit(Info, pUniformRegion%ptr)
    CASE (OUTFLOWOBJ)
       pOutflow = transfer(Object%storage,pOutflow)
       CALL OutflowGridInit(Info, pOutflow%ptr)
    CASE (WINDOBJ)
       pWind = transfer(Object%storage,pWind)
       CALL WindGridInit(Info,pWind%ptr)
    END SELECT

  END SUBROUTINE ObjectGridInit

  SUBROUTINE ObjectsSetErrFlag(Info, type)
    TYPE (InfoDef) :: Info
    TYPE(ObjectDef), POINTER :: Object
    INTEGER, OPTIONAL :: type
    Object => ListHead
    DO WHILE(ASSOCIATED(Object))
       IF (PRESENT(type)) THEN
          IF (Object%type == TYPE) CALL ObjectSetErrFlag(Info, Object)
       ELSE
          CALL ObjectSetErrFlag(Info, Object)
       ENDIF
       Object => Object%next
    END DO
  END SUBROUTINE ObjectsSetErrFlag


  SUBROUTINE ObjectSetErrFlag(Info, Object)
    TYPE(ObjectDef), POINTER :: Object
    TYPE (InfoDef) :: Info  

    SELECT CASE (Object%type)
    CASE (AMBIENTOBJ)
       pAmbient = transfer(Object%storage,pAmbient)
       CALL AmbientSetErrFlag(Info, pAmbient%ptr)
    CASE (CLUMPOBJ)
       pClump = transfer(Object%storage,pClump)
       CALL ClumpSetErrFlag(Info,pClump%ptr)
    CASE (COLLIDINGFLOWOBJ)
       pCollidingFlow = transfer(Object%storage,pCollidingFlow)
       CALL CollidingFlowSetErrFlag(Info, pCollidingFlow%ptr)
    CASE (DISKOBJ)
       pDisk = transfer(Object%storage,pDisk)
       CALL DiskSetErrFlag(Info, pDisk%ptr)
    CASE (SPLITREGIONOBJ)
       pSplitRegion = transfer(Object%storage,pSplitRegion)
       CALL SplitRegionSetErrFlag(Info, pSplitRegion%ptr)
    CASE (UNIFORMREGIONOBJ)
       pUniformRegion = transfer(Object%storage,pUniformRegion)
       CALL UniformRegionSetErrFlag(Info, pUniformRegion%ptr)
    CASE (OUTFLOWOBJ)
       pOutflow = transfer(Object%storage,pOutflow)
       CALL OutflowSetErrFlag(Info, pOutflow%ptr)
    CASE (WINDOBJ)
       pWind = transfer(Object%storage,pWind)
       CALL WindSetErrFlag(Info,pWind%ptr)
    CASE (REFINEMENTOBJ)
       pRefinement = transfer(Object%storage,pRefinement)
       CALL RefinementSetErrFlag(Info,pRefinement%ptr)       
    END SELECT

  END SUBROUTINE ObjectSetErrFlag


  SUBROUTINE ObjectsBeforeStep(Info,type)
    TYPE(ObjectDef), POINTER :: Object
    TYPE (InfoDef) :: Info  
    INTEGER, OPTIONAL ::  type
    Object => ListHead
    !write(*,*) "traversing...."
    DO WHILE(ASSOCIATED(Object))
       IF (PRESENT(type)) THEN
          IF (Object%type == TYPE) CALL ObjectBeforeStep(Info, Object)
       ELSE
          CALL ObjectBeforeStep(Info, Object)
       END IF
       Object => Object%next
    END DO
  END SUBROUTINE ObjectsBeforeStep


  SUBROUTINE ObjectBeforeStep(Info, Object)
    TYPE(ObjectDef), POINTER :: Object
    TYPE (InfoDef) :: Info  
    SELECT CASE (Object%type)
    CASE (AMBIENTOBJ)
       pAmbient = transfer(Object%storage,pAmbient)
       CALL AmbientBeforeStep(Info, pAmbient%ptr)
    CASE (CLUMPOBJ)
       pClump = transfer(Object%storage,pClump)
       CALL ClumpBeforeStep(Info, pClump%ptr)
    CASE (COLLIDINGFLOWOBJ)
       pCollidingFlow = transfer(Object%storage,pCollidingFlow)
       CALL CollidingFlowBeforeStep(Info, pCollidingFlow%ptr)
    CASE (DISKOBJ)
       pDisk = transfer(Object%storage,pDisk)
       CALL DiskBeforeStep(Info, pDisk%ptr)
    CASE (SPLITREGIONOBJ)
       pSplitRegion = transfer(Object%storage,pSplitRegion)
       CALL SplitRegionBeforeStep(Info, pSplitRegion%ptr)
    CASE (UNIFORMREGIONOBJ)
       pUniformRegion = transfer(Object%storage,pUniformRegion)
       CALL UniformRegionBeforeStep(Info, pUniformRegion%ptr)
    CASE (OUTFLOWOBJ)
       pOutflow = transfer(Object%storage,pOutflow)
       CALL OutflowBeforeStep(Info, pOutflow%ptr)
    CASE (WINDOBJ)
       pWind = transfer(Object%storage,pWind)
       CALL WindBeforeStep(Info, pWind%ptr)
    END SELECT

  END SUBROUTINE ObjectBeforeStep

END MODULE ObjectControl
