!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    object_declarations.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
MODULE ObjectDeclarations
   IMPLICIT NONE

   INTEGER, PARAMETER :: AMBIENTOBJ = 0, DISKOBJ = 1, CLUMPOBJ = 2, COLLIDINGFLOWOBJ = 3, &
        REFINEMENTOBJ = 4, SHAPEOBJ = 5, SPLITREGIONOBJ = 6, &
        UNIFORMREGIONOBJ = 7, PERTURBOBJ = 8, VECTORPERTURBOBJ = 9, &
        OUTFLOWOBJ = 10, WINDOBJ = 11

   TYPE ObjectDef
      INTEGER :: type, id
      CHARACTER(len=1), DIMENSION(:), ALLOCATABLE :: storage
      TYPE (ObjectDef), POINTER :: prev => null()
      TYPE (ObjectDef), POINTER :: next => null()
   END TYPE ObjectDef

   TYPE (ObjectDef), POINTER :: ListHead => null()
   TYPE (ObjectDef), POINTER :: ListTail => null()

   INTEGER :: len
   CHARACTER(LEN=1) :: dummy_char(10)

   SAVE

CONTAINS

   FUNCTION ObjectListAdd(Object, type)
      TYPE(ObjectDef), POINTER :: Object
      INTEGER :: type, ObjectListAdd
      ALLOCATE(Object)
      Object%type = type
      !write(*,*) "ADDING OBJ", Object%type
      IF (.NOT.ASSOCIATED(ListHead)) THEN
         ListHead => Object
         ListTail => Object
         ObjectListAdd = 0
      ELSE
    	 ListTail%next => Object
         Object%prev => ListTail
         ListTail => Object
         Object%id = Object%prev%id + 1
         ObjectListAdd = Object%id
      END IF
   END FUNCTION ObjectListAdd

   SUBROUTINE ObjectListRemove(id)
      TYPE(ObjectDef), POINTER :: Object
      INTEGER :: id
      !write(*,*) "removing... ", id
      Object => ListHead
      DO WHILE(ASSOCIATED(Object))
         IF (Object%id == id) THEN
            IF(ASSOCIATED(Object%prev)) THEN
               Object%prev%next => Object%next
            ELSE
               ListHead => Object%next
            END IF

            IF(ASSOCIATED(Object%next)) THEN
               Object%next%prev => Object%prev
            ELSE
               ListTail => null()
            END IF
            DEALLOCATE(Object%storage)
            DEALLOCATE(Object)
            EXIT
         END IF
         Object => Object%next
      END DO
   END SUBROUTINE ObjectListRemove

   FUNCTION ObjectListFind(id)
      TYPE(ObjectDef), POINTER :: ObjectListFind, Object
      INTEGER :: id
      Object => ListHead
      DO WHILE(ASSOCIATED(Object))
         IF (Object%id == id) THEN
            ObjectListFind => Object
            RETURN
         END IF
         Object => Object%next
      END DO
      ObjectListFind => null()
   END FUNCTION ObjectListFind

END MODULE ObjectDeclarations
