!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    particle_level_ops.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
!> @file particle_level_ops.f90
!! @brief Main file for module ParticleLevelOps

!> @defgroup ParticleLevelOps Particle Level Ops
!! @brief Module containing particle operations for level structures
!! @ingroup Particles

!> Module containing particle operations for level structures
!! @ingroup ParticleLevelOps
MODULE ParticleLevelOps
   USE ParticleDeclarations
   USE GlobalDeclarations
   USE TreeDeclarations
   USE ParticleInfoOps

   IMPLICIT NONE
   PUBLIC  CalcMoments, CheckForNewParticles, DoAccretions, GetGasForces

   PRIVATE
CONTAINS

   !> Calculate contributions to sink particle moments from grids on maxlevel
   SUBROUTINE CalcMoments()
      TYPE(NodeDefList), POINTER :: nodelist
      TYPE(ParticleListDef), POINTER :: particlelist     
      particlelist=>SinkParticles
      DO WHILE (ASSOCIATED(particlelist))
         nodelist=>Nodes(MaxLevel)%p
         IF (particlelist%self%iaccrete == FEDERRATH_ACCRETION) THEN
            particlelist%self%moments=0
            DO WHILE (ASSOCIATED(nodelist))
               CALL CalcMoment(particlelist%self,nodelist%self%info,.false.)
               nodelist=>nodelist%next
            END DO
            !         write(*,*) "calculated moment for particle", particlelist%self%moments
         ELSEIF (particlelist%self%iaccrete == KRUMHOLZ_ACCRETION) THEN
            Particlelist%self%AccretionRate=0d0
            Particlelist%self%Bondi_kernel=0d0
            DO WHILE (ASSOCIATED(nodelist))
               CALL BondiAccretionRate(particlelist%self, nodelist%self%info)
               nodelist=>nodelist%next
            END DO
         END IF
         particlelist=>particlelist%next
      END DO
   END SUBROUTINE CalcMoments


   !> Checks maxlevel infos for new particles
   SUBROUTINE CheckForNewParticles()
      TYPE(NodeDefList), POINTER :: nodelist
      TYPE(ParticleDef), POINTER :: Particle, NewParticle      
      nodelist=>Nodes(MaxLevel)%p
      DO WHILE (ASSOCIATED(nodelist))
         CALL CheckForNewParticle(nodelist%self%info)
         nodelist=>nodelist%next
      END DO

      !      IF (MPI_ID == 0) THEN
      !         CALL CreateParticle(NewParticle)
      !         NewParticle%moments(1)=5
      !         NewParticle%mass=1
      !         NewParticle%xloc=(/2,3,4/)
      !         CALL AddNewSinkParticle(NewParticle)
      !      ELSE IF (MPI_ID == 1) THEN
      !         CALL CreateParticle(NewParticle)
      !         NewParticle%moments(1)=10
      !         NewParticle%mass=6
      !         NewParticle%xloc=(/7,8,9/)        
      !         CALL AddNewSinkParticle(NewParticle)
      !         NULLIFY(NewParticle)
      !         CALL CreateParticle(NewParticle)
      !         NewParticle%moments(1)=15
      !         NewParticle%mass=11
      !         NewParticle%xloc=(/12,13,14/)        
      !         CALL AddNewSinkParticle(NewParticle)
      !      END IF


   END SUBROUTINE CheckForNewParticles

   !> Performs accretion of maxlevel infos
   SUBROUTINE DoAccretions()
      TYPE(NodeDefList), POINTER :: nodelist
      TYPE(ParticleListDef), POINTER :: ParticleList
      IF (NrSinkParticles == 0) RETURN
      nodelist=>Nodes(MaxLevel)%p
      DO WHILE (ASSOCIATED(nodelist))
         CALL DoAccretion(nodelist%self%info)
         nodelist=>nodelist%next
      END DO
      
      !Now iterate adjusting mass accretion by massloss due to outflow particles
!      ParticleList=>SinkParticles
!      DO WHILE (ASSOCIATED(ParticleList))
!         IF (ASSOCIATED(ParticleList%self%OutflowObj)) THEN
!            ParticleList%self%dM=ParticleList%self%dM-ParticleList%self%OutflowObj%massloss
!            ParticleList%self%OutflowObj%massloss=0
!         END IF
!         ParticleList=>ParticleList%next
!      END DO
      
   END SUBROUTINE DoAccretions

   !> Performs accretion of maxlevel infos
   SUBROUTINE GetGasForces()
      TYPE(NodeDefList), POINTER :: nodelist
      TYPE(ParticleListDef), POINTER :: ParticleList

      IF (NrSinkParticles == 0) RETURN

      ParticleList=>SinkParticles
      DO WHILE (ASSOCIATED(ParticleList))
         ParticleList%self%gas_accel=0
         nodelist=>Nodes(MaxLevel)%p
         DO WHILE (ASSOCIATED(nodelist))
            CALL GetGasForce(ParticleList%self, nodelist%self%Info)
            nodelist=>nodelist%next
         END DO
         ParticleList=>ParticleList%next
      END DO
   END SUBROUTINE GetGasForces
END MODULE ParticleLevelOps
