!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    BE_module.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################

MODULE BE_MODULE


  USE DataDeclarations
  USE GlobalDeclarations
  USE PhysicsDeclarations

  IMPLICIT NONE
  PRIVATE          ! Everything is implicitly private, i.e. accessible only
                   ! to this module.



  REAL(KIND=qPrec) :: alpha, d, e
  PARAMETER(alpha = 0.551d0)
  PARAMETER(d = 3.84d-4)
  PARAMETER(e = EXP(one))

  PUBLIC CalcAmbientParams, BE_rho

CONTAINS

  SUBROUTINE CalcAmbientParams(central_rho, xi, clump_rad, M_star, at, rho_out, iso_t)

    ! Takes 3 provided parameters and returns the mass, isothermal sound speed, and the outer 
    !density. Formulas are taken from Stahler and Palla and from the analytical paper, 
    !Polytropic gas spheres: An approximate analytic solution of the Lane-Emden equation, F.K. Liu

    REAL(KIND=qPrec) :: central_rho, clump_rad, m_star, at, rho_out, iso_t
    REAL:: xi

    !All quantities assume CGS and mass density

    M_star = 8*PI*central_rho*clump_rad**3 *((1 + alpha)/(6 + xi**2) - (6*alpha)/(6 + xi**2)**2 - alpha/(3**(1/alpha)*12*e + xi**2) + D*(2**(-alpha)-1)/ (1+2**(-alpha) * D* xi**2)*(1+D*xi**2))

    at = (2*clump_rad*SQRT(PI*G*central_rho))/xi

    rho_out = central_rho*BE_RHO(xi)

    iso_t = (hmass*xmu*(at**2))/boltzmann ! assuming gamma = 1 for isothermal gas



  END SUBROUTINE CalcAmbientParams


  !   Function inputs nondimensional radius, xi, and returns nondimensional rho:

  FUNCTION BE_RHO(xi)
    REAL :: BE_RHO, xi

    BE_RHO = ((1.0+((xi**2)/((3.0**(1.0/alpha))*12.0*E)))**alpha)*(E**((alpha*((xi**2.0)/6.0))/(1.0+((xi**2)/6.0))))/(((1.0+((xi**2)/6.0))**(1.0+alpha))*(1.0+(((2.0**(-alpha))-1.0)*D*(xi**2)/(1.0+(D*(xi**2))))))

  END FUNCTION BE_RHO



END MODULE BE_MODULE
