!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    images.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
MODULE Images
   USE GlobalDeclarations
   USE IOPPM
   IMPLICIT NONE

   INTEGER, PARAMETER :: MaxCMapPoints=10

   TYPE ImageDef
      REAL(KIND=qPREC) :: minvalue=MINOVERALL
      REAL(KIND=qPREC) :: maxvalue=MAXOVERALL
      INTEGER :: Scaling=LINEARSCALE
      INTEGER, DIMENSION(MaxCMapPoints,3) :: cmap=reshape((/&
           0,  0,  0, &
           0,  0, 255, &
           0,  255, 255, &
           0, 255, 0, &
           255, 255, 0, &
           255, 0, 0, &
           0, 0, 0, &
           0, 0, 0,&
           0, 0, 0,&
           0, 0, 0/), (/MaxCMapPoints,3/),(/0/), (/2,1/))
      INTEGER :: npoints=6
   END type ImageDef

CONTAINS


   SUBROUTINE OutputImage(Image, name, data)
      USE IOPPM
      TYPE(ImageDef), POINTER :: Image
      REAL(KIND=qPREC) :: minvalue, maxvalue
      CHARACTER(LEN=88) :: FileName
      CHARACTER(LEN=*) :: name
      REAL(KIND=qPREC), DIMENSION(:,:) :: data
      IF (Image%minvalue==MINOVERALL) THEN
         minvalue=minval(data)
      ELSE
         minvalue=Image%minvalue
      END IF
      IF (Image%maxvalue==MAXOVERALL) THEN
         maxvalue=maxval(data)
      ELSE
         maxvalue=Image%maxvalue
      END IF
      WRITE(FileName,'(A4,A,A4)') 'out/', TRIM(NAME),'.ppm'
      IF (Image%Scaling==LOGSCALE) THEN
         CALL WritePPM(TRIM(Filename), Image%cmap(1:Image%npoints,:), log10(data), log10(minvalue),log10(maxvalue))
      ELSE
         CALL WritePPM(TRIM(FileName), Image%cmap(1:Image%npoints,:), data, minvalue,maxvalue)
      END IF
   END SUBROUTINE OutputImage

END MODULE Images
