!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    movies.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
MODULE Movies
   USE GlobalDeclarations
   USE Cameras
   USE Splines
   
   TYPE MovieDef
      TYPE(pSplineDef), DIMENSION(3) :: positions
      TYPE(pSplineDef), DIMENSION(3) :: focii
      TYPE(pSplineDef), DIMENSION(3) :: UpVectors
      INTEGER :: iFrame = 0
      INTEGER :: nFrames = 0
      REAL(KIND=qPREC), DIMENSION(:), POINTER :: times
   END type MovieDef

   CONTAINS

   SUBROUTINE InitMovie(Movie,nframes)
      TYPE(MovieDef), POINTER :: Movie
      INTEGER :: nframes
      REAL(KIND=qPREC), DIMENSION(:), POINTER :: times
      ALLOCATE(Movie)
      ALLOCATE(Movie%times(nframes))
      Movie%nframes=nframes
      DO i=1,3
         ALLOCATE(movie%positions(i)%p)
         ALLOCATE(movie%focii(i)%p)
         ALLOCATE(movie%upvectors(i)%p)
         Movie%positions(i)%p%x=>Movie%times
         Movie%focii(i)%p%x=>Movie%times
         Movie%upVectors(i)%p%x=>Movie%times
         ALLOCATE(Movie%positions(i)%p%y(nframes))
         ALLOCATE(Movie%focii(i)%p%y(nframes))
         ALLOCATE(Movie%UpVectors(i)%p%y(nframes))
      END DO
      Movie%iframe=0
   END SUBROUTINE InitMovie


   SUBROUTINE AddMovieCamera(Movie, Camera, time)
      TYPE(CameraDef) :: Camera
      TYPE(MovieDef) :: Movie
      REAL(KIND=qPREC) :: time
      INTEGER :: n, i
      n=Movie%iframe+1
      IF (n > Movie%nFrames) THEN
         write(*,*) 'Not enough frames initialized for movie - ignoring movie point'
         RETURN
      END IF
      Movie%iframe=n
      Movie%times(n)=time
      DO i=1,3
         Movie%positions(i)%p%y(n)=Camera%pos(i)
         Movie%focii(i)%p%y(n)=Camera%focus(i)
         Movie%upvectors(i)%p%y(n)=Camera%upvector(i)
      END DO
   END SUBROUTINE AddMovieCamera


   SUBROUTINE FinalizeMovie(Movie)
      INTEGER :: i
      TYPE(MovieDef) :: Movie
      DO i=1,3
         CALL SolveSpline(movie%positions(i)%p)
         CALL SolveSpline(movie%focii(i)%p)
         CALL SolveSpline(movie%upvectors(i)%p)
      END DO
   END SUBROUTINE FinalizeMovie

   SUBROUTINE UpdateMovieCamera(Movie, Camera)
      TYPE(CameraDef) :: Camera
      TYPE(MovieDef) :: Movie
      INTEGER :: i
      DO i=1,3
         Camera%pos(i)=GetSplineValue(Movie%positions(i)%p, levels(0)%tnow)
         Camera%focus(i)=GetSplineValue(Movie%focii(i)%p, levels(0)%tnow)
         Camera%upvector(i)=GetSplineValue(Movie%upvectors(i)%p, levels(0)%tnow)
      END DO
      CALL UpdateMatrix(Camera)
   END SUBROUTINE UpdateMovieCamera

END MODULE Movies
