!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    processing_declarations.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
!> @file processing_declarations.f90
!! @brief Main file for module ProcessingDeclarations

!> @defgroup ProcessingDeclarations Processing Declarations
!! @brief Module containing processing related variables
!! @ingroup Processing

!> Module containing processing related variables
!! @ingroup ProcessingDeclarations
MODULE ProcessingDeclarations
  USE Fields
  USE GlobalDeclarations
  IMPLICIT NONE
  PUBLIC
  SAVE

  INTEGER :: NrDiagnosticVars
  INTEGER :: Processing_mbc = 0 !Number of ghost zones needed for processing...

  TYPE DiagnosticListDef
     TYPE(FieldDef) :: Field
     TYPE(DiagnosticListDef), POINTER :: next
  END type DiagnosticListDef

  TYPE(DiagnosticListDef), POINTER :: FirstDiagnostic=>NULL(), LastDiagnostic=>NULL()
  CONTAINS


  !> Adds a diagnostic field and assigns it to slot i
  !! @param i integer to assign next slot
  !! @param str optional string to define variable 
  SUBROUTINE AddDiagnosticVar(i, str)
     INTEGER :: i
     CHARACTER(LEN=*), OPTIONAL :: str
     TYPE(DiagnosticListDef), POINTER :: Field
     NrDiagnosticVars=NrDiagnosticVars+1
     IF (ASSOCIATED(LastDiagnostic)) THEN
        ALLOCATE(LastDiagnostic%next)
        LastDiagnostic=>LastDiagnostic%next
     ELSE
        ALLOCATE(LastDiagnostic)
        FirstDiagnostic=>LastDiagnostic
     END IF
     LastDiagnostic%Field%id=i
     LastDiagnostic%Field%component=GASCOMP
     IF (PRESENT(str)) THEN
        LastDiagnostic%Field%Name=str
     ELSE
        LastDiagnostic%Field%Name=GetName(i)
     END IF
  END SUBROUTINE AddDiagnosticVar

END MODULE ProcessingDeclarations
!> @}
