!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    processing_info_ops.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
MODULE ProcessingInfoOps
   USE GlobalDeclarations
   USE DataDeclarations
   USE PhysicsDeclarations
   USE ProcessingDeclarations
   USE TreeDeclarations
   USE CoolingSrc
   USE SourceDeclarations
   USE EOS
   IMPLICIT NONE
   PUBLIC
CONTAINS

   SUBROUTINE StoreErrFlag(Info)
      TYPE(InfoDef) :: Info
      IF (Info%level < MaxLevel) THEN
         Info%diagnostics(1:Info%mX(1),1:Info%mX(2),1:Info%mX(3),iErrFlag)=Info%ErrFlag(1:Info%mX(1),1:Info%mX(2),1:Info%mX(3))
      ELSE
         Info%diagnostics(1:Info%mX(1),1:Info%mX(2),1:Info%mX(3),iErrFlag)=0
      END IF
   END SUBROUTINE StoreErrFlag

   SUBROUTINE StoreMPI_ID(Info)
      TYPE(InfoDef) :: Info
      Info%diagnostics(1:Info%mX(1),1:Info%mX(2),1:Info%mX(3),iMPI_ID)=MPI_ID
!      write(*,*) 'storing ', MPI_ID, iMPI_ID
   END SUBROUTINE StoreMPI_ID



   SUBROUTINE StoreCoolingLength(Info)
      TYPE(InfoDef) :: Info
      REAL(KIND=qPREC), DIMENSION(:), ALLOCATABLE :: dqdt
      REAL(KIND=qPREC), DIMENSION(:), POINTER :: q
      INTEGER :: i,j,k
      ALLOCATE(dqdt(NrHydroVars))
      DO i=1, Info%mX(1)
         DO j=1, Info%mX(2)
            DO k=1, Info%mX(3)
               dqdt=0
               q=>Info%q(i,j,k,1:NrHydroVars)
               CALL Cooling(q, dqdt, Cellpos(Info, i, j, k), levels(Info%level)%dx, CONSERVATIVE)
               Info%diagnostics(1:Info%mX(1),1:Info%mX(2),1:Info%mX(3),iCoolingLength)=-sqrt(gamma*Press(Info%q(i,j,k,:))/Info%q(i,j,k,1))*(q(iE)/dqdt(iE))
            END DO
         END DO
      END DO
      DEALLOCATE(dqdt)
   END SUBROUTINE StoreCoolingLength

   SUBROUTINE StoreTreeAvailability(node)
      TYPE(NodeDef) :: node
      TYPE(nodedeflist), pointer :: nodelist
      TYPE(InfoDef), POINTER :: Info
      INTEGER(8) :: neighbormask, overlapmask, childmask, parentmask
      INTEGER, PARAMETER :: MPI_TRACK = 0
      info=>node%info

      IF (iNeighborMask > 0) THEN
         neighbormask=0
         IF (MPI_ID == MPI_TRACK) neighbormask = 1
         !      neighbormask=ibset(neighbormask, MPI_ID)
         nodelist=>node%neighbors
         DO WHILE (ASSOCIATED(nodelist))
            !         neighbormask=ibset(neighbormask, nodelist%self%box%MPI_ID)
            IF ((nodelist%self%box%MPI_ID) == MPI_TRACK) neighbormask=1
            nodelist=>nodelist%next
         END DO
         Info%diagnostics(1:Info%mX(1),1:Info%mX(2),1:Info%mX(3),iNeighborMask)=REAL(neighbormask, kind=qprec)
      END IF
      IF (iOverlapMask > 0) THEN
         overlapmask=0
         IF (MPI_ID == MPI_TRACK) overlapmask=1
         !      overlapmask=ibset(overlapmask, MPI_ID)
         nodelist=>node%overlaps
         DO WHILE (ASSOCIATED(nodelist))
            IF ((nodelist%self%box%MPI_ID) == MPI_TRACK) overlapmask=1
            !         overlapmask=ibset(overlapmask, nodelist%self%box%MPI_ID)
            nodelist=>nodelist%next
         END DO
         Info%diagnostics(1:Info%mX(1),1:Info%mX(2),1:Info%mX(3),iOverlapMask)=REAL(overlapmask, kind=qprec)
      END IF
      IF (iParentMask > 0) THEN
         parentmask=0
         IF (MPI_ID == MPI_TRACK) parentmask=1
         IF ((node%parent%box%MPI_ID) == MPI_TRACK) parentmask=1
         !      parentmask=ibset(parentmask, MPI_ID)
         !      parentmask=ibset(parentmask, node%parent%box%MPI_ID)
         Info%diagnostics(1:Info%mX(1),1:Info%mX(2),1:Info%mX(3),iParentMask)=REAL(parentmask, kind=qprec)
         
      END IF
      IF (iChildMask > 0) THEN
         childmask=0
         IF (MPI_ID == MPI_TRACK) childmask=1
         !      childmask=ibset(childmask, MPI_ID)
         nodelist=>node%children
         DO WHILE (ASSOCIATED(nodelist))
            IF ((nodelist%self%box%MPI_ID) == MPI_TRACK) childmask=1
            !         childmask=ibset(childmask, nodelist%self%box%MPI_ID)
            nodelist=>nodelist%next
         END DO
         Info%diagnostics(1:Info%mX(1),1:Info%mX(2),1:Info%mX(3),iChildmask)=REAL(childmask, kind=qprec)
      END IF
   END SUBROUTINE StoreTreeAvailability

END MODULE ProcessingInfoOps
