//#########################################################################
//		
//    Copyright (C) 2003-2012 Department of Physics and Astronomy,
//                            University of Rochester,
//                            Rochester, NY
//
//    fpth_lib.c is part of AstroBEAR.
//
//    AstroBEAR is free software: you can redistribute it and/or modify	  
//    it under the terms of the GNU General Public License as published by 
//    the Free Software Foundation, either version 3 of the License, or    
//    (at your option) any later version.
//
//    AstroBEAR is distributed in the hope that it will be useful, 
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
//
//#########################################################################
/*! \file fpthread_lib.c
\brief Wrapper file for pthreads
*/
#include <pth.h>

#include <stdio.h>
//#include <stdlib.h>
//#include <errno.h>
//#include <sched.h>



void fpth_init_(int *ierr)

{
  *ierr = pth_init();
  return;
}

void fpth_spawn_(pth_t *thread, pth_attr_t *attr, void (*start_routine)(void*), void *data)
{
  *thread = pth_spawn(*attr, (void*)start_routine, data);
  return;
}


void fpth_resume_(pth_t *thread, int *ierr)
{
  *ierr = pth_resume(*thread);
  return;
}

void fpth_suspend_(pth_t *thread, int *ierr)
{
  *ierr = pth_suspend(*thread);
  return;
}

void fpth_yield_(pth_t *thread, int *ierr)
{
  *ierr = pth_yield(*thread);
  return;
}

void fpth_yield_any_(int *ierr)
{
  *ierr = pth_yield(NULL);
  return;
}

void fpth_join_(pth_t *thread, void **value, int *ierr)
{
  *ierr = pth_join(*thread,(void**) value);
  return;
}

void fpth_exit_(void *data)
{
  pth_exit((void *)data);
  return;
}


void fpth_self_(pth_t *thread)
{
  *thread = pth_self();
  return;
}


void fpth_attr_of_(pth_attr_t *attr, pth_t *thread)
{
  *attr=pth_attr_of(*thread);
  return;
}

void fpth_attr_new_(pth_attr_t *attr)
{
  *attr=pth_attr_new();
  return;
}

void fpth_attr_init_(pth_attr_t *attr, int *ierr)
{
  *ierr=pth_attr_init(*attr);
  return;
}


/*void fpth_attr_set_(pth_attr_t *attr, int *field, void *data, int *ierr)
{
  *ierr=pth_attr_set(*attr, *field, (void**)data);
  return;
}
*/

void fpth_attr_get_(pth_attr_t *attr, int *field, void *data, int *ierr)
{
  *ierr=pth_attr_get(*attr, *field, data);
  return;
}

void fpth_attr_get_stacksize_(pth_attr_t *attr, int *data, int *ierr)
{
  unsigned stacksize;
  *ierr=pth_attr_get(*attr, PTH_ATTR_STACK_SIZE, stacksize);
  *data=stacksize;
  return;
}

void fpth_attr_set_stacksize_(pth_attr_t *attr, int *data, int *ierr)
{
  unsigned stacksize;
  stacksize = *data;
  *ierr=pth_attr_set(*attr, PTH_ATTR_STACK_SIZE, stacksize);
  return;
}


void fpth_attr_set_prio_(pth_attr_t *attr, int *data, int *ierr)
{
  *ierr=pth_attr_set(*attr, PTH_ATTR_PRIO, *data);
  return;
}

