!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    pth_control.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
! This module controls the spawning and joining of advance threads as well as the initialization of the threads and the advancing of grids
MODULE PthControl
  USE PthDeclarations
  USE HyperbolicControl
  IMPLICIT NONE
CONTAINS

   SUBROUTINE PthInit()
      INTEGER :: n, ierr
      CALL fpth_self(control_thread)
      CALL fpth_attr_of(control_attribute, control_thread)
      CALL fpth_attr_set_prio(control_attribute, FPTH_PRIO_MAX, ierr)
      CALL pth_checkerr(ierr, 'fpth_set_priority')
      DO n=0, MaxLevel
         CALL fpth_attr_new(advance_attributes(n))
         CALL fpth_attr_set_prio(advance_attributes(n), FPTH_PRIO_MIN, ierr)
         CALL pth_checkerr(ierr, 'fpth_set_priority')
      END DO
      lAdvanceActive=.false.
      lAdvanceCompleted=.true.
      threadarg(-2:MaxLevel)=(/(n,n=-2,MaxLevel)/)
!      write(*,*) threadarg
!      CALL fpth_attr_new(comm_attribute)
!      CALL fpth_attr_set_stacksize(comm_attribute, ADVANCE_STACKSIZE, ierr)
!      CALL pth_checkerr(ierr, 'fpth_set_stacksize')
!      CALL fpth_attr_set_prio(comm_attribute, FPTH_PRIO_MIN, ierr)
!      CALL pth_checkerr(ierr, 'fpth_set_priority')
      lControlActive=.true.
      Curr_TestType=TESTNONE
!      IF (MPI_ID == 0) pVerbose = 1
   END SUBROUTINE PthInit


   SUBROUTINE LaunchAdvanceThread(n)
      USE DataLevelOps
      INTEGER :: n, ierr,i
      DO i=n-1,0,-1
         IF (lAdvanceActive(i)) THEN
            IF (pVerbose >= 1) write(*,*) 'suspending', i
            lAdvanceActive(i)=.false.
            CALL fpth_suspend(advance_threads(i), ierr)
            CALL pth_checkerr(ierr, 'fpth_suspend')
!            EXIT
         END IF
      END DO
      IF (pverbose >= 1) write(*,*) 'spawning', n, threadarg(n)
      lAdvanceActive(n)=.true.
      lAdvanceCompleted(n)=.false.
      CALL fpth_attr_set_stacksize(advance_attributes(n), AdvanceStackSize(n), ierr)
      CALL pth_checkerr(ierr, 'fpth_set_stacksize')
      CALL fpth_spawn(advance_threads(n), advance_attributes(n), PthAdvanceGrids, threadarg(n))
    END SUBROUTINE LaunchAdvanceThread

   SUBROUTINE JoinAdvanceThread(n)
      INTEGER :: n, ierr
      TYPE(IntStatus) :: status
      IF (pVerbose >= 1) write(*,*) 'joining', n
      ! If we give up control at the join - then we will want it back immediately
      
      lControlActive=.false.   
      CALL fpth_join(advance_threads(n), status, ierr)
      CALL pth_checkerr(ierr, 'fpth_join')
      levels(n)%tnow=levels(n)%tnow+levels(n)%dt
      lControlActive=.true.
      !Resume next lower advance thread that has not compoleted
      IF (pverbose >= 1) write(*,*) 'im back'
      IF (status%val /= n) THEN
         PRINT*, 'exit code unexpected', status%val
         STOP
      END IF

   END SUBROUTINE JoinAdvanceThread

   !> Routine to advance grids
   !! @param n level  
   SUBROUTINE PthAdvanceGrids(n)
      USE TreeDeclarations
      USE DataDeclarations
      USE HyperbolicControl
      USE HyperbolicDeclarations
      USE Scheduling
      INTEGER :: n,i,ierr
      TYPE(NodeDef), POINTER :: node
      TYPE(NodeDefList), POINTER :: nodelist
      ! Yield back to control thread if not on max level
 !     IF (n < MaxLevel) THEN
 !        IF (pVerBose >= 1) write(*,*) 'yielding back to control thread'
 !        CALL fpth_yield(control_thread, ierr)
 !        CALL Pth_checkerr(ierr, 'fpth_yield')
 !     END IF

      CALL StartTimer(iAdvanceGrids, n)

      IF (pVerbose >= 1) write(*,*) 'beginning advance', n
      if (levels(n)%dt > 0d0) THEN
         nodelist=>Nodes(n)%p 
         DO WHILE (associated(nodelist))
            node=>nodelist%self
            CALL Advance(node%info, .true.) 
            IF (.NOT. nodecompleted(n)) THEN
               write(*,*) 'error - node not updated'
               STOP
            END IF
            nodelist=>nodelist%next 
         END DO
           
      END if
      CALL StopTimer(iAdvanceGrids, n)
         
      DO i=n-1,0,-1
         IF (.NOT. lAdvanceCompleted(i)) THEN
            CALL fpth_resume(advance_threads(i), ierr)
            CALL Pth_checkerr(ierr, 'fpth_resume')
            lAdvanceActive(i)=.true.
            IF (pverbose >= 1) write(*,*) 'resuming advance thread', i
            EXIT
         END IF
      END DO
      lAdvanceActive(n)=.false.
      lAdvanceCompleted(n)=.true.
      returnstatus(n)=n
      IF (pverbose >= 1) write(*,*) 'thread', n, 'exiting'
      CALL fpth_exit(returnstatus(n))
   END SUBROUTINE PthAdvanceGrids


   
END module PthControl
