#!/bin/bash
# "subst", a script that substitutes one pattern for
# another in a file,
# i.e., "subst Smith Jones letter.txt".
ARGS=3
E_BADARGS=65   # Wrong number of arguments passed to script.
if [ $# -ne "$ARGS" ]
# Test number of arguments to script (always a good idea).
then
  echo "Usage: `basename $0` variable new-value filename"
  exit $E_BADARGS
 fi

 var_pattern=$1
 new_value=$2

 if [ -f "$3" ]
 then
     file_name=$3
 else
     echo "File \"$3\" does not exist."
     exit $E_BADARGS
 fi

 # Here is where the heavy work gets done.
newfile="$file_name""2"

 sed -e "s/$var_pattern\(\s*=\s*\)\S*/$var_pattern\1$new_value/i" $file_name | uniq > $newfile
mv $newfile $file_name

 # I'm sure there is a better way then to pipe the output through unique but I got frustrated trying JJC
 # 's' is, of course, the substitute command in sed,
 # and /pattern/ invokes address matching.
 # The (\s*=\s*\) matches (and saves) all of the white space on either side of the equals sign
 # The \S* terminates at the first non-white space character which is presumably the end of the variable value
 # Note for array definitions like qTolerance = 1e-3 1e-3 1e-3, this will replace only the first value.
 # This can be avoided by editing your data files to remove white space in array declarations (ie qTolerance = 1e-3,1e-3,1e-3)

 exit 0    # Successful invocation of the script returns 0.
