!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    rotating.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
MODULE RotatingSrc

  USE DataDeclarations
  USE PhysicsDeclarations
  USE EOS
  USE SourceDeclarations

  IMPLICIT NONE
  PRIVATE
  PUBLIC Rotating
  
CONTAINS

  SUBROUTINE Rotating(q,dqdt,pos,lform)
    ! Interface declarations
    REAL(KIND=qPrec) :: q(:)
    REAL(KIND=qPrec),INTENT(INOUT) :: dqdt(:)
    REAL(KIND=xPrec) :: pos(:)
    LOGICAL :: lform
    
    SELECT CASE(lform)
    CASE(PRIMITIVE)
       CALL PrimRot(q,dqdt,pos)
    CASE(CONSERVATIVE)
       CALL ConsRot(q,dqdt,pos)
    END SELECT

  END SUBROUTINE Rotating

  !> Rotating source term, primitive variables formulation
  SUBROUTINE PrimRot(q,dqdt,pos)
    ! Interface declarations
    REAL(KIND=qPrec) :: q(:)
    REAL(KIND=qPrec),INTENT(INOUT) :: dqdt(:)
    REAL(KIND=xPrec) :: pos(:)
    ! Local declarations
    REAL(KIND=qPrec) :: r

    ! local vars for readability

    r=sqrt(sum(pos(1:2)**2))
    
    !centrifugal force ( a_coriolis = -2*omega cross v )
    dqdt(imom(1:2))=dqdt(imom(1:2))-2d0*OmegaRot*(/-q(imom(2)), +q(imom(1))/)
    
    !centripetal force ( a_centrip = -omega cross (omega cross r) ) 
    dqdt(imom(1:2))=dqdt(imom(1:2))+OmegaRot**2*pos(1:2)
!    write(*,*) r, OmegaRot, dqdt(imom(1:2))
  END SUBROUTINE PrimRot


  !> Rotating source term, conservative variables formulation
  SUBROUTINE ConsRot(q,dqdt,pos)!,rotobj)
    ! Interface declarations
    REAL(KIND=qPrec) :: q(:)
    REAL(KIND=qPrec),INTENT(INOUT) :: dqdt(:)
    REAL(KIND=xPrec) :: pos(:)
    ! Local declarations
    REAL(KIND=qPrec) :: r

    write(*,*) 'consrot not implemented yet'
    STOP

    ! local vars for readability

    r=sqrt(sum(pos(1:2)**2))
    
    !centrifugal force ( a_coriolis = -2*omega cross v )
    dqdt(imom(1:2))=dqdt(imom(1:2))-2d0*OmegaRot*(/-q(imom(2)), +q(imom(1))/)
    
    !centripetal force ( a_centrip = -omega cross (omega cross r) ) 
    dqdt(imom(1:2))=dqdt(imom(1:2))+OmegaRot**2*pos(1:2)*q(1)
  END SUBROUTINE ConsRot
END MODULE RotatingSrc
