!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    selfgravity.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
MODULE SelfGravitySrc
   USE DataDeclarations
   USE PhysicsDeclarations
   USE EOS
   USE SourceDeclarations
   IMPLICIT NONE
   PRIVATE
   PUBLIC :: SelfGravity

CONTAINS



   SUBROUTINE SelfGravity(q,dqdt,x,dx,t,Info,ip,lform)
      ! Interface declarations
      TYPE(InfoDef) :: Info
      INTEGER :: ip(3),ir(3),il(3)
      REAL(KIND=qPrec) :: q(:)
      REAL(KIND=qPrec) :: dqdt(:),x(3),dx,pos(3),t, pOffset(3),r2,r,f_grav(3)
      ! Internal declarations
      INTEGER :: level,i,j
      INTEGER :: smbc
      REAL(KIND=qPREC), DIMENSION(:,:,:), ALLOCATABLE :: gradPhi, Phi, rho
      LOGICAL :: lform
      level=Info%level
      ir=ip
      il=ip
!      DO i=ip(1)-1,ip(1)+1
!         DO j=ip(2)-1,ip(2)+1
!            IF (iSNAN(Info%q(i,j,1,iPhiGas))) THEN
!               write(*,*) 'found NAN in phi at', i,j
!               write(*,*) 'ip =', ip
!               write(*,*) 'x=', Info%xBounds(1:2,1)+levels(Info%level)%dx*REAL((/i,j/)-.5d0)
!               STOP
!            END IF
!            IF (iSNAN(Info%q(i,j,1,iPhiDot))) THEN
!               write(*,*) 'found NAN in phiDot at', i,j
!               write(*,*) 'ip =', ip
!               write(*,*) 'x=', Info%xBounds(1:2,1)+levels(Info%level)%dx*REAL((/i,j/)-.5d0)
!               STOP
!            END IF
!         END DO
!      END DO
      DO i=1,nDim
         ir(i)=min(ip(i)+1,uBound(Info%q,i))
         il(i)=max(ir(i)-2,lBound(Info%q,i))
         ir(i)=il(i)+2
         f_grav(i)=((Info%q(ir(1),ir(2),ir(3),iPhiGas)-Info%q(il(1),il(2),il(3),iPhiGas)))/2d0 !+ &
!              (t-levels(level)%tnow)*(Info%q(ir(1),ir(2),ir(3),iPhiDot)-Info%q(il(1),il(2),il(3),iPhiDot))/2d0
         ir(i)=ip(i)
         il(i)=ip(i)
      END DO
!      elliptic_maxspeed(level)=max(elliptic_maxspeed(level),sqrt(nDim*(maxval(abs(f_grav)))))
      f_grav(1:nDim)=-f_grav(1:nDim)/levels(level)%dx
      IF (lform .eqv. PRIMITIVE) THEN
         dqdt(imom(1:nDim))=dqdt(imom(1:nDim))+f_grav(1:nDim)
      ELSE
         dqdt(imom(1:nDim))=dqdt(imom(1:nDim))+f_grav(1:nDim)*q(1)
         IF (iE .ne. 0) dqdt(iE)=dqdt(iE)+SUM(f_grav(1:nDim)*q(imom(1:nDim)))
      END IF

   END SUBROUTINE SelfGravity

END MODULE SelfGravitySrc
