!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    source_declarations.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
!> @file source_declarations.f90
!! @brief Main file for module SourceDeclarations

!> @defgroup SourceDeclarations Source Declarations
!! @brief Module containing source related variables
!! @ingroup Source

!> Module containing source related variables
!! @ingroup SourceDeclarations
MODULE SourceDeclarations

  USE GlobalDeclarations

  IMPLICIT NONE
  PUBLIC

  TYPE SourcesDef
     INTEGER :: iSrcSolveType
     INTEGER :: iVerbosity
     INTEGER :: level
     LOGICAL :: lPrimitive
     ! tolerance for source terms (may vary with AMR level)
     REAL(KIND=qPrec) :: SrcTol
     LOGICAL :: lCooling
     LOGICAL :: lCylindrical
     LOGICAL :: luniformgravity
     LOGICAL :: lPointGravity
     LOGICAL :: lOutflows
  END TYPE SourcesDef

!!$  TYPE CoolingParamsDef
!!$     REAL(KIND=qPrec) :: alpha,beta
!!$     INTEGER :: coolingtype
!!$  END TYPE CoolingParamsDef
!!$
!!$  TYPE CylindricalParamsDef
!!$     
!!$  END TYPE CylindricalParamsDef


  ! multiplicative (alpha) and exponent (beta) constants for analytic cooling
  !REAL(KIND=qPrec) :: GravNormalVector(3),GravAccel
  !REAL(KIND=qPrec) :: GravPoint(3),mCentral
  

  ! Parameters for iSrcSolveType
  INTEGER,PARAMETER :: NoSource=0,ExplicitSource=1,ImplicitSource=2,ExactSource=3

  LOGICAL, PARAMETER :: PRIMITIVE=.true., CONSERVATIVE=.false.

  INTEGER :: SourceMethod=0

  INTEGER, PARAMETER :: OPERATORSPLIT=0, NONOPERATORSPLIT=1

  !! Parameters for iSrcType
  !INTEGER,PARAMETER :: coolingtype=1,cylindricaltype=2,outflowtype=3,uniformgravitytype=4,pointgravitytype=5




END MODULE SourceDeclarations
