!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    uniformgravity.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
MODULE UniformGravitySrc
   USE GlobalDeclarations
   USE DataDeclarations
   USE PhysicsDeclarations
   USE EOS
   USE SourceDeclarations
   IMPLICIT NONE
   REAL(KIND=qPREC), DIMENSION(3), PARAMETER :: f_grav=(/0d0,1d0,0d0/)

CONTAINS
  SUBROUTINE UniformGravity_src(q,dqdt,t,lform)
     REAL(KIND=qPrec) :: q(:)
     REAL(KIND=qPREC) :: dqdt(:)
     LOGICAL :: lform
     REAL(KIND=qPREC) :: t
     IF (lform .eqv. PRIMITIVE) THEN
        dqdt(imom(1:nDim))=dqdt(imom(1:nDim)) - UniformGravity * f_grav(1:nDim)
     ELSE
        dqdt(imom(1:nDim))=dqdt(imom(1:nDim)) - UniformGravity * f_grav(1:nDim) * q(1)
        IF (iE .ne. 0) dqdt(iE)=dqdt(iE) - UniformGravity * q(3)
     END IF
  END SUBROUTINE UniformGravity_src
END MODULE UniformGravitySrc
